/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.jmesa.core.CoreContext;
import org.jmesa.view.component.Column;
import org.jmesa.view.component.Row;
import org.jmesa.view.component.Table;
import org.jmesa.view.excel.ExcelView;

public class OCExcelView
extends ExcelView {
    public OCExcelView(Table table, CoreContext coreContext) {
        super(table, coreContext);
    }

    public Object render() {
        HSSFWorkbook workbook = new HSSFWorkbook();
        Table table = this.getTable();
        String caption = table.getCaption();
        if (StringUtils.isEmpty((String)caption)) {
            caption = "JMesa Export";
        }
        HSSFSheet sheet = workbook.createSheet(caption);
        Row row = table.getRow();
        row.getRowRenderer();
        List columns = table.getRow().getColumns();
        HSSFRow hssfRow = sheet.createRow(0);
        int columncount = 0;
        for (Column col : columns) {
            HSSFCell cell = hssfRow.createCell((int)((short)columncount++));
            HSSFRichTextString richTextString = workbook.getCreationHelper().createRichTextString(col.getTitle());
            cell.setCellValue((RichTextString)richTextString);
        }
        Collection items = this.getCoreContext().getPageItems();
        int rowcount = 1;
        for (Object item : items) {
            HSSFRow r = sheet.createRow(rowcount++);
            columncount = 0;
            for (Column col : columns) {
                HSSFCell cell = r.createCell((int)((short)columncount++));
                Object value = col.getCellRenderer().render(item, rowcount);
                if (value == null) {
                    value = "";
                }
                if (value instanceof Number) {
                    Double number = Double.valueOf(value.toString());
                    cell.setCellValue(number.doubleValue());
                    continue;
                }
                HSSFRichTextString richTextString = workbook.getCreationHelper().createRichTextString(value.toString());
                cell.setCellValue((RichTextString)richTextString);
            }
        }
        return workbook;
    }
}

