/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.OpenClinicaVersionDAO;
import org.akaza.openclinica.dao.hibernate.UsageStatsServiceDAO;
import org.akaza.openclinica.domain.OpenClinicaVersionBean;
import org.akaza.openclinica.service.usageStats.LogUsageStatsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCServletContextListener
implements ServletContextListener {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    UsageStatsServiceDAO usageStatsServiceDAO;
    OpenClinicaVersionDAO openClinicaVersionDAO;
    public static String OpenClinicaVersion = "OpenClinica.version";

    public void contextDestroyed(ServletContextEvent event) {
        this.logger.debug("OCServletContextListener -> contextDestroyed");
        ServletContext context = event.getServletContext();
        this.getUsageStatsServiceDAO(context).saveOCStopTimeToDB();
    }

    public void contextInitialized(ServletContextEvent event) {
        this.logger.debug("OCServletContextListener -> contextInitialized");
        CoreResources cr = (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)event.getServletContext()).getBean("coreResources");
        ServletContext context = event.getServletContext();
        this.getOpenClinicaVersionDAO(context).saveOCVersionToDB(CoreResources.getField((String)OpenClinicaVersion));
        Map OCStartEventDetails = this.getEventDetailsOCStart(context);
        LogUsageStatsService.logEventOCStart((Map)OCStartEventDetails);
        this.getUsageStatsServiceDAO(context).saveOCStartTimeToDB();
    }

    private Map<String, String> getEventDetailsOCStart(ServletContext context) {
        Map OCStartEventDetails = this.getUsageStatsServiceDAO(context).getEventDetailsOCStart();
        OpenClinicaVersionBean openClinicaVersionBean = this.getOpenClinicaVersionDAO(context).findDefault();
        if (null != openClinicaVersionBean) {
            OCStartEventDetails.put("OC Version", openClinicaVersionBean.getName());
        }
        return OCStartEventDetails;
    }

    private UsageStatsServiceDAO getUsageStatsServiceDAO(ServletContext context) {
        this.usageStatsServiceDAO = this.usageStatsServiceDAO != null ? this.usageStatsServiceDAO : (UsageStatsServiceDAO)SpringServletAccess.getApplicationContext((ServletContext)context).getBean("usageStatsServiceDAO");
        return this.usageStatsServiceDAO;
    }

    private OpenClinicaVersionDAO getOpenClinicaVersionDAO(ServletContext context) {
        this.openClinicaVersionDAO = this.openClinicaVersionDAO != null ? this.openClinicaVersionDAO : (OpenClinicaVersionDAO)SpringServletAccess.getApplicationContext((ServletContext)context).getBean("openClinicaVersionDAO");
        return this.openClinicaVersionDAO;
    }
}

