/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class BatchCRFMigrationServlet
extends SecureController {
    private static String CRF_ID = "crfId";
    private static String CRF = "crf";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        ArrayList<CRFVersionBean> crfVersionList = null;
        ArrayList<StudyEventDefinitionBean> eventList = null;
        ArrayList<StudyBean> siteList = null;
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        int crfId = fp.getInt(CRF_ID);
        if (crfId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_view"));
            this.forwardPage(Page.CRF_LIST);
        } else {
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFVersionDAO vdao = new CRFVersionDAO(this.sm.getDataSource());
            CRFBean crf = (CRFBean)cdao.findByPK(crfId);
            this.request.setAttribute("crfName", (Object)crf.getName());
            ArrayList versions = (ArrayList)vdao.findAllByCRF(crfId);
            crfVersionList = new ArrayList<CRFVersionBean>();
            for (CRFVersionBean version : versions) {
                if (!version.getStatus().isAvailable()) continue;
                crfVersionList.add(version);
            }
            crf.setVersions(crfVersionList);
            ArrayList listOfSites = (ArrayList)this.sdao().findAllByParent(this.currentStudy.getId());
            siteList = new ArrayList<StudyBean>();
            StudyBean studyBean = new StudyBean();
            studyBean.setOid(this.currentStudy.getOid());
            studyBean.setName(resterm.getString("Study_Level_Subjects_Only"));
            siteList.add(studyBean);
            for (Object s : listOfSites) {
                if (!s.getStatus().isAvailable()) continue;
                siteList.add((StudyBean)s);
            }
            ArrayList listOfDefn = this.seddao().findAllByStudy(this.currentStudy);
            eventList = new ArrayList<StudyEventDefinitionBean>();
            for (StudyEventDefinitionBean d : listOfDefn) {
                if (!d.getStatus().isAvailable()) continue;
                eventList.add(d);
            }
            String crfVersionChangeMsg = fp.getString("isFromCRFVersionBatchChange");
            if (crfVersionChangeMsg != null && !crfVersionChangeMsg.equals("")) {
                this.addPageMessage(crfVersionChangeMsg);
            }
            this.request.setAttribute("study", (Object)this.currentStudy);
            this.request.setAttribute("siteList", siteList);
            this.request.setAttribute("eventList", eventList);
            this.request.setAttribute(CRF, (Object)crf);
            this.forwardPage(Page.BATCH_CRF_MIGRATION);
        }
    }

    private StudyDAO sdao() {
        return new StudyDAO(this.sm.getDataSource());
    }

    private StudyEventDefinitionDAO seddao() {
        return new StudyEventDefinitionDAO(this.sm.getDataSource());
    }
}

