/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.job.ImportStatefulJob;
import org.akaza.openclinica.web.job.TriggerService;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;
import org.springframework.scheduling.quartz.JobDetailBean;

public class CreateJobImportServlet
extends SecureController {
    private static String SCHEDULER = "schedulerFactoryBean";
    private static String IMPORT_TRIGGER = "importTrigger";
    public static final String DATE_START_JOB = "job";
    public static final String EMAIL = "contactEmail";
    public static final String JOB_NAME = "jobName";
    public static final String JOB_DESC = "jobDesc";
    public static final String USER_ID = "user_id";
    public static final String HOURS = "hours";
    public static final String MINUTES = "minutes";
    public static final String DIRECTORY = "filePathDir";
    public static final String DIR_PATH = "scheduled_data_import";
    public static final String STUDY_ID = "studyId";
    private StdScheduler scheduler;

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private StdScheduler getScheduler() {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(SCHEDULER);
        return this.scheduler;
    }

    private void setUpServlet() throws Exception {
        String directory = SQLInitServlet.getField((String)"filePath") + DIR_PATH + File.separator;
        this.logger.debug("found directory: " + directory);
        FormProcessor fp2 = new FormProcessor(this.request);
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList all = (ArrayList)sdao.findAll();
        ArrayList<StudyBean> finalList = new ArrayList<StudyBean>();
        for (StudyBean sb : all) {
            if (sb.getParentStudyId() > 0) continue;
            finalList.add(sb);
            finalList.addAll(sdao.findAllByParent(sb.getId()));
        }
        this.addEntityList("studies", finalList, respage.getString("a_user_cannot_be_created_no_study_as_active"), Page.ADMIN_SYSTEM);
        this.request.setAttribute("filePath", (Object)directory);
        this.request.setAttribute(JOB_NAME, (Object)fp2.getString(JOB_NAME));
        this.request.setAttribute(JOB_DESC, (Object)fp2.getString(JOB_DESC));
        this.request.setAttribute(EMAIL, (Object)fp2.getString(EMAIL));
        this.request.setAttribute(HOURS, (Object)new Integer(fp2.getInt(HOURS)).toString());
        this.request.setAttribute(MINUTES, (Object)new Integer(fp2.getInt(MINUTES)).toString());
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        TriggerService triggerService = new TriggerService();
        this.scheduler = this.getScheduler();
        String action = fp.getString("action");
        if (StringUtil.isBlank((String)action)) {
            this.setUpServlet();
            this.forwardPage(Page.CREATE_JOB_IMPORT);
        } else if ("confirmall".equalsIgnoreCase(action)) {
            HashMap errors = triggerService.validateImportJobForm(fp, this.request, this.scheduler.getTriggerNames(IMPORT_TRIGGER));
            if (!errors.isEmpty()) {
                this.request.setAttribute("formMessages", (Object)errors);
                this.logger.debug("has validation errors in the first section" + errors.toString());
                this.setUpServlet();
                this.forwardPage(Page.CREATE_JOB_IMPORT);
            } else {
                this.logger.info("found no validation errors, continuing");
                int studyId = fp.getInt(STUDY_ID);
                StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
                StudyBean studyBean = (StudyBean)studyDAO.findByPK(studyId);
                SimpleTrigger trigger = triggerService.generateImportTrigger(fp, this.sm.getUserBean(), studyBean, LocaleResolver.getLocale((HttpServletRequest)this.request).getLanguage());
                JobDetailBean jobDetailBean = new JobDetailBean();
                jobDetailBean.setGroup(IMPORT_TRIGGER);
                jobDetailBean.setName(trigger.getName());
                jobDetailBean.setJobClass(ImportStatefulJob.class);
                jobDetailBean.setJobDataMap(trigger.getJobDataMap());
                jobDetailBean.setDurability(true);
                jobDetailBean.setVolatility(false);
                try {
                    Date dateStart = this.scheduler.scheduleJob((JobDetail)jobDetailBean, (Trigger)trigger);
                    this.logger.debug("== found job date: " + dateStart.toString());
                    this.addPageMessage("You have successfully created a new job: " + trigger.getName() + " which is now set to run at the time you specified.");
                    this.forwardPage(Page.VIEW_IMPORT_JOB_SERVLET);
                }
                catch (SchedulerException se) {
                    se.printStackTrace();
                    this.setUpServlet();
                    this.addPageMessage("There was an unspecified error with your creation, please contact an administrator.");
                    this.forwardPage(Page.CREATE_JOB_IMPORT);
                }
            }
        } else {
            this.forwardPage(Page.ADMIN_SYSTEM);
        }
    }
}

