/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.hibernate.DynamicsItemFormMetadataDao;
import org.akaza.openclinica.dao.hibernate.DynamicsItemGroupMetadataDao;
import org.akaza.openclinica.dao.hibernate.RuleActionRunLogDao;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupMetadataDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class DeleteEventCRFServlet
extends SecureController {
    public static String STUDY_SUB_ID = "ssId";
    public static String EVENT_CRF_ID = "ecId";
    DiscrepancyNoteDAO dnDao;
    RuleActionRunLogDao ruleActionRunLogDao;
    DynamicsItemFormMetadataDao dynamicsItemFormMetadataDao;
    DynamicsItemGroupMetadataDao dynamicsItemGroupMetadataDao;
    ItemFormMetadataDAO ifmdao;
    ItemDataDAO iddao;
    ItemGroupMetadataDAO igmdao;
    StudyEventDAO sedao;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int studySubId = fp.getInt(STUDY_SUB_ID, true);
        int eventCRFId = fp.getInt(EVENT_CRF_ID);
        String action = this.request.getParameter("action");
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        if (eventCRFId == 0) {
            this.addPageMessage(respage.getString("please_choose_an_event_CRF_to_delete"));
            this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
        } else {
            EventCRFBean eventCRF = (EventCRFBean)ecdao.findByPK(eventCRFId);
            StudySubjectBean studySub = (StudySubjectBean)subdao.findByPK(studySubId);
            this.request.setAttribute("studySub", (Object)studySub);
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
            int crfVersionId = eventCRF.getCRFVersionId();
            CRFBean cb = cdao.findByVersionId(crfVersionId);
            eventCRF.setCrf(cb);
            CRFVersionBean cvb = (CRFVersionBean)cvdao.findByPK(crfVersionId);
            eventCRF.setCrfVersion(cvb);
            int studyEventId = eventCRF.getStudyEventId();
            StudyEventBean event = (StudyEventBean)sedao.findByPK(studyEventId);
            int studyEventDefinitionId = sedao.getDefinitionIdFromStudyEventId(studyEventId);
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(studyEventDefinitionId);
            event.setStudyEventDefinition(sed);
            this.request.setAttribute("event", (Object)event);
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
            StudyBean study = (StudyBean)sdao.findByPK(studySub.getStudyId());
            EventDefinitionCRFBean edc = edcdao.findByStudyEventDefinitionIdAndCRFId(study, studyEventDefinitionId, cb.getId());
            DisplayEventCRFBean dec = new DisplayEventCRFBean();
            dec.setEventCRF(eventCRF);
            dec.setFlags(eventCRF, this.ub, this.currentRole, edc.isDoubleEntry());
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            this.dnDao = new DiscrepancyNoteDAO(this.sm.getDataSource());
            ArrayList itemData = iddao.findAllByEventCRFId(eventCRF.getId());
            this.request.setAttribute("items", (Object)itemData);
            if ("confirm".equalsIgnoreCase(action)) {
                this.request.setAttribute("displayEventCRF", (Object)dec);
                this.forwardPage(Page.DELETE_EVENT_CRF);
            } else {
                this.logger.info("submit to delete the event CRF from event");
                this.getDynamicsItemFormMetadataDao().delete(eventCRFId);
                this.getDynamicsItemGroupMetadataDao().delete(eventCRFId);
                eventCRF.setOldStatus(eventCRF.getStatus());
                eventCRF.setStatus(Status.RESET);
                eventCRF.setUpdater(this.ub);
                eventCRF.setValidatorId(0);
                ecdao.update((EntityBean)eventCRF);
                for (ItemDataBean itemdata : itemData) {
                    this.getRuleActionRunLogDao().delete(itemdata.getId());
                    ArrayList parentDiscrepancyNoteList = this.getDnDao().findParentNotesOnlyByItemData(itemdata.getId());
                    for (DiscrepancyNoteBean parentDiscrepancyNote : parentDiscrepancyNoteList) {
                        if (parentDiscrepancyNote.getResolutionStatusId() == 4) continue;
                        String description = resword.getString("dn_auto-closed_description");
                        String detailedNotes = resword.getString("dn_auto_closed_detailed_notes");
                        this.createDiscrepancyNoteBean(description, detailedNotes, itemdata.getId(), study, this.ub, parentDiscrepancyNote);
                    }
                    iddao = new ItemDataDAO(this.sm.getDataSource());
                    this.ifmdao = new ItemFormMetadataDAO(this.sm.getDataSource());
                    ItemDataBean idBean = (ItemDataBean)iddao.findByPK(itemdata.getId());
                    ItemFormMetadataBean ifmBean = this.ifmdao.findByItemIdAndCRFVersionId(idBean.getItemId(), crfVersionId);
                    ArrayList dnBeans = this.getDnDao().findExistingNotesForItemData(itemdata.getId());
                    if (dnBeans.size() != 0) {
                        DiscrepancyNoteBean dnBean = new DiscrepancyNoteBean();
                        dnBean.setEntityId(itemdata.getId());
                        dnBean.setActivated(false);
                        this.getDnDao().updateDnMapActivation((EntityBean)dnBean);
                    }
                    itemdata.setValue("");
                    itemdata.setOldStatus(itemdata.getStatus());
                    itemdata.setOwner(this.ub);
                    itemdata.setStatus(Status.AVAILABLE);
                    itemdata.setUpdater(this.ub);
                    iddao.updateUser((EntityBean)itemdata);
                    iddao.update((EntityBean)itemdata);
                }
                eventCRF.setOldStatus(eventCRF.getStatus());
                eventCRF.setStatus(Status.AVAILABLE);
                eventCRF.setUpdater(this.ub);
                ecdao.update((EntityBean)eventCRF);
                if (event.getSubjectEventStatus().isCompleted() || event.getSubjectEventStatus().isSigned()) {
                    event.setSubjectEventStatus(SubjectEventStatus.DATA_ENTRY_STARTED);
                    event.setUpdater(this.ub);
                    sedao = new StudyEventDAO(this.sm.getDataSource());
                    sedao.update((EntityBean)event);
                }
                String emailBody = respage.getString("the_event_CRF") + cb.getName() + respage.getString("has_been_deleted_from_the_event") + event.getStudyEventDefinition().getName() + ". " + respage.getString("has_been_deleted_from_the_event_cont");
                this.addPageMessage(emailBody);
                this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            }
        }
    }

    private void createDiscrepancyNoteBean(String description, String detailedNotes, int itemDataId, StudyBean studyBean, UserAccountBean ub, DiscrepancyNoteBean parentDiscrepancyNote) {
        DiscrepancyNoteBean dnb = new DiscrepancyNoteBean();
        dnb.setEntityId(itemDataId);
        dnb.setStudyId(studyBean.getId());
        dnb.setEntityType("itemData");
        dnb.setDescription(description);
        dnb.setDetailedNotes(detailedNotes);
        dnb.setDiscrepancyNoteTypeId(parentDiscrepancyNote.getDiscrepancyNoteTypeId());
        dnb.setResolutionStatusId(4);
        dnb.setColumn("value");
        dnb.setAssignedUserId(ub.getId());
        dnb.setOwner(ub);
        dnb.setParentDnId(parentDiscrepancyNote.getId());
        dnb.setActivated(false);
        dnb = (DiscrepancyNoteBean)this.getDnDao().create((EntityBean)dnb);
        this.getDnDao().createMapping(dnb);
        DiscrepancyNoteBean itemParentNote = (DiscrepancyNoteBean)this.getDnDao().findByPK(dnb.getParentDnId());
        itemParentNote.setResolutionStatusId(ResolutionStatus.CLOSED.getId());
        itemParentNote.setAssignedUserId(ub.getId());
        this.getDnDao().update((EntityBean)itemParentNote);
        this.getDnDao().updateAssignedUser((EntityBean)itemParentNote);
    }

    public DiscrepancyNoteDAO getDnDao() {
        return this.dnDao;
    }

    public void setDnDao(DiscrepancyNoteDAO dnDao) {
        this.dnDao = dnDao;
    }

    private RuleActionRunLogDao getRuleActionRunLogDao() {
        this.ruleActionRunLogDao = this.ruleActionRunLogDao != null ? this.ruleActionRunLogDao : (RuleActionRunLogDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleActionRunLogDao");
        return this.ruleActionRunLogDao;
    }

    private DynamicsItemFormMetadataDao getDynamicsItemFormMetadataDao() {
        this.dynamicsItemFormMetadataDao = this.dynamicsItemFormMetadataDao != null ? this.dynamicsItemFormMetadataDao : (DynamicsItemFormMetadataDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("dynamicsItemFormMetadataDao");
        return this.dynamicsItemFormMetadataDao;
    }

    private DynamicsItemGroupMetadataDao getDynamicsItemGroupMetadataDao() {
        this.dynamicsItemGroupMetadataDao = this.dynamicsItemGroupMetadataDao != null ? this.dynamicsItemGroupMetadataDao : (DynamicsItemGroupMetadataDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("dynamicsItemGroupMetadataDao");
        return this.dynamicsItemGroupMetadataDao;
    }
}

