/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.UserType;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class EditUserAccountServlet
extends SecureController {
    public static final String INPUT_FIRST_NAME = "firstName";
    public static final String INPUT_LAST_NAME = "lastName";
    public static final String INPUT_EMAIL = "email";
    public static final String INPUT_INSTITUTION = "institutionalAffiliation";
    public static final String INPUT_RESET_PASSWORD = "resetPassword";
    public static final String INPUT_USER_TYPE = "userType";
    public static final String INPUT_CONFIRM_BUTTON = "submit";
    public static final String INPUT_DISPLAY_PWD = "displayPwd";
    public static final String PATH = "EditUserAccount";
    public static final String ARG_USERID = "userId";
    public static final String ARG_STEPNUM = "stepNum";
    public static final String INPUT_RUN_WEBSERVICES = "runWebServices";
    public static final String FLAG_LDAP_USER = "ldapUser";
    public static final int EDIT_STEP = 1;
    public static final int CONFIRM_STEP = 2;
    public static final String BUTTON_CONFIRM_VALUE = "Confirm";
    public static final String BUTTON_BACK_VALUE = "Back";
    public static final String USER_ACCOUNT_NOTIFICATION = "notifyPassword";

    private ArrayList getAllStudies() {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        return (ArrayList)sdao.findAll();
    }

    public static String getLink(int userId) {
        return "EditUserAccount?userId=" + userId;
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        ArrayList studies = this.getAllStudies();
        this.request.setAttribute("studies", (Object)studies);
        int userId = fp.getInt(ARG_USERID);
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean user = (UserAccountBean)udao.findByPK(userId);
        this.techAdminProtect(user);
        int stepNum = fp.getInt(ARG_STEPNUM);
        if (!fp.isSubmitted()) {
            this.addEntityList("userTypes", (Collection)this.getUserTypes(), respage.getString("the_user_could_not_be_edited_because_no_user_types"), Page.ADMIN_SYSTEM);
            this.loadPresetValuesFromBean(fp, user);
            fp.addPresetValue(ARG_STEPNUM, 1);
            this.setPresetValues(fp.getPresetValues());
            this.request.setAttribute("userName", (Object)user.getName());
            this.forwardPage(Page.EDIT_ACCOUNT);
            return;
        } else if (stepNum == 1) {
            Validator v = new Validator(this.request);
            v.addValidation(INPUT_FIRST_NAME, 1);
            v.addValidation(INPUT_LAST_NAME, 1);
            v.addValidation(INPUT_FIRST_NAME, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 50);
            v.addValidation(INPUT_LAST_NAME, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 50);
            v.addValidation(INPUT_EMAIL, 1);
            v.addValidation(INPUT_EMAIL, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 120);
            v.addValidation(INPUT_EMAIL, 6);
            v.addValidation(INPUT_INSTITUTION, 1);
            v.addValidation(INPUT_INSTITUTION, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
            HashMap errors = v.validate();
            if (errors.isEmpty()) {
                this.loadPresetValuesFromForm(fp);
                fp.addPresetValue(ARG_STEPNUM, 2);
                this.setPresetValues(fp.getPresetValues());
                this.request.setAttribute("userName", (Object)user.getName());
                this.forwardPage(Page.EDIT_ACCOUNT_CONFIRM);
                return;
            } else {
                this.loadPresetValuesFromForm(fp);
                fp.addPresetValue(ARG_STEPNUM, 1);
                this.setInputMessages(errors);
                this.setPresetValues(fp.getPresetValues());
                this.addEntityList("userTypes", (Collection)this.getUserTypes(), respage.getString("the_user_could_not_be_edited_because_no_user_types"), Page.ADMIN_SYSTEM);
                this.addPageMessage(respage.getString("there_were_some_errors_submission") + respage.getString("see_below_for_details"));
                this.forwardPage(Page.EDIT_ACCOUNT);
            }
            return;
        } else {
            if (stepNum != 2) throw new InconsistentStateException(Page.ADMIN_SYSTEM, resexception.getString("an_invalid_step_was_specified"));
            String button = fp.getString(INPUT_CONFIRM_BUTTON);
            if (button.equals(resword.getString("back"))) {
                this.loadPresetValuesFromForm(fp);
                fp.addPresetValue(ARG_STEPNUM, 1);
                this.addEntityList("userTypes", (Collection)this.getUserTypes(), respage.getString("the_user_could_not_be_edited_because_no_user_types"), Page.ADMIN_SYSTEM);
                this.setPresetValues(fp.getPresetValues());
                this.request.setAttribute("userName", (Object)user.getName());
                this.forwardPage(Page.EDIT_ACCOUNT);
                return;
            } else {
                if (!button.equals(resword.getString("confirm"))) throw new InconsistentStateException(Page.ADMIN_SYSTEM, resexception.getString("an_invalid_submit_button_was_clicked"));
                user.setFirstName(fp.getString(INPUT_FIRST_NAME));
                user.setLastName(fp.getString(INPUT_LAST_NAME));
                user.setEmail(fp.getString(INPUT_EMAIL));
                user.setInstitutionalAffiliation(fp.getString(INPUT_INSTITUTION));
                user.setUpdater(this.ub);
                user.setRunWebservices(Boolean.valueOf(fp.getBoolean(INPUT_RUN_WEBSERVICES)));
                user.setEnableApiKey(true);
                String apiKey = null;
                while (this.isApiKeyExist(apiKey = this.getRandom32ChApiKey()).booleanValue()) {
                }
                user.setApiKey(apiKey);
                UserType ut = UserType.get((int)fp.getInt(INPUT_USER_TYPE));
                if (ut.equals((Term)UserType.SYSADMIN)) {
                    user.addUserType(ut);
                } else if (ut.equals((Term)UserType.TECHADMIN)) {
                    user.addUserType(ut);
                } else {
                    user.addUserType(UserType.USER);
                }
                if (fp.getBoolean(INPUT_RESET_PASSWORD)) {
                    SecurityManager sm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
                    String password = sm.genPassword();
                    String passwordHash = sm.encrytPassword(password, this.getUserDetails());
                    user.setPasswd(passwordHash);
                    user.setPasswdTimestamp(null);
                    udao.update((EntityBean)user);
                    if ("no".equalsIgnoreCase(fp.getString(INPUT_DISPLAY_PWD))) {
                        this.logger.info("displayPwd is no");
                        try {
                            this.sendResetPasswordEmail(user, password);
                        }
                        catch (Exception e) {
                            this.addPageMessage(respage.getString("there_was_an_error_sending_reset_email_try_reset"));
                        }
                    } else {
                        this.addPageMessage(respage.getString("new_user_password") + ":<br/> " + password + "<br/>" + respage.getString("please_write_down_the_password_and_provide"));
                    }
                } else {
                    udao.update((EntityBean)user);
                }
                this.addPageMessage(respage.getString("the_user_account") + " \"" + user.getName() + "\" " + respage.getString("was_updated_succesfully"));
                this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
            }
        }
    }

    private void loadPresetValuesFromBean(FormProcessor fp, UserAccountBean user) {
        fp.addPresetValue(INPUT_FIRST_NAME, user.getFirstName());
        fp.addPresetValue(INPUT_LAST_NAME, user.getLastName());
        fp.addPresetValue(INPUT_EMAIL, user.getEmail());
        fp.addPresetValue(INPUT_INSTITUTION, user.getInstitutionalAffiliation());
        int userTypeId = UserType.USER.getId();
        if (user.isTechAdmin()) {
            userTypeId = UserType.TECHADMIN.getId();
        } else if (user.isSysAdmin()) {
            userTypeId = UserType.SYSADMIN.getId();
        }
        fp.addPresetValue(INPUT_USER_TYPE, userTypeId);
        fp.addPresetValue(ARG_USERID, user.getId());
        fp.addPresetValue(INPUT_RUN_WEBSERVICES, user.getRunWebservices() == true ? 1 : 0);
        String sendPwd = SQLInitServlet.getField((String)"user_account_notification");
        fp.addPresetValue(USER_ACCOUNT_NOTIFICATION, sendPwd);
        fp.addPresetValue(FLAG_LDAP_USER, user.isLdapUser());
    }

    private void loadPresetValuesFromForm(FormProcessor fp) {
        fp.clearPresetValues();
        String[] textFields = new String[]{ARG_USERID, INPUT_FIRST_NAME, INPUT_LAST_NAME, INPUT_EMAIL, INPUT_INSTITUTION, INPUT_DISPLAY_PWD};
        fp.setCurrentStringValuesAsPreset(textFields);
        String[] ddlbFields = new String[]{INPUT_USER_TYPE, INPUT_RESET_PASSWORD, INPUT_RUN_WEBSERVICES};
        fp.setCurrentIntValuesAsPreset(ddlbFields);
    }

    private ArrayList getUserTypes() {
        ArrayList types = UserType.toArrayList();
        types.remove(UserType.INVALID);
        if (!this.ub.isTechAdmin()) {
            types.remove(UserType.TECHADMIN);
        }
        return types;
    }

    private void sendResetPasswordEmail(UserAccountBean user, String password) throws Exception {
        this.logger.info("Sending password reset notification to " + user.getName());
        String body = resword.getString("dear") + " " + user.getFirstName() + " " + user.getLastName() + ",<br/>\n";
        body = body + restext.getString("your_password_has_been_reset_on_openclinica") + ":<br/><br/>\n\n";
        body = body + resword.getString("user_name") + ": " + user.getName() + "<br/>\n";
        body = body + resword.getString("password") + ": " + password + "<br/><br/>\n\n";
        body = body + restext.getString("please_test_your_login_information_and_let") + "<br/>\n";
        body = body + "<a href='" + SQLInitServlet.getField((String)"sysURL") + "'>" + SQLInitServlet.getField((String)"sysURL") + "</a><br/>\n";
        body = body + restext.getString("openclinica_system_administrator");
        this.sendEmail(user.getEmail().trim(), restext.getString("your_openclinica_account_password_reset"), body, Boolean.valueOf(false));
    }

    protected String getAdminServlet() {
        return "admin";
    }

    public Boolean isApiKeyExist(String uuid) {
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean uBean = (UserAccountBean)udao.findByApiKey(uuid);
        if (uBean == null || !uBean.isActive()) {
            return false;
        }
        return true;
    }

    public String getRandom32ChApiKey() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replaceAll("-", "");
    }
}

