/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.EventStatusView;
import org.akaza.openclinica.control.admin.EventStatusStatisticsTableFactory;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.DateFilterMatcher;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Limit;
import org.jmesa.view.View;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.html.renderer.HtmlTableRenderer;

public class EventStatusStatisticsTableFactory
extends AbstractTableFactory {
    private StudyDAO studyDao;
    private StudySubjectDAO studySubjectDao;
    private StudyEventDAO studyEventDao;
    private StudyBean currentStudy;
    private ResourceBundle reswords = ResourceBundleProvider.getWordsBundle();

    protected String getTableName() {
        return "subjectEventStatusStatistics";
    }

    public void configureTableFacadeCustomView(TableFacade tableFacade) {
        tableFacade.setView((View)new EventStatusView(this.getLocale()));
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"status", "studySubjects", "percentage"});
        ((HtmlTableRenderer)tableFacade.getTable().getTableRenderer()).setWidth("375px");
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn("status"), this.reswords.getString("event_status"), null, null, false, true);
        this.configureColumn(row.getColumn("studySubjects"), this.reswords.getString("n_events"), null, null, false, true);
        this.configureColumn(row.getColumn("percentage"), this.reswords.getString("percentage"), (CellEditor)new PercentageCellEditor(this, null), null, false, true);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        tableFacade.addFilterMatcher(new MatcherKey(Date.class, "loginAttemptDate"), (FilterMatcher)new DateFilterMatcher("yyyy-MM-dd hh:mm"));
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        Limit limit = tableFacade.getLimit();
        SubjectEventStatus[] subjectEventStatuses = new SubjectEventStatus[]{SubjectEventStatus.SCHEDULED, SubjectEventStatus.DATA_ENTRY_STARTED, SubjectEventStatus.COMPLETED, SubjectEventStatus.SIGNED, SubjectEventStatus.LOCKED, SubjectEventStatus.SKIPPED, SubjectEventStatus.STOPPED};
        ArrayList theItems = new ArrayList();
        if (!limit.isComplete()) {
            int totalRows = subjectEventStatuses.length;
            tableFacade.setTotalRows(totalRows);
        }
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        for (SubjectEventStatus subjectEventStatus : subjectEventStatuses) {
            Integer totalEventsByEventStatus = this.studyEventDao.getCountofEventsBasedOnEventStatus(this.currentStudy, subjectEventStatus);
            Integer totalEvents = this.studyEventDao.getCountofEvents(this.currentStudy);
            Long percentage = totalEvents == 0 ? 0L : Math.round(totalEventsByEventStatus.doubleValue() / totalEvents.doubleValue() * 100.0);
            HashMap<String, Object> theItem = new HashMap<String, Object>();
            theItem.put("status", subjectEventStatus.getName());
            theItem.put("studySubjects", totalEventsByEventStatus);
            theItem.put("percentage", String.valueOf(percentage) + "%");
            theItems.add(theItem);
        }
        tableFacade.setItems(theItems);
    }

    public StudyDAO getStudyDao() {
        return this.studyDao;
    }

    public void setStudyDao(StudyDAO studyDao) {
        this.studyDao = studyDao;
    }

    public StudySubjectDAO getStudySubjectDao() {
        return this.studySubjectDao;
    }

    public void setStudySubjectDao(StudySubjectDAO studySubjectDao) {
        this.studySubjectDao = studySubjectDao;
    }

    public StudyBean getCurrentStudy() {
        return this.currentStudy;
    }

    public void setCurrentStudy(StudyBean currentStudy) {
        this.currentStudy = currentStudy;
    }

    public StudyEventDAO getStudyEventDao() {
        return this.studyEventDao;
    }

    public void setStudyEventDao(StudyEventDAO studyEventDao) {
        this.studyEventDao = studyEventDao;
    }
}

