/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class InitUpdateCRFServlet
extends SecureController {
    private static String CRF_ID = "crfId";
    private static String CRF = "crf";

    public void mayProceed() throws InsufficientPermissionException {
        int studyId;
        if (this.ub.isSysAdmin()) {
            return;
        }
        boolean isStudyDirectorInParent = false;
        if (this.currentStudy.getParentStudyId() > 0) {
            this.logger.info("2222");
            Role r = this.ub.getRoleByStudy(this.currentStudy.getParentStudyId()).getRole();
            if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.ADMIN)) {
                isStudyDirectorInParent = true;
            }
        }
        if (this.ub.hasRoleInStudy(studyId = this.currentStudy.getId())) {
            Role r = this.ub.getRoleByStudy(studyId).getRole();
            if (isStudyDirectorInParent || r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.ADMIN)) {
                return;
            }
        }
        this.addPageMessage(respage.getString("you_not_have_permission_to_update_a_CRF") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.CRF_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.setToPanel(resword.getString("create_CRF"), respage.getString("br_create_new_CRF_entering"));
        this.setToPanel(resword.getString("create_CRF_version"), respage.getString("br_create_new_CRF_uploading"));
        this.setToPanel(resword.getString("revise_CRF_version"), respage.getString("br_if_you_owner_CRF_version"));
        this.setToPanel(resword.getString("CRF_spreadsheet_template"), respage.getString("br_download_blank_CRF_spreadsheet_from"));
        this.setToPanel(resword.getString("example_CRF_br_spreadsheets"), respage.getString("br_download_example_CRF_instructions_from"));
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        int crfId = fp.getInt(CRF_ID);
        if (crfId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_version_to_update"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        } else {
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFBean crf = (CRFBean)cdao.findByPK(crfId);
            if (!this.ub.isSysAdmin() && crf.getOwnerId() != this.ub.getId()) {
                this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                this.forwardPage(Page.MENU_SERVLET);
                return;
            }
            this.session.setAttribute(CRF, (Object)crf);
            this.forwardPage(Page.UPDATE_CRF);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

