/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.ListCRFRow;

public class ListCRFServlet
extends SecureController {
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MANAGE_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        if (this.currentStudy.getParentStudyId() > 0) {
            this.addPageMessage(respage.getString("no_crf_available_study_is_a_site"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        this.session.removeAttribute("version");
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        if (module.equalsIgnoreCase("admin") && !this.ub.isSysAdmin() && !this.ub.isTechAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        this.request.setAttribute("module", (Object)module);
        String crfVersionChangeMsg = fp.getString("isFromCRFVersionBatchChange");
        if (crfVersionChangeMsg != null && !crfVersionChangeMsg.equals("")) {
            this.addPageMessage(crfVersionChangeMsg);
        }
        String dir = SQLInitServlet.getField((String)"filePath") + "crf" + File.separator + "new" + File.separator;
        this.logger.debug("found directory: " + dir);
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO vdao = new CRFVersionDAO(this.sm.getDataSource());
        ArrayList crfs = (ArrayList)cdao.findAll();
        for (int i = 0; i < crfs.size(); ++i) {
            CRFBean eb = (CRFBean)crfs.get(i);
            this.logger.debug("crf id:" + eb.getId());
            ArrayList versions = (ArrayList)vdao.findAllByCRF(eb.getId());
            for (int j = 0; j < versions.size(); ++j) {
                CRFVersionBean cv = (CRFVersionBean)versions.get(j);
                File file = new File(dir + eb.getId() + cv.getOid() + ".xls");
                this.logger.debug("looking in " + dir + eb.getId() + cv.getOid() + ".xls");
                if (file.exists()) {
                    cv.setDownloadable(true);
                    continue;
                }
                File file2 = new File(dir + eb.getId() + cv.getName() + ".xls");
                this.logger.debug("initial failed, looking in " + dir + eb.getId() + cv.getName() + ".xls");
                if (!file2.exists()) continue;
                cv.setDownloadable(true);
            }
            eb.setVersions(versions);
        }
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allRows = ListCRFRow.generateRowsFromBeans((ArrayList)crfs);
        String[] columns = new String[]{resword.getString("CRF_name"), resword.getString("date_updated"), resword.getString("last_updated_by"), resword.getString("crf_oid"), resword.getString("versions"), resword.getString("version_oid"), resword.getString("date_created"), resword.getString("owner"), resword.getString("status"), resword.getString("download"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(3);
        table.hideColumnLink(4);
        table.hideColumnLink(8);
        table.setQuery("ListCRF", new HashMap());
        table.addLink(resword.getString("blank_CRF_template"), "DownloadVersionSpreadSheet?template=1");
        String crfCatalogField = "crfCatalog";
        table.addLink(resword.getString("create_a_new_CRF"), "CreateCRFVersion?module=" + module);
        table.setRows(allRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        this.request.setAttribute("study", (Object)this.currentStudy);
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.panel.setSubmitDataModule(false);
        this.panel.setExtractData(false);
        this.panel.setCreateDataset(false);
        if (crfs.size() > 0) {
            this.setToPanel("CRFs", new Integer(crfs.size()).toString());
        }
        this.setToPanel(resword.getString("create_CRF"), respage.getString("br_create_new_CRF_entering"));
        this.setToPanel(resword.getString("create_CRF_version"), respage.getString("br_create_new_CRF_uploading"));
        this.setToPanel(resword.getString("revise_CRF_version"), respage.getString("br_if_you_owner_CRF_version"));
        this.setToPanel(resword.getString("CRF_spreadsheet_template"), respage.getString("br_download_blank_CRF_spreadsheet_from"));
        this.setToPanel(resword.getString("example_CRF_br_spreadsheets"), respage.getString("br_download_example_CRF_instructions_from"));
        this.forwardPage(Page.CRF_LIST);
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

