/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

/*
 * Exception performing whole class analysis ignored.
 */
public class RemoveCRFVersionServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.CRF_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int versionId = fp.getInt("id", true);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        String action = fp.getString("action");
        if (versionId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_version_to_remove"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        } else {
            if (StringUtil.isBlank((String)action)) {
                this.addPageMessage(respage.getString("no_action_specified"));
                this.forwardPage(Page.CRF_LIST_SERVLET);
                return;
            }
            CRFVersionBean version = (CRFVersionBean)cvdao.findByPK(versionId);
            if (!this.ub.isSysAdmin() && version.getOwnerId() != this.ub.getId()) {
                this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                this.forwardPage(Page.MENU_SERVLET);
                return;
            }
            SectionDAO secdao = new SectionDAO(this.sm.getDataSource());
            EventCRFDAO evdao = new EventCRFDAO(this.sm.getDataSource());
            ArrayList eventCRFs = evdao.findUndeletedWithStudySubjectsByCRFVersion(versionId);
            if ("confirm".equalsIgnoreCase(action)) {
                this.request.setAttribute("versionToRemove", (Object)version);
                this.request.setAttribute("eventCRFs", (Object)eventCRFs);
                this.forwardPage(Page.REMOVE_CRF_VERSION);
            } else {
                this.logger.info("submit to remove the crf version");
                version.setStatus(Status.DELETED);
                version.setUpdater(this.ub);
                version.setUpdatedDate(new Date());
                cvdao.update((EntityBean)version);
                for (int ii = 0; ii < eventCRFs.size(); ++ii) {
                    EventCRFBean ecbean = (EventCRFBean)eventCRFs.get(ii);
                    ecbean.setStatus(Status.AUTO_DELETED);
                    ecbean.setUpdater(this.ub);
                    ecbean.setUpdatedDate(new Date());
                    evdao.update((EntityBean)ecbean);
                }
                ArrayList sections = secdao.findAllByCRFVersionId(version.getId());
                for (int j = 0; j < sections.size(); ++j) {
                    SectionBean section = (SectionBean)sections.get(j);
                    if (section.getStatus().equals((Term)Status.DELETED)) continue;
                    section.setStatus(Status.AUTO_DELETED);
                    section.setUpdater(this.ub);
                    section.setUpdatedDate(new Date());
                    secdao.update((EntityBean)section);
                }
                ItemDataDAO idao = new ItemDataDAO(this.sm.getDataSource());
                for (int i = 0; i < eventCRFs.size(); ++i) {
                    EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(i);
                    if (eventCRF.getStatus().equals((Term)Status.DELETED)) continue;
                    eventCRF.setStatus(Status.AUTO_DELETED);
                    eventCRF.setUpdater(this.ub);
                    eventCRF.setUpdatedDate(new Date());
                    evdao.update((EntityBean)eventCRF);
                    ArrayList items = idao.findAllByEventCRFId(eventCRF.getId());
                    for (int j = 0; j < items.size(); ++j) {
                        ItemDataBean item = (ItemDataBean)items.get(j);
                        if (item.getStatus().equals((Term)Status.DELETED)) continue;
                        item.setStatus(Status.AUTO_DELETED);
                        item.setUpdater(this.ub);
                        item.setUpdatedDate(new Date());
                        idao.update((EntityBean)item);
                    }
                }
                ArrayList versionList = (ArrayList)cvdao.findAllByCRF(version.getCrfId());
                if (versionList.size() > 0) {
                    EventDefinitionCRFDAO edCRFDao = new EventDefinitionCRFDAO(this.sm.getDataSource());
                    ArrayList edcList = (ArrayList)edCRFDao.findAllByCRF(version.getCrfId());
                    for (int i = 0; i < edcList.size(); ++i) {
                        EventDefinitionCRFBean edcBean = (EventDefinitionCRFBean)edcList.get(i);
                        RemoveCRFVersionServlet.updateEventDef((EventDefinitionCRFBean)edcBean, (EventDefinitionCRFDAO)edCRFDao, (ArrayList)versionList);
                    }
                }
                this.addPageMessage(respage.getString("the_CRF") + version.getName() + " " + respage.getString("has_been_removed_succesfully"));
                this.forwardPage(Page.CRF_LIST_SERVLET);
            }
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public static void updateEventDef(EventDefinitionCRFBean edcBean, EventDefinitionCRFDAO edcDao, ArrayList versionList) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        CRFVersionBean temp = (CRFVersionBean)versionList.get(0);
        if (StringUtil.isBlank((String)edcBean.getSelectedVersionIds())) {
            edcBean.setDefaultVersionId(temp.getId());
            edcDao.update((EntityBean)edcBean);
        } else {
            String[] ids;
            String sversionIds = edcBean.getSelectedVersionIds();
            for (String id : ids = sversionIds.split("\\,")) {
                idList.add(Integer.valueOf(id));
            }
            for (int i = 0; i < versionList.size(); ++i) {
                CRFVersionBean versionBean = (CRFVersionBean)versionList.get(i);
                if (!idList.contains(versionBean.getId())) continue;
                edcBean.setDefaultVersionId(versionBean.getId());
                edcDao.update((EntityBean)edcBean);
                break;
            }
        }
    }

    public static void updateEventDef(EventDefinitionCRFBean edcBean, EventDefinitionCRFDAO edcDao, ArrayList versionList, int crfVIdToLock) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        CRFVersionBean temp = null;
        if (null != versionList && versionList.size() > 0) {
            temp = (CRFVersionBean)versionList.get(0);
        }
        if (StringUtil.isBlank((String)edcBean.getSelectedVersionIds())) {
            if (null != temp && temp.getId() == crfVIdToLock && null != versionList && versionList.size() > 1) {
                CRFVersionBean temp2 = (CRFVersionBean)versionList.get(1);
                edcBean.setDefaultVersionId(temp2.getId());
            } else {
                edcBean.setDefaultVersionId(temp.getId());
            }
            edcDao.update((EntityBean)edcBean);
        } else {
            String[] ids;
            String sversionIds = edcBean.getSelectedVersionIds();
            for (String id : ids = sversionIds.split("\\,")) {
                idList.add(Integer.valueOf(id));
            }
            for (int i = 0; i < versionList.size(); ++i) {
                CRFVersionBean versionBean = (CRFVersionBean)versionList.get(i);
                if (!idList.contains(versionBean.getId())) continue;
                edcBean.setDefaultVersionId(versionBean.getId());
                edcDao.update((EntityBean)edcBean);
                break;
            }
        }
    }
}

