/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RemoveSubjectServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SUBJECT_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int subjectId = fp.getInt("id");
        String action = fp.getString("action");
        if (subjectId == 0 || StringUtil.isBlank((String)action)) {
            this.addPageMessage(respage.getString("please_choose_a_subject_to_remove"));
            this.forwardPage(Page.SUBJECT_LIST_SERVLET);
        } else {
            SubjectBean subject = (SubjectBean)sdao.findByPK(subjectId);
            StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
            ArrayList studySubs = ssdao.findAllBySubjectId(subjectId);
            StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
            ArrayList events = sedao.findAllBySubjectId(subjectId);
            if ("confirm".equalsIgnoreCase(action)) {
                this.request.setAttribute("subjectToRemove", (Object)subject);
                this.request.setAttribute("studySubs", (Object)studySubs);
                this.request.setAttribute("events", (Object)events);
                this.forwardPage(Page.REMOVE_SUBJECT);
            } else {
                this.logger.info("submit to remove the subject");
                subject.setStatus(Status.DELETED);
                subject.setUpdater(this.ub);
                subject.setUpdatedDate(new Date());
                sdao.update((EntityBean)subject);
                for (int i = 0; i < studySubs.size(); ++i) {
                    StudySubjectBean studySub = (StudySubjectBean)studySubs.get(i);
                    if (studySub.getStatus().equals((Term)Status.DELETED)) continue;
                    studySub.setStatus(Status.AUTO_DELETED);
                    studySub.setUpdater(this.ub);
                    studySub.setUpdatedDate(new Date());
                    ssdao.update((EntityBean)studySub);
                }
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                for (int j = 0; j < events.size(); ++j) {
                    StudyEventBean event = (StudyEventBean)events.get(j);
                    if (event.getStatus().equals((Term)Status.DELETED)) continue;
                    event.setStatus(Status.AUTO_DELETED);
                    event.setUpdater(this.ub);
                    event.setUpdatedDate(new Date());
                    sedao.update((EntityBean)event);
                    ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
                    ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                    for (int k = 0; k < eventCRFs.size(); ++k) {
                        EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(k);
                        if (eventCRF.getStatus().equals((Term)Status.DELETED)) continue;
                        eventCRF.setStatus(Status.AUTO_DELETED);
                        eventCRF.setUpdater(this.ub);
                        eventCRF.setUpdatedDate(new Date());
                        ecdao.update((EntityBean)eventCRF);
                        ArrayList itemDatas = iddao.findAllByEventCRFId(eventCRF.getId());
                        for (int a = 0; a < itemDatas.size(); ++a) {
                            ItemDataBean item = (ItemDataBean)itemDatas.get(a);
                            if (item.getStatus().equals((Term)Status.DELETED)) continue;
                            item.setStatus(Status.AUTO_DELETED);
                            item.setUpdater(this.ub);
                            item.setUpdatedDate(new Date());
                            iddao.update((EntityBean)item);
                        }
                    }
                }
                String emailBody = respage.getString("the_subject") + " " + subject.getUniqueIdentifier() + " " + respage.getString("has_been_removed_succesfully");
                this.addPageMessage(emailBody);
                this.forwardPage(Page.SUBJECT_LIST_SERVLET);
            }
        }
    }

    private void sendEmail(String emailBody) throws Exception {
        this.logger.info("Sending email...");
        this.sendEmail(this.ub.getEmail().trim(), "Remove Subject from System", emailBody, Boolean.valueOf(false));
        this.logger.info("Sending email done..");
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

