/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.akaza.openclinica.control.admin.Preview;
import org.akaza.openclinica.control.admin.SpreadsheetPreview;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpreadsheetPreview
implements Preview {
    public static final String ITEMS = "Items";
    public static final String SECTIONS = "Sections";
    public static final String GROUPS = "Groups";
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public Map<String, Map> createCrfMetaObject(HSSFWorkbook workbook) {
        if (workbook == null) {
            return new HashMap<String, Map>();
        }
        HashMap<String, Map> spreadSheetMap = new HashMap<String, Map>();
        Map sections = this.createItemsOrSectionMap(workbook, SECTIONS);
        Map items = this.createItemsOrSectionMap(workbook, ITEMS);
        Map crfInfo = this.createCrfMap(workbook);
        if (sections.isEmpty() && items.isEmpty() && crfInfo.isEmpty()) {
            return spreadSheetMap;
        }
        spreadSheetMap.put("sections", sections);
        spreadSheetMap.put("items", items);
        spreadSheetMap.put("crf_info", crfInfo);
        return spreadSheetMap;
    }

    public Map<Integer, Map<String, String>> createItemsOrSectionMap(HSSFWorkbook workbook, String itemsOrSection) {
        if (workbook == null || workbook.getNumberOfSheets() == 0) {
            return new HashMap<Integer, Map<String, String>>();
        }
        if (itemsOrSection == null || !itemsOrSection.equalsIgnoreCase(ITEMS) && !itemsOrSection.equalsIgnoreCase(SECTIONS)) {
            return new HashMap<Integer, Map<String, String>>();
        }
        String[] itemHeaders = new String[]{"item_name", "description_label", "left_item_text", "units", "right_item_text", "section_label", "header", "subheader", "parent_item", "column_number", "page_number", "question_number", "response_type", "response_label", "response_options_text", "response_values", "data_type", "validation", "validation_error_message", "phi", "required"};
        String[] sectionHeaders = new String[]{"section_label", "section_title", "subtitle", "instructions", "page_number", "parent_section"};
        HashMap<String, String> rowCells = new HashMap<String, String>();
        TreeMap<Integer, Map<String, String>> allRows = new TreeMap<Integer, Map<String, String>>();
        String str = "";
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = workbook.getSheetAt(i);
            str = workbook.getSheetName(i);
            if (!str.equalsIgnoreCase(itemsOrSection)) continue;
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                String[] headers;
                String[] stringArray = headers = itemsOrSection.equalsIgnoreCase(ITEMS) ? itemHeaders : sectionHeaders;
                if (j > 1) {
                    rowCells = new HashMap();
                }
                HSSFRow row = sheet.getRow(j);
                for (int k = 0; k < headers.length; ++k) {
                    HSSFCell cell = row.getCell((int)((short)k));
                    if (headers[k].equalsIgnoreCase("left_item_text") || headers[k].equalsIgnoreCase("right_item_text") || headers[k].equalsIgnoreCase("header") || headers[k].equalsIgnoreCase("subheader") || headers[k].equalsIgnoreCase("question_number") || headers[k].equalsIgnoreCase("section_title") || headers[k].equalsIgnoreCase("subtitle") || headers[k].equalsIgnoreCase("instructions")) {
                        rowCells.put(headers[k], this.getCellValue(cell));
                        continue;
                    }
                    rowCells.put(headers[k], this.getCellValue(cell).replaceAll("<[^>]*>", ""));
                }
                allRows.put(j, rowCells);
            }
        }
        return allRows;
    }

    public Map<Integer, Map<String, String>> createGroupsMap(HSSFWorkbook workbook) {
        if (workbook == null || workbook.getNumberOfSheets() == 0) {
            return new HashMap<Integer, Map<String, String>>();
        }
        String[] groupHeaders = new String[]{"group_label", "group_layout", "group_header", "group_sub_header", "group_repeat_number", "group_repeat_max", "group_repeat_array", "group_row_start_number"};
        HashMap<String, String> rowCells = new HashMap<String, String>();
        TreeMap<Integer, Map<String, String>> allRows = new TreeMap<Integer, Map<String, String>>();
        String str = "";
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = workbook.getSheetAt(i);
            str = workbook.getSheetName(i);
            if (!str.equalsIgnoreCase(GROUPS)) continue;
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                if (j > 1) {
                    rowCells = new HashMap();
                }
                HSSFRow row = sheet.getRow(j);
                for (int k = 0; k < groupHeaders.length; ++k) {
                    HSSFCell cell = row.getCell((int)((short)k));
                    if (!groupHeaders[k].equalsIgnoreCase("group_header")) continue;
                    rowCells.put(groupHeaders[k], this.getCellValue(cell).replaceAll("<[^>]*>", ""));
                }
                allRows.put(j, rowCells);
            }
        }
        return allRows;
    }

    private String getCellValue(HSSFCell cell) {
        if (cell == null) {
            return "";
        }
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                return Double.toString(cell.getNumericCellValue());
            }
            case 3: {
                return Boolean.valueOf(cell.getBooleanCellValue()).toString();
            }
            case 4: {
                return cell.getCellFormula().toString();
            }
        }
        return "";
    }

    public static void main(String[] args) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(new File("/Users/bruceperry/work/OpenClinica-Cancer-Demo-Study/Cancer_History5.xls")));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        SpreadsheetPreview prev = new SpreadsheetPreview();
        Map map = prev.createItemsOrSectionMap(wb, "sections");
        for (Map.Entry me : map.entrySet()) {
            Map map2 = (Map)me.getValue();
        }
    }

    public Map<String, String> createCrfMap(HSSFWorkbook workbook) {
        if (workbook == null || workbook.getNumberOfSheets() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> crfInfo = new HashMap<String, String>();
        String mapKey = "";
        String val = "";
        String str = "";
        String[] crfHeaders = new String[]{"crf_name", "version", "version_description", "revision_notes"};
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = workbook.getSheetAt(i);
            str = workbook.getSheetName(i);
            if (!str.equalsIgnoreCase("CRF")) continue;
            HSSFRow row = sheet.getRow(1);
            for (int k = 0; k < crfHeaders.length; ++k) {
                mapKey = crfHeaders[k];
                HSSFCell cell = row.getCell((int)((short)k));
                if (cell != null) {
                    switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                        case 1: {
                            val = cell.getStringCellValue();
                            break;
                        }
                        case 2: {
                            val = Double.toString(cell.getNumericCellValue());
                            break;
                        }
                        case 3: {
                            val = Boolean.valueOf(cell.getBooleanCellValue()).toString();
                            break;
                        }
                        case 4: {
                            cell.getCellFormula().toString();
                        }
                    }
                }
                crfInfo.put(mapKey, val);
            }
        }
        return crfInfo;
    }
}

