/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.Date;
import java.util.HashMap;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class UpdateCRFServlet
extends SecureController {
    private static String CRF = "crf";

    public void mayProceed() throws InsufficientPermissionException {
        int studyId;
        if (this.ub.isSysAdmin()) {
            return;
        }
        boolean isStudyDirectorInParent = false;
        if (this.currentStudy.getParentStudyId() > 0) {
            this.logger.info("2222");
            Role r = this.ub.getRoleByStudy(this.currentStudy.getParentStudyId()).getRole();
            if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.ADMIN)) {
                isStudyDirectorInParent = true;
            }
        }
        if (this.ub.hasRoleInStudy(studyId = this.currentStudy.getId())) {
            Role r = this.ub.getRoleByStudy(studyId).getRole();
            if (isStudyDirectorInParent || r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.ADMIN)) {
                return;
            }
        }
        this.addPageMessage(respage.getString("you_not_have_permission_update_a_CRF") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.CRF_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.setToPanel(resword.getString("create_CRF"), respage.getString("br_create_new_CRF_entering"));
        this.setToPanel(resword.getString("create_CRF_version"), respage.getString("br_create_new_CRF_uploading"));
        this.setToPanel(resword.getString("revise_CRF_version"), respage.getString("br_if_you_owner_CRF_version"));
        this.setToPanel(resword.getString("CRF_spreadsheet_template"), respage.getString("br_download_blank_CRF_spreadsheet_from"));
        this.setToPanel(resword.getString("example_CRF_br_spreadsheets"), respage.getString("br_download_example_CRF_instructions_from"));
        FormProcessor fp = new FormProcessor(this.request);
        String action = fp.getString("action");
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        CRFBean crf = (CRFBean)this.session.getAttribute(CRF);
        if (StringUtil.isBlank((String)action)) {
            this.session.setAttribute(CRF, (Object)crf);
            this.forwardPage(Page.UPDATE_CRF);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmCRF();
        } else if ("submit".equalsIgnoreCase(action)) {
            this.submitCRF();
        }
    }

    private void confirmCRF() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("name", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("description", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2048);
        this.errors = v.validate();
        if (!StringUtil.isBlank((String)fp.getString("name"))) {
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFBean crf = (CRFBean)this.session.getAttribute(CRF);
            CRFBean crf1 = (CRFBean)cdao.findAnotherByName(fp.getString("name").trim(), crf.getId());
            this.logger.info("crf:" + crf.getName() + crf.getId());
            this.logger.info("crf1:" + crf1.getName() + crf1.getId());
            if (crf1.getId() > 0) {
                Validator.addError((HashMap)this.errors, (String)"name", (String)resexception.getString("CRF_name_used_by_another_CRF_choose_unique"));
            }
        }
        if (!this.errors.isEmpty()) {
            this.logger.info("has errors");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.UPDATE_CRF);
        } else {
            this.logger.info("no errors");
            CRFBean crf = (CRFBean)this.session.getAttribute(CRF);
            crf.setName(fp.getString("name"));
            crf.setDescription(fp.getString("description"));
            this.session.setAttribute(CRF, (Object)crf);
            this.forwardPage(Page.UPDATE_CRF_CONFIRM);
        }
    }

    private void submitCRF() {
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFBean crf = (CRFBean)this.session.getAttribute(CRF);
        this.logger.info("CRF bean to be updated:" + crf.getName());
        crf.setUpdater(this.ub);
        crf.setUpdatedDate(new Date());
        crf.setStatus(Status.AVAILABLE);
        cdao.update((EntityBean)crf);
        this.session.removeAttribute(CRF);
        this.addPageMessage(respage.getString("the_CRF_has_been_updated_succesfully"));
        this.forwardPage(Page.CRF_LIST_SERVLET);
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

