/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.extract.ExtractPropertyBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.job.XsltStatefulJob;
import org.akaza.openclinica.service.extract.ExtractUtils;
import org.akaza.openclinica.service.extract.XsltTriggerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.job.TriggerService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;
import org.springframework.scheduling.quartz.JobDetailBean;

public class UpdateJobExportServlet
extends SecureController {
    private static String SCHEDULER = "schedulerFactoryBean";
    private StdScheduler scheduler;
    private SimpleTrigger trigger;
    private JobDataMap dataMap;
    public static final String PERIOD = "periodToRun";
    public static final String FORMAT_ID = "formatId";
    public static final String DATASET_ID = "dsId";
    public static final String DATE_START_JOB = "job";
    public static final String EMAIL = "contactEmail";
    public static final String JOB_NAME = "jobName";
    public static final String JOB_DESC = "jobDesc";
    public static final String USER_ID = "user_id";
    public static final String STUDY_NAME = "study_name";
    public static final String TRIGGER_GROUP_JOB = "XsltTriggersExportJobs";

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private StdScheduler getScheduler() {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(SCHEDULER);
        return this.scheduler;
    }

    private void setUpServlet(Trigger trigger) {
        FormProcessor fp2 = new FormProcessor(this.request);
        DatasetDAO dsdao = new DatasetDAO(this.sm.getDataSource());
        Collection dsList = dsdao.findAllOrderByStudyIdAndName();
        this.request.setAttribute("datasets", (Object)dsList);
        this.request.setAttribute(JOB_NAME, (Object)trigger.getName());
        this.request.setAttribute(JOB_DESC, (Object)trigger.getDescription());
        this.dataMap = trigger.getJobDataMap();
        String contactEmail = this.dataMap.getString(EMAIL);
        int dsId = this.dataMap.getInt(DATASET_ID);
        int userId = this.dataMap.getInt(USER_ID);
        String period = this.dataMap.getString(PERIOD);
        int exportFormatId = this.dataMap.getInt("exportFormatId");
        this.request.setAttribute(FORMAT_ID, (Object)exportFormatId);
        this.request.setAttribute(EMAIL, (Object)contactEmail);
        this.request.setAttribute(PERIOD, (Object)period);
        this.request.setAttribute(DATASET_ID, (Object)dsId);
        this.request.setAttribute("extractProperties", (Object)CoreResources.getExtractProperties());
        Date jobDate = trigger.getNextFireTime();
        HashMap<String, Object> presetValues = new HashMap<String, Object>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(jobDate);
        presetValues.put("jobHour", calendar.get(11));
        presetValues.put("jobMinute", calendar.get(12));
        presetValues.put("jobDate", this.local_df.format(jobDate));
        fp2.setPresetValues(presetValues);
        this.setPresetValues(fp2.getPresetValues());
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        TriggerService triggerService = new TriggerService();
        String action = fp.getString("action");
        String triggerName = fp.getString("tname");
        this.scheduler = this.getScheduler();
        ExtractUtils extractUtils = new ExtractUtils();
        Trigger updatingTrigger = this.scheduler.getTrigger(triggerName.trim(), XsltTriggerService.TRIGGER_GROUP_NAME);
        if (StringUtil.isBlank((String)action)) {
            this.setUpServlet(updatingTrigger);
            this.forwardPage(Page.UPDATE_JOB_EXPORT);
        } else if ("confirmall".equalsIgnoreCase(action)) {
            HashMap errors = this.validateForm(fp, this.request, this.scheduler.getTriggerNames(XsltTriggerService.TRIGGER_GROUP_NAME), updatingTrigger.getName());
            if (!errors.isEmpty()) {
                this.addPageMessage("Your modifications caused an error, please see the messages for more information.");
                this.setUpServlet(updatingTrigger);
                this.logger.error("errors : " + errors.toString());
                this.forwardPage(Page.UPDATE_JOB_EXPORT);
            } else {
                StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
                StudyBean study = (StudyBean)studyDAO.findByPK(this.sm.getUserBean().getActiveStudyId());
                DatasetDAO datasetDao = new DatasetDAO(this.sm.getDataSource());
                CoreResources cr = new CoreResources();
                UserAccountBean userBean = (UserAccountBean)this.request.getSession().getAttribute("userBean");
                int datasetId = fp.getInt(DATASET_ID);
                String period = fp.getString(PERIOD);
                String email = fp.getString(EMAIL);
                String jobName = fp.getString(JOB_NAME);
                String jobDesc = fp.getString(JOB_DESC);
                Date startDateTime = fp.getDateTime(DATE_START_JOB);
                Integer exportFormatId = fp.getInt(FORMAT_ID);
                ExtractPropertyBean epBean = cr.findExtractPropertyBeanById(exportFormatId.intValue(), "" + datasetId);
                DatasetBean dsBean = (DatasetBean)datasetDao.findByPK(new Integer(datasetId).intValue());
                String[] files = epBean.getFileName();
                int fileSize = files.length;
                int cnt = 0;
                dsBean.setName(dsBean.getName().replaceAll(" ", "_"));
                String[] exportFiles = epBean.getExportFileName();
                String pattern = "yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "HHmmssSSS" + File.separator;
                SimpleDateFormat sdfDir = new SimpleDateFormat(pattern);
                String[] temp = new String[exportFiles.length];
                String datasetFilePath = SQLInitServlet.getField((String)"filePath") + "datasets";
                for (int i = 0; i < exportFiles.length; ++i) {
                    temp[i] = extractUtils.resolveVars(exportFiles[i], dsBean, sdfDir, datasetFilePath);
                }
                epBean.setDoNotDelFiles(temp);
                epBean.setExportFileName(temp);
                XsltTriggerService xsltService = new XsltTriggerService();
                String generalFileDir = SQLInitServlet.getField((String)"filePath");
                generalFileDir = generalFileDir + "datasets" + File.separator + dsBean.getId() + File.separator + sdfDir.format(new Date());
                String exportFileName = epBean.getExportFileName()[cnt];
                String xsltPath = SQLInitServlet.getField((String)"filePath") + "xslt" + File.separator + files[cnt];
                String endFilePath = epBean.getFileLocation();
                endFilePath = extractUtils.getEndFilePath(endFilePath, dsBean, sdfDir, datasetFilePath);
                if (epBean.getPostProcExportName() != null) {
                    String preProcExportPathName = extractUtils.resolveVars(epBean.getPostProcExportName(), dsBean, sdfDir, datasetFilePath);
                    epBean.setPostProcExportName(preProcExportPathName);
                }
                if (epBean.getPostProcLocation() != null) {
                    String prePocLoc = extractUtils.getEndFilePath(epBean.getPostProcLocation(), dsBean, sdfDir, datasetFilePath);
                    epBean.setPostProcLocation(prePocLoc);
                }
                extractUtils.setAllProps(epBean, dsBean, sdfDir, datasetFilePath);
                SimpleTrigger trigger = null;
                trigger = xsltService.generateXsltTrigger(xsltPath, generalFileDir, endFilePath + File.separator, exportFileName, dsBean.getId(), epBean, userBean, LocaleResolver.getLocale((HttpServletRequest)this.request).getLanguage(), cnt, SQLInitServlet.getField((String)"filePath") + "xslt", TRIGGER_GROUP_JOB);
                trigger.setRepeatCount(64000);
                trigger.setRepeatInterval(XsltTriggerService.getIntervalTime((String)period));
                trigger.setDescription(jobDesc);
                trigger.setStartTime(startDateTime);
                trigger.setName(jobName);
                trigger.setMisfireInstruction(5);
                trigger.getJobDataMap().put(EMAIL, email);
                trigger.getJobDataMap().put(PERIOD, period);
                trigger.getJobDataMap().put("exportFormat", epBean.getFiledescription());
                trigger.getJobDataMap().put((Object)"exportFormatId", (Object)exportFormatId);
                trigger.getJobDataMap().put(JOB_NAME, jobName);
                JobDetailBean jobDetailBean = new JobDetailBean();
                jobDetailBean.setGroup(XsltTriggerService.TRIGGER_GROUP_NAME);
                jobDetailBean.setName(trigger.getName());
                jobDetailBean.setJobClass(XsltStatefulJob.class);
                jobDetailBean.setJobDataMap(trigger.getJobDataMap());
                jobDetailBean.setDurability(true);
                jobDetailBean.setVolatility(false);
                try {
                    this.scheduler.deleteJob(triggerName, XsltTriggerService.TRIGGER_GROUP_NAME);
                    Date dataStart = this.scheduler.scheduleJob((JobDetail)jobDetailBean, (Trigger)trigger);
                    this.addPageMessage("Your job has been successfully modified.");
                    this.forwardPage(Page.VIEW_JOB_SERVLET);
                }
                catch (SchedulerException se) {
                    se.printStackTrace();
                    this.setUpServlet((Trigger)trigger);
                    this.addPageMessage("There was an unspecified error with your creation, please contact an administrator.");
                    this.forwardPage(Page.UPDATE_JOB_EXPORT);
                }
            }
        }
    }

    public HashMap validateForm(FormProcessor fp, HttpServletRequest request, String[] triggerNames, String properName) {
        Validator v = new Validator(request);
        v.addValidation(JOB_NAME, 1);
        v.addValidation(JOB_NAME, 46);
        v.addValidation(JOB_DESC, 1);
        v.addValidation(EMAIL, 6);
        v.addValidation(PERIOD, 1);
        v.addValidation("jobDate", 4);
        int formatId = fp.getInt(FORMAT_ID);
        Date jobDate = fp.getDateTime(DATE_START_JOB);
        HashMap errors = v.validate();
        if (formatId == 0) {
            Validator.addError((HashMap)errors, (String)FORMAT_ID, (String)"Please pick at least one.");
        }
        for (String triggerName : triggerNames) {
            if (!triggerName.equals(fp.getString(JOB_NAME)) || triggerName.equals(properName)) continue;
            Validator.addError((HashMap)errors, (String)JOB_NAME, (String)"A job with that name already exists.  Please pick another name.");
        }
        if (jobDate.before(new Date())) {
            Validator.addError((HashMap)errors, (String)"jobDate", (String)"This date needs to be later than the present time.");
        }
        return errors;
    }
}

