/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.AddNewSubjectServlet;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.lang.StringUtils;

public class UpdateSubjectServlet
extends SecureController {
    private static final long serialVersionUID = 1L;
    SimpleDateFormat yformat = new SimpleDateFormat("yyyy");
    public static final String INPUT_UNIQUE_IDENTIFIER = "uniqueIdentifier";
    public static final String DATE_DOB = "localBirthDate";
    public static final String DATE_DOB_TO_SAVE = "localBirthDateToSave";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SUBJECT_LIST_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        FormDiscrepancyNotes discNotes = new FormDiscrepancyNotes();
        String fromResolvingNotes = fp.getString("fromResolvingNotes", true);
        if (StringUtils.isBlank((String)fromResolvingNotes)) {
            this.session.removeAttribute("window_location");
            this.session.removeAttribute("notesTable");
            this.checkStudyLocked(Page.LIST_SUBJECT_SERVLET, respage.getString("current_study_locked"));
            this.checkStudyFrozen(Page.LIST_SUBJECT_SERVLET, respage.getString("current_study_frozen"));
        }
        int subjectId = fp.getInt("id", true);
        int studySubId = fp.getInt("studySubId", true);
        if (subjectId == 0) {
            this.addPageMessage(respage.getString("please_choose_subject_to_edit"));
            this.forwardPage(Page.LIST_SUBJECT_SERVLET);
        } else {
            String action = fp.getString("action", true);
            if (StringUtils.isBlank((String)"action")) {
                this.addPageMessage(respage.getString("no_action_specified"));
                this.forwardPage(Page.LIST_SUBJECT_SERVLET);
                return;
            }
            SubjectBean subject = (SubjectBean)sdao.findByPK(subjectId);
            if (action.equals("show") || action.equals("confirm")) {
                this.request.setAttribute("studySubId", (Object)new Integer(studySubId));
                this.request.setAttribute("id", (Object)new Integer(subjectId));
                this.request.setAttribute("fdnotes", (Object)discNotes);
            }
            if ("show".equalsIgnoreCase(action)) {
                this.request.setAttribute(DATE_DOB, (Object)"");
                if (!this.currentStudy.getStudyParameterConfig().getCollectDob().equals("3") && subject.getDateOfBirth() != null) {
                    this.setLocalDOB(subject);
                }
                discNotes = new FormDiscrepancyNotes();
                this.request.setAttribute("genderDNFlag", (Object)"icon_noNote");
                this.request.setAttribute("birthDNFlag", (Object)"icon_noNote");
                this.request.setAttribute("subjectToUpdate", (Object)subject);
                this.request.setAttribute("subjectGender", (Object)String.valueOf(subject.getGender()));
                this.setDNFlag(subjectId);
                this.forwardPage(Page.UPDATE_SUBJECT);
            } else if ("confirm".equalsIgnoreCase(action)) {
                this.confirm(subject, subjectId);
            } else {
                String gender = fp.getString("gender");
                subject.setGender(gender.charAt(0));
                if (this.currentStudy.getStudyParameterConfig().getSubjectPersonIdRequired().equals("required") || this.currentStudy.getStudyParameterConfig().getSubjectPersonIdRequired().equals("optional")) {
                    subject.setUniqueIdentifier(fp.getString(INPUT_UNIQUE_IDENTIFIER));
                }
                subject.setUpdater(this.ub);
                if (!this.currentStudy.getStudyParameterConfig().getCollectDob().equals("3")) {
                    String d_date;
                    if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2") && (d_date = fp.getString(DATE_DOB_TO_SAVE)) != null && d_date.trim().length() != 0) {
                        Date date_new = this.yformat.parse(fp.getString(DATE_DOB_TO_SAVE));
                        subject.setDateOfBirth(date_new);
                    }
                    if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
                        Date date_new = this.local_df.parse(fp.getString(DATE_DOB_TO_SAVE));
                        subject.setDateOfBirth(date_new);
                    }
                }
                sdao.update((EntityBean)subject);
                DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
                FormDiscrepancyNotes fdn = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
                AddNewSubjectServlet.saveFieldNotes((String)"gender", (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)subject.getId(), (String)"subject", (StudyBean)this.currentStudy);
                AddNewSubjectServlet.saveFieldNotes((String)DATE_DOB, (FormDiscrepancyNotes)fdn, (DiscrepancyNoteDAO)dndao, (int)subject.getId(), (String)"subject", (StudyBean)this.currentStudy);
                this.addPageMessage(respage.getString("subject_updated_succcesfully"));
                if (studySubId > 0) {
                    this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
                    this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
                } else {
                    this.forwardPage(Page.LIST_SUBJECT_SERVLET);
                }
            }
        }
    }

    private void confirm(SubjectBean subject, int subjectId) throws Exception {
        String personId;
        FormDiscrepancyNotes discNotes = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
        if (discNotes == null) {
            discNotes = new FormDiscrepancyNotes();
        }
        DiscrepancyValidator v = new DiscrepancyValidator(this.request, discNotes);
        FormProcessor fp = new FormProcessor(this.request);
        if (this.currentStudy.getStudyParameterConfig().getPersonIdShownOnCRF().equals("true")) {
            v.addValidation(INPUT_UNIQUE_IDENTIFIER, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
            v.alwaysExecuteLastValidation(INPUT_UNIQUE_IDENTIFIER);
        }
        if ((personId = fp.getString(INPUT_UNIQUE_IDENTIFIER)).contains("<") || personId.contains(">")) {
            v.addValidation(INPUT_UNIQUE_IDENTIFIER, 47);
        }
        if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
            if (!StringUtil.isBlank((String)fp.getString(DATE_DOB))) {
                v.addValidation(DATE_DOB, 4);
                v.alwaysExecuteLastValidation(DATE_DOB);
            } else if (StringUtil.isBlank((String)fp.getString(DATE_DOB)) && subject.getDateOfBirth() != null) {
                Validator.addError((HashMap)this.errors, (String)DATE_DOB, (String)resexception.getString("field_not_blank"));
            }
            if (fp.getDate(DATE_DOB) != null) {
                subject.setDateOfBirth(fp.getDate(DATE_DOB));
                String converted_date = this.local_df.format(subject.getDateOfBirth());
                this.request.setAttribute(DATE_DOB_TO_SAVE, (Object)converted_date);
            }
        } else if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2")) {
            if (!StringUtils.isBlank((String)fp.getString(DATE_DOB))) {
                String submitted_date = fp.getString(DATE_DOB);
                boolean isTheSameDate = false;
                try {
                    Date fakeDOB = this.yformat.parse(submitted_date);
                    if (subject.getDateOfBirth() != null && subject.getDateOfBirth().getYear() == fakeDOB.getYear()) {
                        isTheSameDate = true;
                        String converted_date = this.yformat.format(subject.getDateOfBirth());
                        this.request.setAttribute(DATE_DOB_TO_SAVE, (Object)converted_date);
                    }
                }
                catch (ParseException pe) {
                    this.logger.debug("update subject: cannot convert date " + submitted_date);
                }
                if (!isTheSameDate) {
                    v.addValidation(DATE_DOB, 10);
                    v.alwaysExecuteLastValidation(DATE_DOB);
                    v.addValidation(DATE_DOB, 18, NumericComparisonOperator.GREATER_THAN_OR_EQUAL_TO, 1000);
                    Date today = new Date();
                    Calendar c = Calendar.getInstance();
                    c.setTime(today);
                    int currentYear = c.get(1);
                    v.addValidation(DATE_DOB, 18, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, currentYear);
                    int yob = fp.getInt(DATE_DOB);
                    Date fakeDate = new Date(yob);
                    String dobString = this.yformat.format(fakeDate);
                    try {
                        Date fakeDOB = this.yformat.parse(dobString);
                        if (yob != 0) {
                            subject.setDateOfBirth(fakeDOB);
                        }
                        this.request.setAttribute(DATE_DOB_TO_SAVE, (Object)yob);
                    }
                    catch (ParseException pe) {
                        this.logger.debug("Parse exception happened.");
                        Validator.addError((HashMap)this.errors, (String)DATE_DOB, (String)resexception.getString("please_enter_a_valid_year_birth"));
                    }
                }
                this.request.setAttribute(DATE_DOB, (Object)fp.getString(DATE_DOB));
            } else {
                Validator.addError((HashMap)this.errors, (String)DATE_DOB, (String)resexception.getString("field_not_blank"));
            }
        }
        this.errors = v.validate();
        if (this.currentStudy.getStudyParameterConfig().getSubjectPersonIdRequired().equals("required") || this.currentStudy.getStudyParameterConfig().getSubjectPersonIdRequired().equals("optional")) {
            String uniqueIdentifier = fp.getString(INPUT_UNIQUE_IDENTIFIER);
            if (this.currentStudy.getStudyParameterConfig().getSubjectPersonIdRequired().equals("required") && subject.getUniqueIdentifier() != null && !subject.getUniqueIdentifier().isEmpty() && (uniqueIdentifier == null || uniqueIdentifier.isEmpty())) {
                Validator.addError((HashMap)this.errors, (String)INPUT_UNIQUE_IDENTIFIER, (String)resexception.getString("field_not_blank"));
            }
            if (uniqueIdentifier != null && !uniqueIdentifier.isEmpty()) {
                SubjectBean subjectWithSameId;
                SubjectDAO sdao;
                SubjectBean sub1;
                if (uniqueIdentifier.length() > 255) {
                    String descr = resexception.getString("input_provided_is_not") + NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO.getDescription() + " 255 " + resword.getString("characters_long") + ".";
                    Validator.addError((HashMap)this.errors, (String)INPUT_UNIQUE_IDENTIFIER, (String)descr);
                }
                if ((sub1 = (SubjectBean)(sdao = new SubjectDAO(this.sm.getDataSource())).findAnotherByIdentifier(uniqueIdentifier, subject.getId())).getId() > 0) {
                    Validator.addError((HashMap)this.errors, (String)INPUT_UNIQUE_IDENTIFIER, (String)resexception.getString("person_ID_used_by_another_choose_unique"));
                }
                if ((subjectWithSameId = sdao.findByUniqueIdentifier(uniqueIdentifier)).isActive() && subjectWithSameId.getId() != subject.getId()) {
                    Validator.addError((HashMap)this.errors, (String)INPUT_UNIQUE_IDENTIFIER, (String)resexception.getString("another_assigned_this_ID_choose_unique"));
                }
            }
            subject.setUniqueIdentifier(uniqueIdentifier);
        }
        if (!StringUtil.isBlank((String)fp.getString("gender"))) {
            subject.setGender(fp.getString("gender").charAt(0));
        } else {
            if (this.currentStudy.getStudyParameterConfig().getGenderRequired().equals("true") && subject.getGender() != ' ') {
                Validator.addError((HashMap)this.errors, (String)"gender", (String)resexception.getString("field_not_blank"));
            }
            subject.setGender(' ');
        }
        this.request.setAttribute("subjectToUpdate", (Object)subject);
        if (this.errors.isEmpty()) {
            this.forwardPage(Page.UPDATE_SUBJECT_CONFIRM);
        } else {
            this.logger.error("update subject validation errors");
            this.setInputMessages(this.errors);
            this.setDNFlag(subjectId);
            this.setLocalDOB(subject);
            if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2")) {
                this.request.setAttribute(DATE_DOB, (Object)"");
            }
            this.forwardPage(Page.UPDATE_SUBJECT);
        }
    }

    private void setDNFlag(int subjectId) {
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
        this.request.setAttribute("genderDNFlag", (Object)"icon_noNote");
        this.request.setAttribute("birthDNFlag", (Object)"icon_noNote");
        int flagRStatusId = dndao.getResolutionStatusIdForSubjectDNFlag(subjectId, "gender");
        if (flagRStatusId > 0) {
            this.request.setAttribute("genderDNFlag", (Object)AbstractTableFactory.getDNFlagIconName((int)flagRStatusId));
        }
        if ((flagRStatusId = dndao.getResolutionStatusIdForSubjectDNFlag(subjectId, "date_of_birth")) > 0) {
            this.request.setAttribute("birthDNFlag", (Object)AbstractTableFactory.getDNFlagIconName((int)flagRStatusId));
        }
    }

    private void setLocalDOB(SubjectBean subject) {
        Date birthDate = subject.getDateOfBirth();
        try {
            if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
                String localBirthDate = this.local_df.format(birthDate);
                this.request.setAttribute(DATE_DOB, (Object)localBirthDate);
            } else if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2")) {
                String localBirthDate = this.yformat.format(birthDate);
                this.request.setAttribute(DATE_DOB, (Object)localBirthDate);
            }
        }
        catch (NullPointerException e) {
            this.logger.debug("update subject: cannot convert date " + birthDate);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

