/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewUserAccountServlet
extends SecureController {
    public static final String PATH = "ViewUserAccount";
    public static final String ARG_USER_ID = "userId";

    public static String getLink(int userId) {
        return "ViewUserAccount?userId=" + userId;
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int userId = fp.getInt(ARG_USER_ID, true);
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean user = this.getBean(udao, userId);
        this.techAdminProtect(user);
        if (!user.isActive()) {
            throw new InconsistentStateException(Page.ADMIN_SYSTEM, resexception.getString("the_user_attemping_to_view_not_exists"));
        }
        this.request.setAttribute("user", (Object)user);
        String pattn = "";
        pattn = ResourceBundleProvider.getFormatBundle().getString("date_format_string");
        this.request.setAttribute("dateFormatPattern", (Object)pattn);
        this.forwardPage(Page.VIEW_USER_ACCOUNT);
    }

    private UserAccountBean getBean(UserAccountDAO udao, int id) {
        UserAccountBean answer = (UserAccountBean)udao.findByPK(id);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList roles = answer.getRoles();
        for (int i = 0; i < roles.size(); ++i) {
            StudyUserRoleBean sur = (StudyUserRoleBean)roles.get(i);
            StudyBean sb = (StudyBean)sdao.findByPK(sur.getStudyId());
            sur.setStudyName(sb.getName());
            roles.set(i, sur);
        }
        answer.setRoles(roles);
        return answer;
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

