/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.FilterBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.extract.FilterDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.FilterRow;

public class ApplyFilterServlet
extends SecureController {
    public static final String BEAN_YEARS = "years";
    public static final String BEAN_MONTHS = "months";
    public static final String BEAN_FILTER = "filter";
    public static final String DETAILS_URL = "ApplyFilter?action=details";
    public static final String ARG_FILTER_ID = "filterId";

    public static String getLink(int filterId) {
        return "ApplyFilter?action=details&filterId=" + filterId;
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        if (StringUtil.isBlank((String)action)) {
            EntityBeanTable table = this.getFilterTable();
            this.request.setAttribute("table", (Object)table);
            this.forwardPage(Page.APPLY_FILTER);
        } else if ("validate".equalsIgnoreCase(action)) {
            FormProcessor fp = new FormProcessor(this.request);
            HashMap errors = new HashMap();
            if (fp.getString("submit").equalsIgnoreCase(resword.getString("apply_filter"))) {
                if (fp.getInt(ARG_FILTER_ID) > 0) {
                    FilterDAO fdao = new FilterDAO(this.sm.getDataSource());
                    FilterBean fb = (FilterBean)fdao.findByPK(fp.getInt(ARG_FILTER_ID));
                    this.session.setAttribute("newFilter", (Object)fb);
                } else {
                    Validator.addError(errors, (String)"all", (String)resword.getString("no_filter_was_chosen"));
                }
                if (!errors.isEmpty()) {
                    EntityBeanTable table = this.getFilterTable();
                    this.request.setAttribute("table", (Object)table);
                    this.addPageMessage(respage.getString("errors_in_submission_see_below"));
                    this.setInputMessages(errors);
                    this.forwardPage(Page.APPLY_FILTER);
                } else {
                    this.request.setAttribute("statuses", (Object)this.getStatuses());
                    this.forwardPage(Page.CREATE_DATASET_4);
                }
            } else if (fp.getString("submit").equalsIgnoreCase(resword.getString("create_new_filter"))) {
                this.forwardPage(Page.CREATE_FILTER_SCREEN_2);
            } else if (fp.getString("submit").equalsIgnoreCase(resword.getString("skip_apply_filter_and_save"))) {
                String[] fieldNames = new String[]{"firstmonth", "firstyear", "lastmonth", "lastyear"};
                fp.setCurrentIntValuesAsPreset(fieldNames);
                this.setPresetValues(fp.getPresetValues());
                this.request.setAttribute(BEAN_MONTHS, (Object)this.getMonths());
                this.request.setAttribute(BEAN_YEARS, (Object)this.getYears());
                this.forwardPage(Page.CREATE_DATASET_3);
            }
        } else if (!"return".equalsIgnoreCase(action) && "details".equalsIgnoreCase(action)) {
            FormProcessor fp = new FormProcessor(this.request);
            int filterId = fp.getInt(ARG_FILTER_ID);
            FilterDAO fDAO = new FilterDAO(this.sm.getDataSource());
            FilterBean showFilter = (FilterBean)fDAO.findByPK(filterId);
            this.request.setAttribute(BEAN_FILTER, (Object)showFilter);
            this.forwardPage(Page.VIEW_FILTER_DETAILS);
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private ArrayList getMonths() {
        ArrayList<String> answer = new ArrayList<String>();
        answer.add(resword.getString("January"));
        answer.add(resword.getString("February"));
        answer.add(resword.getString("March"));
        answer.add(resword.getString("April"));
        answer.add(resword.getString("May"));
        answer.add(resword.getString("June"));
        answer.add(resword.getString("July"));
        answer.add(resword.getString("August"));
        answer.add(resword.getString("September"));
        answer.add(resword.getString("October"));
        answer.add(resword.getString("November"));
        answer.add(resword.getString("December"));
        return answer;
    }

    private ArrayList getYears() {
        ArrayList<String> answer = new ArrayList<String>();
        Calendar currTime = Calendar.getInstance();
        int currYear = currTime.get(1);
        for (int i = 1980; i <= currYear; ++i) {
            answer.add(String.valueOf(i));
        }
        return answer;
    }

    private ArrayList getStatuses() {
        Status[] statusesArray = new Status[]{Status.AVAILABLE, Status.PENDING, Status.PRIVATE, Status.UNAVAILABLE};
        List<Status> statuses = Arrays.asList(statusesArray);
        return new ArrayList<Status>(statuses);
    }

    private EntityBeanTable getFilterTable() {
        FormProcessor fp = new FormProcessor(this.request);
        FilterDAO fdao = new FilterDAO(this.sm.getDataSource());
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList filters = new ArrayList();
        filters = this.ub.isSysAdmin() ? (ArrayList)fdao.findAllAdmin() : (ArrayList)fdao.findAll();
        ArrayList filterRows = FilterRow.generateRowsFromBeans((ArrayList)filters);
        String[] columns = new String[]{resword.getString("filter_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(5);
        table.setQuery("ApplyFilter", new HashMap());
        table.setRows(filterRows);
        table.computeDisplay();
        return table;
    }
}

