/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.FilterBean;
import org.akaza.openclinica.bean.extract.FilterObjectBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.extract.FilterDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.FilterRow;

public class CreateFiltersTwoServlet
extends SecureController {
    Locale locale;

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        StudyBean studyWithEventDefs = this.currentStudy;
        if (this.currentStudy.getParentStudyId() > 0) {
            studyWithEventDefs = new StudyBean();
            studyWithEventDefs.setId(this.currentStudy.getParentStudyId());
        }
        if (!StringUtil.isBlank((String)action)) {
            if ("begin".equalsIgnoreCase(action)) {
                StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
                HashMap events = sedao.findCRFsByStudy(studyWithEventDefs);
                if (events.isEmpty()) {
                    this.addPageMessage(respage.getString("no_CRF_assigned_pick_another"));
                    FormProcessor fp = new FormProcessor(this.request);
                    FilterDAO fdao = new FilterDAO(this.sm.getDataSource());
                    EntityBeanTable table = fp.getEntityBeanTable();
                    ArrayList filters = (ArrayList)fdao.findAll();
                    ArrayList filterRows = FilterRow.generateRowsFromBeans((ArrayList)filters);
                    String[] columns = new String[]{resword.getString("filter_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
                    table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
                    table.hideColumnLink(5);
                    table.addLink(resword.getString("create_new_filter"), "CreateFiltersOne?action=begin");
                    table.setQuery("CreateFiltersOne", new HashMap());
                    table.setRows(filterRows);
                    table.computeDisplay();
                    this.request.setAttribute("table", (Object)table);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_1);
                } else {
                    this.request.setAttribute("events", (Object)events);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_3);
                }
            } else if ("crfselected".equalsIgnoreCase(action)) {
                FormProcessor fp = new FormProcessor(this.request);
                HashMap errors = new HashMap();
                int crfId = fp.getInt("crfId");
                if (crfId > 0) {
                    CRFVersionDAO cvDAO = new CRFVersionDAO(this.sm.getDataSource());
                    CRFDAO cDAO = new CRFDAO(this.sm.getDataSource());
                    SectionDAO secDAO = new SectionDAO(this.sm.getDataSource());
                    Collection sections = secDAO.findByVersionId(crfId);
                    CRFVersionBean cvBean = (CRFVersionBean)cvDAO.findByPK(crfId);
                    CRFBean cBean = (CRFBean)cDAO.findByPK(cvBean.getCrfId());
                    this.request.setAttribute("sections", (Object)sections);
                    this.session.setAttribute("cBean", (Object)cBean);
                    this.session.setAttribute("cvBean", (Object)cvBean);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_3_1);
                } else {
                    this.addPageMessage(respage.getString("select_a_CRF_before_picking"));
                    StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
                    HashMap events = sedao.findCRFsByStudy(studyWithEventDefs);
                    this.request.setAttribute("events", (Object)events);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_3);
                }
            } else if ("sectionselected".equalsIgnoreCase(action)) {
                FormProcessor fp = new FormProcessor(this.request);
                int sectionId = fp.getInt("sectionId");
                if (sectionId > 0) {
                    SectionDAO secDAO = new SectionDAO(this.sm.getDataSource());
                    SectionBean secBean = (SectionBean)secDAO.findByPK(sectionId);
                    this.session.setAttribute("secBean", (Object)secBean);
                    ItemFormMetadataDAO ifmDAO = new ItemFormMetadataDAO(this.sm.getDataSource());
                    ArrayList metadatas = ifmDAO.findAllBySectionId(sectionId);
                    if (metadatas.size() > 0) {
                        this.request.setAttribute("metadatas", (Object)metadatas);
                        this.forwardPage(Page.CREATE_FILTER_SCREEN_3_2);
                    } else {
                        CRFVersionBean cvBean = (CRFVersionBean)this.session.getAttribute("cvBean");
                        this.addPageMessage(respage.getString("section_not_have_questions_select_another"));
                        Collection sections = secDAO.findByVersionId(cvBean.getId());
                        this.request.setAttribute("sections", (Object)sections);
                        this.forwardPage(Page.CREATE_FILTER_SCREEN_3_1);
                    }
                } else {
                    CRFVersionBean cvBean = (CRFVersionBean)this.session.getAttribute("cvBean");
                    this.addPageMessage(respage.getString("select_section_before_select_question"));
                    SectionDAO secDAO = new SectionDAO(this.sm.getDataSource());
                    Collection sections = secDAO.findByVersionId(cvBean.getId());
                    this.request.setAttribute("sections", (Object)sections);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_3_1);
                }
            } else if ("questionsselected".equalsIgnoreCase(action)) {
                ArrayList alist = this.extractIdsFromForm();
                if (alist.size() > 0) {
                    ItemFormMetadataDAO ifmDAO = new ItemFormMetadataDAO(this.sm.getDataSource());
                    ArrayList questions = ifmDAO.findByMultiplePKs(alist);
                    this.session.setAttribute("questions", (Object)questions);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_4);
                } else {
                    SectionBean secBean = (SectionBean)this.session.getAttribute("secBean");
                    this.addPageMessage(respage.getString("select_questions_before_set_parameters"));
                    ItemFormMetadataDAO ifmDAO = new ItemFormMetadataDAO(this.sm.getDataSource());
                    ArrayList metadatas = ifmDAO.findAllBySectionId(secBean.getId());
                    this.request.setAttribute("metadatas", (Object)metadatas);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_3_2);
                }
            } else if ("validatecriteria".equalsIgnoreCase(action)) {
                FormProcessor fp = new FormProcessor(this.request);
                String logical = fp.getString("logical");
                ArrayList questions = (ArrayList)this.session.getAttribute("questions");
                ArrayList<FilterObjectBean> filterobjects = new ArrayList<FilterObjectBean>();
                Iterator q_it = questions.iterator();
                int arrCnt = 0;
                while (q_it.hasNext()) {
                    ItemFormMetadataBean ifmBean = (ItemFormMetadataBean)q_it.next();
                    String opString = "operator:" + ifmBean.getId();
                    String valString = "value:" + ifmBean.getId();
                    String remString = "remove:" + ifmBean.getId();
                    if ("remove".equals(fp.getString(remString))) {
                        this.logger.info("found the string: " + remString);
                        ++arrCnt;
                        continue;
                    }
                    String operator = fp.getString(opString);
                    String value = fp.getString(valString);
                    FilterObjectBean fob = new FilterObjectBean();
                    fob.setItemId(ifmBean.getId());
                    fob.setItemName(ifmBean.getHeader() + " " + ifmBean.getLeftItemText() + " " + ifmBean.getRightItemText());
                    if ("equal to".equalsIgnoreCase(operator)) {
                        fob.setOperand("=");
                    } else if ("greater than".equalsIgnoreCase(operator)) {
                        fob.setOperand(">");
                    } else if ("less than".equalsIgnoreCase(operator)) {
                        fob.setOperand("<");
                    } else if ("greater than or equal".equalsIgnoreCase(operator)) {
                        fob.setOperand(">=");
                    } else if ("less than or equal".equalsIgnoreCase(operator)) {
                        fob.setOperand("<=");
                    } else if ("like".equalsIgnoreCase(operator)) {
                        fob.setOperand(" like ");
                    } else if ("not like".equalsIgnoreCase(operator)) {
                        fob.setOperand(" not like ");
                    } else {
                        fob.setOperand("!=");
                    }
                    fob.setValue(value);
                    filterobjects.add(fob);
                }
                this.session.setAttribute("questions", (Object)questions);
                FilterDAO fDAO = new FilterDAO(this.sm.getDataSource());
                String newSQL = (String)this.session.getAttribute("newSQL");
                ArrayList newExp = (ArrayList)this.session.getAttribute("newExp");
                String newNewSQL = fDAO.genSQLStatement(newSQL, logical, filterobjects);
                ArrayList newNewExp = fDAO.genExplanation(newExp, logical, filterobjects);
                if (arrCnt == questions.size()) {
                    newNewSQL = newSQL;
                    newNewExp = newExp;
                }
                this.logger.info("new SQL Generated: " + newNewSQL);
                String sub = fp.getString("submit");
                if ("Specify Filter Metadata".equals(sub)) {
                    FilterBean fb = new FilterBean();
                    fb.setSQLStatement(newNewSQL + ")");
                    this.session.removeAttribute("newSQL");
                    this.session.setAttribute("newFilter", (Object)fb);
                    this.request.setAttribute("statuses", (Object)this.getStatuses());
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_5);
                } else {
                    this.session.setAttribute("newSQL", (Object)newNewSQL);
                    this.session.setAttribute("newExp", (Object)newNewExp);
                    StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
                    HashMap events = sedao.findCRFsByStudy(this.currentStudy);
                    this.request.setAttribute("events", (Object)events);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_3);
                }
            }
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    public ArrayList extractIdsFromForm() {
        ArrayList<Integer> retMe = new ArrayList<Integer>();
        Enumeration en = this.request.getParameterNames();
        while (en.hasMoreElements()) {
            String title = (String)en.nextElement();
            if (!title.startsWith("ID")) continue;
            String newId = title.replaceAll("ID", "");
            Integer ifmId = new Integer(newId);
            retMe.add(ifmId);
        }
        return retMe;
    }

    private ArrayList getStatuses() {
        Status[] statusesArray = new Status[]{Status.AVAILABLE, Status.PENDING, Status.PRIVATE, Status.UNAVAILABLE};
        List<Status> statuses = Arrays.asList(statusesArray);
        return new ArrayList<Status>(statuses);
    }
}

