/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.control.extract.EditDatasetServlet;
import org.akaza.openclinica.control.extract.ExportDatasetServlet;
import org.akaza.openclinica.control.extract.RemoveDatasetServlet;
import org.akaza.openclinica.control.extract.ViewDatasetsServlet;
import org.akaza.openclinica.view.Table;

public class DatasetTable
extends Table {
    public DatasetTable() {
        this.columns.add("Dataset Name");
        this.columns.add("Description");
        this.columns.add("Owner");
        this.columns.add("Creation Date");
        this.columns.add("Status");
        this.columns.add("Actions");
    }

    public String getEntitiesNamePlural() {
        return "datasets";
    }

    public String showRow(EntityBean e) {
        DatasetBean db = (DatasetBean)e;
        Status s = db.getStatus();
        String row = "<tr>\n";
        String colorOn = s.equals((Term)Status.AVAILABLE) ? "" : "<font color='gray'>";
        String colorOff = s.equals((Term)Status.AVAILABLE) ? "" : "</font>";
        row = row + "<td>" + colorOn + db.getName() + colorOff + "</td>\n";
        row = row + "<td>" + db.getDescription() + "</td>\n";
        row = row + "<td>" + db.getOwner().getName() + "</td>\n";
        row = row + "<td>" + db.getCreatedDate().toString() + "</td>\n";
        row = row + "<td>" + s.getName() + "</td>\n";
        row = row + "<td>";
        if (!s.equals((Term)Status.DELETED)) {
            String confirmQuestion = "Are you sure you want to delete " + db.getName() + "?";
            String onClick = "onClick=\"return confirm('" + confirmQuestion + "');\"";
            row = row + "<a href='" + ViewDatasetsServlet.getLink((int)db.getId()) + "'>view</a>";
            row = row + " <a href='" + EditDatasetServlet.getLink((int)db.getId()) + "'>edit</a>";
            row = row + " <a href='" + RemoveDatasetServlet.getLink((int)db.getId()) + "'" + onClick + ">delete</a>";
            row = row + " <a href='" + ExportDatasetServlet.getLink((int)db.getId()) + "'" + onClick + ">export dataset</a>";
        }
        row = row + "</td>\n";
        row = row + "</tr>\n";
        row = row + "<tr>\n";
        row = row + "</tr>\n";
        return row;
    }
}

