/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.AuditableEntityBean;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.extract.DownloadDiscrepancyNote;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.core.util.Pair;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.ListNotesFilter;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.ItemGroupMetadataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.service.managestudy.ViewNotesFilterCriteria;
import org.akaza.openclinica.service.managestudy.ViewNotesService;
import org.akaza.openclinica.service.managestudy.ViewNotesSortCriteria;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DiscrepancyNoteOutputServlet
extends SecureController {
    public static String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    public static String CONTENT_DISPOSITION_VALUE = "attachment; filename=";
    private Map<String, String> discrepancyNoteTypesDecoder = this.makeDiscrepancyNoteTypesDecoder();
    private Map<String, String> resolutionStatusDecoder = this.makeResolutionStatusDecoder();

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String fileName = this.request.getParameter("fileName");
        if (fileName != null) {
            fileName = fileName.replaceAll(" ", "_");
        }
        fileName = fileName == null ? "" : fileName;
        String format = this.request.getParameter("fmt");
        String studyIdentifier = this.request.getParameter("studyIdentifier");
        int subjectId = fp.getInt("subjectId");
        int discNoteType = fp.getInt("discNoteType");
        DownloadDiscrepancyNote downLoader = new DownloadDiscrepancyNote();
        if ("csv".equalsIgnoreCase(format)) {
            fileName = fileName + "." + "csv";
            this.response.setContentType(DownloadDiscrepancyNote.CSV);
        } else {
            this.response.setContentType(DownloadDiscrepancyNote.PDF);
            fileName = fileName + ".pdf";
        }
        this.response.addHeader(CONTENT_DISPOSITION_HEADER, CONTENT_DISPOSITION_VALUE + fileName);
        StudyBean studyBean = (StudyBean)this.session.getAttribute("study");
        ListNotesFilter listNotesFilter = new ListNotesFilter();
        ViewNotesService viewNotesService = (ViewNotesService)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()).getBean("viewNotesService");
        ViewNotesFilterCriteria filter = ViewNotesFilterCriteria.buildFilterCriteria((Map)this.getFilters(this.request), (String)this.getDateFormat(), (Map)this.discrepancyNoteTypesDecoder, (Map)this.resolutionStatusDecoder);
        List notes = viewNotesService.listNotes(this.currentStudy, filter, ViewNotesSortCriteria.buildFilterCriteria((List)this.getSortOrder(this.request)));
        ArrayList allDiscNotes = notes instanceof ArrayList ? (ArrayList)notes : new ArrayList(notes);
        allDiscNotes = this.populateRowsWithAttachedData(allDiscNotes);
        DiscrepancyNoteUtil discNoteUtil = new DiscrepancyNoteUtil();
        Set resolutionStatusIds = Collections.emptySet();
        List discrepancyNoteThreads = discNoteUtil.createThreads((List)allDiscNotes, this.sm.getDataSource(), studyBean);
        if ("csv".equalsIgnoreCase(format)) {
            downLoader.downLoadThreadedDiscBeans(discrepancyNoteThreads, DownloadDiscrepancyNote.CSV, this.response, null, DownloadDiscrepancyNote.COMMA);
        } else {
            this.response.setHeader("Pragma", "public");
            downLoader.downLoadThreadedDiscBeans(discrepancyNoteThreads, DownloadDiscrepancyNote.PDF, this.response, studyIdentifier, DownloadDiscrepancyNote.COMMA);
        }
    }

    private Map<String, String> makeDiscrepancyNoteTypesDecoder() {
        HashMap<String, String> decoder = new HashMap<String, String>();
        ResourceBundle reterm = ResourceBundleProvider.getTermsBundle();
        for (DiscrepancyNoteType type : DiscrepancyNoteType.list) {
            decoder.put(type.getName(), Integer.toString(type.getId()));
        }
        decoder.put(reterm.getString("Query_and_Failed_Validation_Check"), "1,3");
        return decoder;
    }

    private Map<String, String> makeResolutionStatusDecoder() {
        HashMap<String, String> decoder = new HashMap<String, String>();
        ResourceBundle reterm = ResourceBundleProvider.getTermsBundle();
        for (ResolutionStatus status : ResolutionStatus.list) {
            decoder.put(status.getName(), Integer.toString(status.getId()));
        }
        decoder.put(reterm.getString("New_and_Updated"), "1,2");
        return decoder;
    }

    private String getDateFormat() {
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        ResourceBundle resformat = ResourceBundleProvider.getFormatBundle((Locale)locale);
        return resformat.getString("date_format_string");
    }

    private Map<String, String> getFilters(HttpServletRequest request) {
        String[] ids;
        HashMap<String, String> filters = new HashMap<String, String>();
        for (String s : ids = new String[]{"studySubject.label", "siteId", "studySubject.labelExact", "discrepancyNoteBean.createdDate", "discrepancyNoteBean.updatedDate", "discrepancyNoteBean.description", "discrepancyNoteBean.user", "discrepancyNoteBean.disType", "discrepancyNoteBean.entityType", "discrepancyNoteBean.resolutionStatus", "age", "days", "eventName", "crfName", "entityName", "entityValue", "discrepancyNoteBean.description", "discrepancyNoteBean.user"}) {
            String val = request.getParameter(s);
            if (val == null) continue;
            filters.put(s, val);
        }
        return filters;
    }

    private List<Pair<String, String>> getSortOrder(HttpServletRequest request) {
        String[] ids = new String[]{"studySubject.label", "discrepancyNoteBean.createdDate", "days", "age"};
        ArrayList<Pair<String, String>> sortOrders = new ArrayList<Pair<String, String>>(4);
        block0: for (String s : ids) {
            String[] orders = request.getParameterValues("sort." + s);
            if (orders == null) continue;
            for (String order : orders) {
                if (!"ASC".equals(order) && !"DESC".equals(order)) continue;
                sortOrders.add((Pair<String, String>)new Pair((Object)s, (Object)order));
                continue block0;
            }
        }
        return sortOrders;
    }

    private ArrayList<DiscrepancyNoteBean> populateRowsWithAttachedData(ArrayList<DiscrepancyNoteBean> noteRows) {
        Locale l = LocaleResolver.getLocale((HttpServletRequest)this.request);
        resword = ResourceBundleProvider.getWordsBundle((Locale)l);
        resformat = ResourceBundleProvider.getFormatBundle((Locale)l);
        SimpleDateFormat sdf = new SimpleDateFormat(resformat.getString("date_format_string"), ResourceBundleProvider.getLocale());
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.sm.getDataSource());
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        StudyDAO studyDao = new StudyDAO(this.sm.getDataSource());
        ItemGroupMetadataDAO igmdao = new ItemGroupMetadataDAO(this.sm.getDataSource());
        ItemGroupDAO igdao = new ItemGroupDAO(this.sm.getDataSource());
        ArrayList<DiscrepancyNoteBean> allNotes = new ArrayList<DiscrepancyNoteBean>();
        for (int i = 0; i < noteRows.size(); ++i) {
            DiscrepancyNoteBean child;
            int j;
            DiscrepancyNoteBean dnb;
            dnb.setCreatedDateString((dnb = noteRows.get(i)).getCreatedDate() == null ? "" : sdf.format(dnb.getCreatedDate()));
            if (dnb.getParentDnId() == 0) {
                ArrayList children = dndao.findAllByStudyAndParent(this.currentStudy, dnb.getId());
                children = children == null ? new ArrayList() : children;
                dnb.setNumChildren(children.size());
                dnb.setChildren(children);
                int lastDnId = dnb.getId();
                int lastChild = 0;
                for (j = 0; j < children.size(); ++j) {
                    child.setCreatedDateString((child = (DiscrepancyNoteBean)children.get(j)).getCreatedDate() == null ? "" : sdf.format(child.getCreatedDate()));
                    child.setUpdatedDateString(child.getCreatedDate() != null ? sdf.format(child.getCreatedDate()) : "");
                    if (child.getId() <= lastDnId) continue;
                    lastDnId = child.getId();
                    lastChild = j;
                }
                if (children.size() > 0) {
                    DiscrepancyNoteBean lastdn = (DiscrepancyNoteBean)children.get(lastChild);
                    dnb.setUpdatedDate(lastdn.getCreatedDate());
                    dnb.setUpdatedDateString(dnb.getUpdatedDate() != null ? sdf.format(dnb.getUpdatedDate()) : "");
                }
            }
            String entityType = dnb.getEntityType();
            if (dnb.getEntityId() > 0 && !entityType.equals("")) {
                CRFBean cb;
                CRFVersionBean cvb;
                AuditableEntityBean aeb = dndao.findEntity(dnb);
                dnb.setEntityName(aeb.getName());
                if (entityType.equalsIgnoreCase("subject")) {
                    SubjectBean sb = (SubjectBean)aeb;
                    StudySubjectBean ssb = studySubjectDAO.findBySubjectIdAndStudy(sb.getId(), this.currentStudy);
                    dnb.setStudySub(ssb);
                    dnb.setSubjectName(ssb.getLabel());
                    String column = dnb.getColumn().trim();
                    if (!StringUtil.isBlank((String)column)) {
                        if ("gender".equalsIgnoreCase(column)) {
                            dnb.setEntityValue(sb.getGender() + "");
                            dnb.setEntityName(resword.getString("gender"));
                        } else if ("date_of_birth".equals(column)) {
                            if (sb.getDateOfBirth() != null) {
                                dnb.setEntityValue(sb.getDateOfBirth().toString());
                            }
                            dnb.setEntityName(resword.getString("date_of_birth"));
                        } else if ("unique_identifier".equalsIgnoreCase(column)) {
                            dnb.setEntityName(resword.getString("unique_identifier"));
                            dnb.setEntityValue(sb.getUniqueIdentifier());
                        }
                    }
                } else if (entityType.equalsIgnoreCase("studySub")) {
                    StudySubjectBean ssb = (StudySubjectBean)aeb;
                    dnb.setStudySub(ssb);
                    dnb.setSubjectName(ssb.getLabel());
                    String column = dnb.getColumn().trim();
                    if (!StringUtil.isBlank((String)column) && "enrollment_date".equals(column)) {
                        if (ssb.getEnrollmentDate() != null) {
                            dnb.setEntityValue(ssb.getEnrollmentDate().toString());
                        }
                        dnb.setEntityName(resword.getString("enrollment_date"));
                    }
                } else if (entityType.equalsIgnoreCase("eventCRF")) {
                    StudyEventBean se = (StudyEventBean)sedao.findByPK(dnb.getEntityId());
                    StudyEventDefinitionBean sedb = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
                    EventCRFBean ecb = (EventCRFBean)aeb;
                    cvb = (CRFVersionBean)cvdao.findByPK(ecb.getCRFVersionId());
                    cb = (CRFBean)cdao.findByPK(cvb.getCrfId());
                    dnb.setStageId(ecb.getStage().getId());
                    dnb.setEntityName(cb.getName() + " (" + cvb.getName() + ")");
                    StudySubjectBean ssub = (StudySubjectBean)studySubjectDAO.findByPK(ecb.getStudySubjectId());
                    dnb.setStudySub(ssub);
                    dnb.setSubjectName(ssub.getLabel());
                    if (se != null) {
                        dnb.setEventStart(se.getDateStarted());
                        dnb.setEventName(se.getName());
                    }
                    dnb.setCrfName(cb.getName());
                    String crfStatus = resword.getString(ecb.getStage().getNameRaw());
                    if (crfStatus.equals("Invalid")) {
                        crfStatus = "";
                    } else if (crfStatus.equals("Data Entry Complete")) {
                        crfStatus = "Complete";
                    }
                    dnb.setCrfStatus(crfStatus);
                    String column = dnb.getColumn().trim();
                    if (!StringUtil.isBlank((String)column)) {
                        if ("date_interviewed".equals(column)) {
                            if (ecb.getDateInterviewed() != null) {
                                dnb.setEntityValue(ecb.getDateInterviewed().toString());
                            }
                            dnb.setEntityName(resword.getString("date_interviewed"));
                        } else if ("interviewer_name".equals(column)) {
                            dnb.setEntityValue(ecb.getInterviewerName());
                            dnb.setEntityName(resword.getString("interviewer_name"));
                        }
                    }
                    dnb.setEvent(se);
                    dnb.setStudyEventDefinitionBean(sedb);
                } else if (entityType.equalsIgnoreCase("studyEvent")) {
                    StudyEventBean se = (StudyEventBean)sedao.findByPK(dnb.getEntityId());
                    StudyEventDefinitionBean sedb = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
                    se.setName(sedb.getName());
                    dnb.setEntityName(sedb.getName());
                    StudySubjectBean ssub = (StudySubjectBean)studySubjectDAO.findByPK(se.getStudySubjectId());
                    dnb.setStudySub(ssub);
                    dnb.setEventStart(se.getDateStarted());
                    dnb.setEventName(se.getName());
                    dnb.setSubjectName(ssub.getLabel());
                    String column = dnb.getColumn().trim();
                    if (!StringUtil.isBlank((String)column)) {
                        if ("date_start".equals(column)) {
                            if (se.getDateStarted() != null) {
                                dnb.setEntityValue(se.getDateStarted().toString());
                            }
                            dnb.setEntityName(resword.getString("start_date"));
                        } else if ("date_end".equals(column)) {
                            if (se.getDateEnded() != null) {
                                dnb.setEntityValue(se.getDateEnded().toString());
                            }
                            dnb.setEntityName(resword.getString("end_date"));
                        } else if ("location".equals(column)) {
                            dnb.setEntityValue(se.getLocation());
                            dnb.setEntityName(resword.getString("location"));
                        }
                    }
                    dnb.setEvent(se);
                    dnb.setStudyEventDefinitionBean(sedb);
                } else if (entityType.equalsIgnoreCase("itemData")) {
                    ItemDataBean idb = (ItemDataBean)iddao.findByPK(dnb.getEntityId());
                    ItemBean ib = (ItemBean)idao.findByPK(idb.getItemId());
                    EventCRFBean ec = (EventCRFBean)ecdao.findByPK(idb.getEventCRFId());
                    cvb = (CRFVersionBean)cvdao.findByPK(ec.getCRFVersionId());
                    cb = (CRFBean)cdao.findByPK(cvb.getCrfId());
                    ItemGroupMetadataBean itemGroupMetadataBean = (ItemGroupMetadataBean)igmdao.findByItemAndCrfVersion(Integer.valueOf(ib.getId()), Integer.valueOf(cvb.getId()));
                    Boolean isRepeatForSure = itemGroupMetadataBean.isRepeatingGroup();
                    if (isRepeatForSure.booleanValue()) {
                        ItemGroupBean ig = (ItemGroupBean)igdao.findByPK(itemGroupMetadataBean.getItemGroupId().intValue());
                        dnb.setItemDataOrdinal(Integer.valueOf(idb.getOrdinal()));
                        dnb.setItemGroupName(ig.getName());
                    }
                    dnb.setStageId(ec.getStage().getId());
                    dnb.setEntityName(ib.getName());
                    dnb.setEntityValue(idb.getValue());
                    StudyEventBean se = (StudyEventBean)sedao.findByPK(ec.getStudyEventId());
                    StudyEventDefinitionBean sedb = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
                    se.setName(sedb.getName());
                    StudySubjectBean ssub = (StudySubjectBean)studySubjectDAO.findByPK(ec.getStudySubjectId());
                    dnb.setStudySub(ssub);
                    dnb.setSubjectName(ssub.getLabel());
                    dnb.setEventStart(se.getDateStarted());
                    dnb.setEventName(se.getName());
                    dnb.setCrfName(cb.getName());
                    String crfStatus = resword.getString(ec.getStage().getNameRaw());
                    if (crfStatus.equals("Invalid")) {
                        crfStatus = "";
                    } else if (crfStatus.equals("Data Entry Complete")) {
                        crfStatus = "Complete";
                    }
                    dnb.setCrfStatus(crfStatus);
                    dnb.setEvent(se);
                    dnb.setStudyEventDefinitionBean(sedb);
                }
            }
            dnb.setStudy((StudyBean)studyDao.findByPK(dnb.getStudyId()));
            if (dnb.getParentDnId() == 0 && dnb.getChildren().size() > 0) {
                ArrayList children = dnb.getChildren();
                int childrenSize = children.size();
                for (j = 0; j < childrenSize; ++j) {
                    child = (DiscrepancyNoteBean)children.get(j);
                    child.setSubjectName(dnb.getSubjectName());
                    child.setEventName(dnb.getEventName());
                    child.setCrfName(dnb.getCrfName());
                    child.setCrfStatus(dnb.getCrfStatus());
                    child.setEntityName(dnb.getEntityName());
                    child.setEntityValue(dnb.getEntityValue());
                    child.setStudySub(dnb.getStudySub());
                    child.setStudy(dnb.getStudy());
                }
            }
            allNotes.add(dnb);
        }
        return allNotes;
    }

    protected void mayProceed() throws InsufficientPermissionException {
    }
}

