/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.TermType;
import org.akaza.openclinica.bean.extract.FilterBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.dao.extract.FilterDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.FilterRow;

public class EditFilterServlet
extends SecureController {
    public static String getLink(int filterId) {
        return "EditFilter?filterId=" + filterId;
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String action = this.request.getParameter("action");
        if ("validate".equalsIgnoreCase(action)) {
            Validator v = new Validator(this.request);
            v.addValidation("fName", 1);
            v.addValidation("fDesc", 1);
            v.addValidation("fStatusId", 17, TermType.STATUS);
            HashMap errors = v.validate();
            if (!errors.isEmpty()) {
                String[] fieldNames = new String[]{"fName", "fDesc"};
                fp.setCurrentStringValuesAsPreset(fieldNames);
                fp.addPresetValue("fStatusId", fp.getInt("fStatusId"));
                this.addPageMessage(respage.getString("errors_in_submission_see_below"));
                this.setInputMessages(errors);
                this.setPresetValues(fp.getPresetValues());
                int filterId = fp.getInt("filterId");
                FilterDAO fDAO = new FilterDAO(this.sm.getDataSource());
                FilterBean showFilter = (FilterBean)fDAO.findByPK(filterId);
                this.request.setAttribute("filter", (Object)showFilter);
                this.request.setAttribute("statuses", (Object)this.getStatuses());
                this.forwardPage(Page.EDIT_FILTER);
            } else {
                int filterId = fp.getInt("filterId");
                FilterDAO fDAO = new FilterDAO(this.sm.getDataSource());
                FilterBean filter = (FilterBean)fDAO.findByPK(filterId);
                filter.setName(fp.getString("fName"));
                filter.setDescription(fp.getString("fDesc"));
                filter.setStatus(Status.get((int)fp.getInt("fStatusId")));
                fDAO.update((EntityBean)filter);
                this.addPageMessage(respage.getString("the_filter_was_succesfully_updated"));
                FilterDAO fdao = new FilterDAO(this.sm.getDataSource());
                EntityBeanTable table = fp.getEntityBeanTable();
                ArrayList filters = (ArrayList)fdao.findAll();
                ArrayList filterRows = FilterRow.generateRowsFromBeans((ArrayList)filters);
                String[] columns = new String[]{resword.getString("filter_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
                table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
                table.hideColumnLink(5);
                table.setQuery("CreateFiltersOne", new HashMap());
                table.setRows(filterRows);
                table.computeDisplay();
                this.request.setAttribute("table", (Object)table);
                this.forwardPage(Page.CREATE_FILTER_SCREEN_1);
            }
        } else {
            int filterId = fp.getInt("filterId");
            FilterDAO fDAO = new FilterDAO(this.sm.getDataSource());
            FilterBean showFilter = (FilterBean)fDAO.findByPK(filterId);
            this.request.setAttribute("filter", (Object)showFilter);
            this.request.setAttribute("statuses", (Object)this.getStatuses());
            this.forwardPage(Page.EDIT_FILTER);
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private ArrayList getStatuses() {
        Status[] statusesArray = new Status[]{Status.AVAILABLE, Status.PENDING, Status.PRIVATE, Status.UNAVAILABLE};
        List<Status> statuses = Arrays.asList(statusesArray);
        return new ArrayList<Status>(statuses);
    }
}

