/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.ArchivedDatasetFileBean;
import org.akaza.openclinica.bean.extract.CommaReportBean;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.extract.ExportFormatBean;
import org.akaza.openclinica.bean.extract.ExtractBean;
import org.akaza.openclinica.bean.extract.ReportBean;
import org.akaza.openclinica.bean.extract.SPSSReportBean;
import org.akaza.openclinica.bean.extract.TabReportBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.extract.ArchivedDatasetFileDAO;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleDao;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.service.extract.GenerateExtractFileService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.bean.ArchivedDatasetFileRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.job.XalanStatefulJob;
import org.akaza.openclinica.web.job.XalanTriggerService;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;
import org.springframework.scheduling.quartz.JobDetailBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExportDatasetServlet
extends SecureController {
    private StdScheduler scheduler;
    private static String SCHEDULER = "schedulerFactoryBean";
    private static final String DATASET_DIR = SQLInitServlet.getField((String)"filePath") + "datasets" + File.separator;
    private static String WEB_DIR = "/WEB-INF/datasets/";
    public File SASFile;
    public String SASFilePath;
    public File SPSSFile;
    public String SPSSFilePath;
    public File TXTFile;
    public String TXTFilePath;
    public File CSVFile;
    public String CSVFilePath;
    public ArrayList fileList;

    public static String getLink(int dsId) {
        return "ExportDataset?datasetId=" + dsId;
    }

    public void processRequest() throws Exception {
        int currentstudyid;
        DatasetDAO dsdao = new DatasetDAO(this.sm.getDataSource());
        ArchivedDatasetFileDAO asdfdao = new ArchivedDatasetFileDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        GenerateExtractFileService generateFileService = new GenerateExtractFileService(this.sm.getDataSource(), (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("coreResources"), (RuleSetRuleDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetRuleDao"));
        String action = fp.getString("action");
        int datasetId = fp.getInt("datasetId");
        int adfId = fp.getInt("adfId");
        if (datasetId == 0) {
            try {
                DatasetBean dsb = (DatasetBean)this.session.getAttribute("newDataset");
                datasetId = dsb.getId();
                this.logger.info("dataset id was zero, trying session: " + datasetId);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                this.logger.info("tripped over null pointer exception");
            }
        }
        DatasetBean db = (DatasetBean)dsdao.findByPK(datasetId);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = (StudyBean)sdao.findByPK(db.getStudyId());
        this.checkRoleByUserAndStudy(this.ub, study.getParentStudyId(), study.getId());
        if (study.getId() != this.currentStudy.getId() && study.getParentStudyId() != this.currentStudy.getId()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        int parentstudy = currentstudyid = this.currentStudy.getId();
        StudyBean parentStudy = new StudyBean();
        if (this.currentStudy.getParentStudyId() > 0) {
            parentStudy = (StudyBean)sdao.findByPK(this.currentStudy.getParentStudyId());
        }
        ExtractBean eb = generateFileService.generateExtractBean(db, this.currentStudy, parentStudy);
        if (StringUtil.isBlank((String)action)) {
            this.loadList(db, asdfdao, datasetId, fp, eb);
            this.forwardPage(Page.EXPORT_DATASETS);
        } else if ("delete".equalsIgnoreCase(action) && adfId > 0) {
            boolean success = false;
            ArchivedDatasetFileBean adfBean = (ArchivedDatasetFileBean)asdfdao.findByPK(adfId);
            File file = new File(adfBean.getFileReference());
            if (!file.canWrite()) {
                this.addPageMessage(respage.getString("write_protected"));
            } else {
                success = file.delete();
                if (success) {
                    asdfdao.deleteArchiveDataset(adfBean);
                    this.addPageMessage(respage.getString("file_removed"));
                } else {
                    this.addPageMessage(respage.getString("error_removing_file"));
                }
            }
            this.loadList(db, asdfdao, datasetId, fp, eb);
            this.forwardPage(Page.EXPORT_DATASETS);
        } else {
            HashMap answerMap;
            this.logger.info("**** found action ****: " + action);
            String generateReport = "";
            String pattern = "yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "HHmmssSSS" + File.separator;
            SimpleDateFormat sdfDir = new SimpleDateFormat(pattern);
            String generalFileDir = DATASET_DIR + db.getId() + File.separator + sdfDir.format(new Date());
            String fileName = "";
            db.setName(db.getName().replaceAll(" ", "_"));
            Page finalTarget = Page.GENERATE_DATASET;
            finalTarget = Page.EXPORT_DATA_CUSTOM;
            long sysTimeBegin = System.currentTimeMillis();
            int fId = 0;
            if ("sas".equalsIgnoreCase(action)) {
                long sysTimeEnd = System.currentTimeMillis() - sysTimeBegin;
                String SASFileName = db.getName() + "_sas.sas";
                generateFileService.createFile(SASFileName, generalFileDir, generateReport, db, sysTimeEnd, ExportFormatBean.TXTFILE, true, this.ub);
                this.logger.info("created sas file");
                this.request.setAttribute("generate", (Object)(generalFileDir + SASFileName));
                finalTarget.setFileName(generalFileDir + SASFileName);
                fileName = SASFileName;
            } else if ("odm".equalsIgnoreCase(action)) {
                String odmVersion = fp.getString("odmVersion");
                String ODMXMLFileName = "";
                answerMap = generateFileService.createODMFile(odmVersion, sysTimeBegin, generalFileDir, db, this.currentStudy, "", eb, Integer.valueOf(this.currentStudy.getId()), Integer.valueOf(this.currentStudy.getParentStudyId()), "99", true, true, true, null, this.ub);
                for (Map.Entry entry : answerMap.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    ODMXMLFileName = (String)key;
                    Integer fileID = (Integer)value;
                    fId = fileID;
                }
                fileName = ODMXMLFileName;
                this.request.setAttribute("generate", (Object)(generalFileDir + ODMXMLFileName));
                this.logger.debug("+++ set the following: " + generalFileDir + ODMXMLFileName);
                if (fp.getString("xalan") != null) {
                    XalanTriggerService xts = new XalanTriggerService();
                    String propertiesPath = SQLInitServlet.getField((String)"filePath");
                    this.openZipFile(generalFileDir + ODMXMLFileName + ".zip");
                    SimpleTrigger simpleTrigger = xts.generateXalanTrigger(propertiesPath + File.separator + "ODMReportStylesheet.xsl", ODMXMLFileName, generalFileDir + "output.sql", db.getId());
                    this.scheduler = this.getScheduler();
                    JobDetailBean jobDetailBean = new JobDetailBean();
                    jobDetailBean.setGroup(XalanTriggerService.TRIGGER_GROUP_NAME);
                    jobDetailBean.setName(simpleTrigger.getName());
                    jobDetailBean.setJobClass(XalanStatefulJob.class);
                    jobDetailBean.setJobDataMap(simpleTrigger.getJobDataMap());
                    jobDetailBean.setDurability(true);
                    jobDetailBean.setVolatility(false);
                    try {
                        Date dateStart = this.scheduler.scheduleJob((JobDetail)jobDetailBean, (Trigger)simpleTrigger);
                        this.logger.info("== found job date: " + dateStart.toString());
                    }
                    catch (SchedulerException se) {
                        se.printStackTrace();
                    }
                }
            } else if ("txt".equalsIgnoreCase(action)) {
                String TXTFileName = "";
                HashMap answerMap2 = generateFileService.createTabFile(eb, sysTimeBegin, generalFileDir, db, currentstudyid, parentstudy, "", this.ub);
                for (Map.Entry entry : answerMap2.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    TXTFileName = (String)key;
                    Integer fileID = (Integer)value;
                    fId = fileID;
                }
                fileName = TXTFileName;
                this.request.setAttribute("generate", (Object)(generalFileDir + TXTFileName));
                this.logger.debug("+++ set the following: " + generalFileDir + TXTFileName);
            } else if ("html".equalsIgnoreCase(action)) {
                TabReportBean answer = new TabReportBean();
                eb = dsdao.getDatasetData(eb, currentstudyid, parentstudy);
                eb.getMetadata();
                eb.computeReport((ReportBean)answer);
                this.request.setAttribute("dataset", (Object)db);
                this.request.setAttribute("extractBean", (Object)eb);
                finalTarget = Page.GENERATE_DATASET_HTML;
            } else if ("spss".equalsIgnoreCase(action)) {
                SPSSReportBean answer = new SPSSReportBean();
                eb = dsdao.getDatasetData(eb, currentstudyid, parentstudy);
                eb.getMetadata();
                eb.computeReport((ReportBean)answer);
                String DDLFileName = "";
                answerMap = generateFileService.createSPSSFile(db, eb, this.currentStudy, parentStudy, sysTimeBegin, generalFileDir, answer, "", this.ub);
                for (Map.Entry entry : answerMap.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    DDLFileName = (String)key;
                    Integer fileID = (Integer)value;
                    fId = fileID;
                }
                this.request.setAttribute("generate", (Object)(generalFileDir + DDLFileName));
                this.logger.debug("+++ set the following: " + generalFileDir + DDLFileName);
            } else if ("csv".equalsIgnoreCase(action)) {
                CommaReportBean answer = new CommaReportBean();
                eb = dsdao.getDatasetData(eb, currentstudyid, parentstudy);
                eb.getMetadata();
                eb.computeReport((ReportBean)answer);
                long sysTimeEnd = System.currentTimeMillis() - sysTimeBegin;
                String CSVFileName = db.getName() + "_comma.txt";
                fId = generateFileService.createFile(CSVFileName, generalFileDir, answer.toString(), db, sysTimeEnd, ExportFormatBean.CSVFILE, true, this.ub);
                fileName = CSVFileName;
                this.logger.info("just created csv file");
                this.request.setAttribute("generate", (Object)(generalFileDir + CSVFileName));
            } else if ("excel".equalsIgnoreCase(action)) {
                long sysTimeEnd = System.currentTimeMillis() - sysTimeBegin;
                String excelFileName = db.getName() + "_excel.xls";
                finalTarget = Page.GENERATE_EXCEL_DATASET;
                this.response.setHeader("Content-Disposition", "attachment; filename=" + db.getName() + "_excel.xls");
                this.request.setAttribute("generate", (Object)(generalFileDir + excelFileName));
                this.logger.info("set 'generate' to :" + generalFileDir + excelFileName);
                fileName = excelFileName;
            }
            if (!finalTarget.equals((Object)Page.GENERATE_EXCEL_DATASET) && !finalTarget.equals((Object)Page.GENERATE_DATASET_HTML)) {
                finalTarget.setFileName("/WEB-INF/jsp/extract/generateMetadataCore.jsp");
                asdfdao = new ArchivedDatasetFileDAO(this.sm.getDataSource());
                ArchivedDatasetFileBean asdfBean = (ArchivedDatasetFileBean)asdfdao.findByPK(fId);
                ArrayList<ArchivedDatasetFileBean> newFileList = new ArrayList<ArchivedDatasetFileBean>();
                newFileList.add(asdfBean);
                ArrayList filterRows = ArchivedDatasetFileRow.generateRowsFromBeans(newFileList);
                EntityBeanTable table = fp.getEntityBeanTable();
                table.setSortingIfNotExplicitlySet(3, false);
                String[] columns = new String[]{resword.getString("file_name"), resword.getString("run_time"), resword.getString("file_size"), resword.getString("created_date"), resword.getString("created_by")};
                table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
                table.hideColumnLink(0);
                table.hideColumnLink(1);
                table.hideColumnLink(2);
                table.hideColumnLink(3);
                table.hideColumnLink(4);
                this.request.setAttribute("dataset", (Object)db);
                this.request.setAttribute("file", (Object)asdfBean);
                table.setRows(filterRows);
                table.computeDisplay();
                this.request.setAttribute("table", (Object)table);
            }
            this.logger.info("set first part of 'generate' to :" + generalFileDir);
            this.logger.info("found file name: " + finalTarget.getFileName());
            this.forwardPage(finalTarget);
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    public ArchivedDatasetFileBean generateFileBean(File datasetFile, String relativePath, int formatId) {
        ArchivedDatasetFileBean adfb = new ArchivedDatasetFileBean();
        adfb.setName(datasetFile.getName());
        if (datasetFile.canRead()) {
            this.logger.info("File can be read");
        } else {
            this.logger.info("File CANNOT be read");
        }
        this.logger.info("Found file length: " + datasetFile.length());
        this.logger.info("Last Modified: " + datasetFile.lastModified());
        adfb.setFileSize(new Long(datasetFile.length()).intValue());
        adfb.setExportFormatId(formatId);
        adfb.setWebPath(relativePath);
        adfb.setDateCreated(new Date(datasetFile.lastModified()));
        return adfb;
    }

    private void openZipFile(String fileName) {
        try {
            ZipFile zipFile = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    this.logger.debug("Extracting directory: " + entry.getName());
                    new File(entry.getName()).mkdir();
                    continue;
                }
                this.logger.debug("Extracting file: " + entry.getName());
                ExportDatasetServlet.copyInputStream((InputStream)zipFile.getInputStream(entry), (OutputStream)new BufferedOutputStream(new FileOutputStream(entry.getName())));
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            this.logger.error("Unhandled exception:");
            ioe.printStackTrace();
            return;
        }
    }

    public void loadList(DatasetBean db, ArchivedDatasetFileDAO asdfdao, int datasetId, FormProcessor fp, ExtractBean eb) {
        this.logger.info("action is blank");
        this.request.setAttribute("dataset", (Object)db);
        this.logger.info("just set dataset to request");
        this.request.setAttribute("extractProperties", (Object)CoreResources.getExtractProperties());
        File currentDir = new File(DATASET_DIR + db.getId() + File.separator);
        ArrayList fileListRaw = new ArrayList();
        fileListRaw = asdfdao.findByDatasetId(datasetId);
        this.fileList = new ArrayList();
        for (ArchivedDatasetFileBean asdfBean : fileListRaw) {
            asdfBean.setWebPath(asdfBean.getFileReference());
            if (new File(asdfBean.getFileReference()).isFile()) {
                this.fileList.add(asdfBean);
                continue;
            }
            this.logger.warn(asdfBean.getFileReference() + " is NOT a file!");
        }
        this.logger.warn("");
        this.logger.warn("file list length: " + this.fileList.size());
        this.request.setAttribute("filelist", (Object)this.fileList);
        ArrayList filterRows = ArchivedDatasetFileRow.generateRowsFromBeans((ArrayList)this.fileList);
        EntityBeanTable table = fp.getEntityBeanTable();
        table.setSortingIfNotExplicitlySet(3, false);
        String[] columns = new String[]{resword.getString("file_name"), resword.getString("run_time"), resword.getString("file_size"), resword.getString("created_date"), resword.getString("created_by"), resword.getString("action")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(0);
        table.hideColumnLink(1);
        table.hideColumnLink(2);
        table.hideColumnLink(3);
        table.hideColumnLink(4);
        table.hideColumnLink(5);
        table.setQuery("ExportDataset?datasetId=" + db.getId(), new HashMap());
        this.session.setAttribute("newDataset", (Object)db);
        table.setRows(filterRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        TabReportBean answer = new TabReportBean();
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.setToPanel(resword.getString("study_name"), eb.getStudy().getName());
        this.setToPanel(resword.getString("protocol_ID"), eb.getStudy().getIdentifier());
        this.setToPanel(resword.getString("dataset_name"), db.getName());
        this.setToPanel(resword.getString("created_date"), this.local_df.format(db.getCreatedDate()));
        this.setToPanel(resword.getString("dataset_owner"), db.getOwner().getName());
        try {
            this.setToPanel(resword.getString("date_last_run"), this.local_df.format(db.getDateLastRun()));
        }
        catch (NullPointerException npe) {
            this.logger.error("exception: " + npe.getMessage());
        }
        this.logger.warn("just set file list to request, sending to page");
    }

    private StdScheduler getScheduler() {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(SCHEDULER);
        return this.scheduler;
    }

    private static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

