/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.DatasetRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

public class ExtractDatasetsMainServlet
extends SecureController {
    public static final String PATH = "ExtractDatasetsMain";
    public static final String ARG_USER_ID = "userId";

    public static String getLink(int userId) {
        return "ExtractDatasetsMain?userId=" + userId;
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        DatasetDAO dsdao = new DatasetDAO(this.sm.getDataSource());
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList datasets = (ArrayList)dsdao.findTopFive(this.currentStudy);
        ArrayList datasetRows = DatasetRow.generateRowsFromBeans((ArrayList)datasets);
        String[] columns = new String[]{resword.getString("dataset_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(5);
        table.addLink(resword.getString("view_all"), "ViewDatasets");
        table.addLink(resword.getString("view_my_datasets"), "ViewDatasets?action=owner&ownerId=" + this.ub.getId());
        table.addLink(resword.getString("create_dataset"), "CreateDataset");
        table.setQuery(PATH, new HashMap());
        table.setRows(datasetRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        this.resetPanel();
        this.request.setAttribute("panel", (Object)this.panel);
        this.forwardPage(Page.EXTRACT_DATASETS_MAIN);
    }

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }
}

