/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class SelectItemsServlet
extends SecureController {
    Locale locale;
    public static String CURRENT_DEF_ID = "currentDefId";

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    public void setUpStudyGroupPage() {
        ArrayList sgclasses = (ArrayList)this.session.getAttribute("allSelectedGroups");
        if (sgclasses == null || sgclasses.size() == 0) {
            StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
            StudyGroupClassDAO sgclassdao = new StudyGroupClassDAO(this.sm.getDataSource());
            StudyBean theStudy = (StudyBean)studydao.findByPK(this.sm.getUserBean().getActiveStudyId());
            sgclasses = sgclassdao.findAllActiveByStudy(theStudy);
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            for (int i = 0; i < sgclasses.size(); ++i) {
                StudyGroupClassBean sgclass = (StudyGroupClassBean)sgclasses.get(i);
                ArrayList studyGroups = sgdao.findAllByGroupClass(sgclass);
                sgclass.setStudyGroups(studyGroups);
            }
        }
        this.session.setAttribute("allSelectedGroups", (Object)sgclasses);
        this.request.setAttribute("allSelectedGroups", (Object)sgclasses);
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int crfId = fp.getInt("crfId");
        int defId = fp.getInt("defId");
        int eventAttr = fp.getInt("eventAttr");
        int subAttr = fp.getInt("subAttr");
        int CRFAttr = fp.getInt("CRFAttr");
        int groupAttr = fp.getInt("groupAttr");
        int discAttr = fp.getInt("discAttr");
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        ItemFormMetadataDAO imfdao = new ItemFormMetadataDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        HashMap events = (HashMap)this.session.getAttribute("eventsForCreateDataset");
        if (events == null) {
            events = new HashMap();
        }
        this.request.setAttribute("eventlist", events);
        this.logger.info("found dob setting: " + this.currentStudy.getStudyParameterConfig().getCollectDob());
        if (crfId == 0) {
            if (eventAttr == 0 && subAttr == 0 && CRFAttr == 0 && groupAttr == 0 && discAttr == 0) {
                this.forwardPage(Page.CREATE_DATASET_2);
            } else if (eventAttr > 0) {
                this.request.setAttribute("subjectAgeAtEvent", (Object)"1");
                if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("3")) {
                    this.request.setAttribute("subjectAgeAtEvent", (Object)"0");
                    this.logger.info("dob not collected, setting age at event to 0");
                }
                this.forwardPage(Page.CREATE_DATASET_EVENT_ATTR);
            } else if (subAttr > 0) {
                if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("3")) {
                    this.logger.info("dob not collected, setting age at event to 0");
                }
                this.forwardPage(Page.CREATE_DATASET_SUB_ATTR);
            } else if (CRFAttr > 0) {
                this.forwardPage(Page.CREATE_DATASET_CRF_ATTR);
            } else if (groupAttr > 0) {
                this.setUpStudyGroupPage();
                this.forwardPage(Page.CREATE_DATASET_GROUP_ATTR);
            } else {
                this.forwardPage(Page.CREATE_DATASET_2);
            }
            return;
        }
        CRFBean crf = (CRFBean)crfdao.findByPK(crfId);
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(defId);
        this.session.setAttribute("crf", (Object)crf);
        this.session.setAttribute("definition", (Object)sed);
        DatasetBean db = (DatasetBean)this.session.getAttribute("newDataset");
        if (db == null) {
            db = new DatasetBean();
        }
        this.session.setAttribute("newDataset", (Object)db);
        ArrayList items = idao.findAllActiveByCRF(crf);
        for (int i = 0; i < items.size(); ++i) {
            ItemBean item = (ItemBean)items.get(i);
            ItemFormMetadataBean meta = imfdao.findByItemIdAndCRFVersionId(item.getId(), item.getItemMeta().getCrfVersionId());
            meta.setCrfVersionName(item.getItemMeta().getCrfVersionName());
            item.getItemMetas().add(meta);
        }
        HashMap<String, ItemBean> itemMap = new HashMap<String, ItemBean>();
        for (int i = 0; i < items.size(); ++i) {
            ItemBean item = (ItemBean)items.get(i);
            if (!itemMap.containsKey(defId + "_" + item.getId())) {
                if (db.getItemMap().containsKey(defId + "_" + item.getId())) {
                    item.setSelected(true);
                    item.setDatasetItemMapKey(defId + "_" + item.getId());
                }
                itemMap.put(defId + "_" + item.getId(), item);
                continue;
            }
            ItemBean uniqueItem = (ItemBean)itemMap.get(defId + "_" + item.getId());
            uniqueItem.getItemMetas().add(item.getItemMetas().get(0));
            if (!db.getItemMap().containsKey(defId + "_" + uniqueItem.getId())) continue;
            uniqueItem.setSelected(true);
        }
        ArrayList itemArray = new ArrayList(itemMap.values());
        Collections.sort(itemArray);
        this.session.setAttribute("allItems", itemArray);
        this.forwardPage(Page.CREATE_DATASET_2);
    }
}

