/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.form;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.dao.core.EntityDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.I18nFormatUtil;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.web.domain.EntityBeanTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormProcessor {
    private HttpServletRequest request;
    private final Locale locale;
    private HashMap presetValues;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String DEFAULT_STRING = "";
    public static final int DEFAULT_INT = 0;
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final Date DEFAULT_DATE = new Date();
    public static final String FIELD_SUBMITTED = "submitted";
    public static final String EBL_PAGE = "ebl_page";
    public static final String EBL_SORT_COLUMN = "ebl_sortColumnInd";
    public static final String EBL_SORT_ORDER = "ebl_sortAscending";
    public static final String EBL_FILTERED = "ebl_filtered";
    public static final String EBL_FILTER_KEYWORD = "ebl_filterKeyword";
    public static final String EBL_PAGINATED = "ebl_paginated";

    public FormProcessor(HttpServletRequest request) {
        this.request = request;
        this.presetValues = new HashMap();
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HashMap getPresetValues() {
        return this.presetValues;
    }

    public void setPresetValues(HashMap presetValues) {
        this.presetValues = presetValues;
    }

    public void clearPresetValues() {
        this.presetValues = new HashMap();
    }

    public String getString(String fieldName, boolean searchAttributes) {
        String result = "";
        if (searchAttributes ? (result = (String)this.request.getAttribute(fieldName)) == null && (result = this.request.getParameter(fieldName)) == null : (result = this.request.getParameter(fieldName)) == null) {
            return "";
        }
        return result;
    }

    public String getString(String fieldName) {
        return this.getString(fieldName, false);
    }

    public ArrayList getStringArray(String fieldName) {
        ArrayList<String> answer = new ArrayList<String>();
        String[] values = this.request.getParameterValues(fieldName);
        if (values != null) {
            for (String element : values) {
                if (element == null) continue;
                answer.add(element);
            }
        }
        return answer;
    }

    public boolean getStartsWith(String partialFieldName) {
        boolean answer = false;
        CharSequence seq = partialFieldName.subSequence(0, partialFieldName.length());
        Enumeration names = this.request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.contains(seq)) continue;
            return true;
        }
        return answer;
    }

    public static int getIntFromString(String value) {
        int result;
        if (value == null) {
            return 0;
        }
        try {
            result = Integer.parseInt(value);
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public int getInt(String fieldName, boolean searchAttributes) {
        String fieldValue = this.getString(fieldName, searchAttributes);
        return FormProcessor.getIntFromString((String)fieldValue);
    }

    public int getInt(String fieldName) {
        return this.getInt(fieldName, false);
    }

    public int getPresentInt(String fieldName, boolean searchAttributes) throws Exception {
        int result;
        String fieldValue = this.getString(fieldName, searchAttributes);
        try {
            result = Integer.parseInt(fieldValue);
        }
        catch (Exception e) {
            throw new Exception("The attribute or parameter with name " + fieldName + " is not an integer; the form is corrupt.");
        }
        return result;
    }

    public int getPresentInt(String fieldName) throws Exception {
        return this.getPresentInt(fieldName, false);
    }

    public boolean getBoolean(String fieldName, boolean searchAttributes) {
        int fieldValue = this.getInt(fieldName, searchAttributes);
        return fieldValue != 0;
    }

    public boolean getBoolean(String fieldName) {
        return this.getBoolean(fieldName, false);
    }

    public float getFloat(String fieldName, boolean searchAttributes) {
        float fltValue;
        String fieldValue = this.getString(fieldName, searchAttributes);
        try {
            fltValue = Float.parseFloat(fieldValue);
        }
        catch (Exception e) {
            fltValue = 0.0f;
        }
        return fltValue;
    }

    public float getFloat(String fieldName) {
        return this.getFloat(fieldName, false);
    }

    public EntityBean getEntity(String fieldName, EntityDAO edao) throws OpenClinicaException {
        int id = this.getInt(fieldName);
        EntityBean result = edao.findByPK(id);
        return result;
    }

    public Date getDateFromString(String date) {
        Date answer;
        try {
            SimpleDateFormat f = I18nFormatUtil.getDateFormat((Locale)this.locale);
            f.setLenient(false);
            answer = f.parse(date);
        }
        catch (Exception e) {
            answer = null;
        }
        return answer;
    }

    public static Date parseDate(String date, Locale locale) {
        Date answer;
        try {
            SimpleDateFormat f = I18nFormatUtil.getDateFormat((Locale)locale);
            f.setLenient(false);
            answer = f.parse(date);
        }
        catch (Exception e) {
            answer = null;
        }
        return answer;
    }

    public Date getDate(String fieldName, boolean searchAttributes) {
        String fieldValue = this.getString(fieldName, searchAttributes);
        return this.getDateFromString(fieldValue);
    }

    public Date getDate(String fieldName) {
        return this.getDate(fieldName, false);
    }

    public Date getDateTimeFromString(String dateTime) {
        Date answer;
        try {
            SimpleDateFormat f = I18nFormatUtil.getDateFormat((Locale)this.locale);
            f.setLenient(false);
            answer = f.parse(dateTime);
        }
        catch (Exception e) {
            answer = DEFAULT_DATE;
        }
        return answer;
    }

    public Date getDateTime(String prefix) {
        Date result;
        ResourceBundle resformat = ResourceBundleProvider.getFormatBundle((Locale)this.locale);
        String date = this.getString(prefix + "Date");
        String hour = this.getString(prefix + "Hour");
        String minute = this.getString(prefix + "Minute");
        String half = this.getString(prefix + "Half");
        if (hour.startsWith("-1")) {
            hour = "12";
        } else if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (minute.startsWith("-1")) {
            minute = "00";
        } else if (minute.length() == 1) {
            minute = "0" + minute;
        }
        if ("".equals(half)) {
            half = "am";
        }
        String fieldValue = date + " " + hour + ":" + minute + ":00 " + half;
        SimpleDateFormat sdf = I18nFormatUtil.getDateTimeFormat((Locale)this.locale);
        sdf.setLenient(false);
        try {
            this.logger.debug("trying to parse " + fieldValue + " on the pattern " + resformat.getString("date_time_format_string"));
            result = sdf.parse(fieldValue);
        }
        catch (Exception fe) {
            this.logger.debug("failed to parse");
            fe.printStackTrace();
            result = DEFAULT_DATE;
            this.logger.debug("replace with default date: " + result.toString());
        }
        this.logger.debug("returning " + result.toString());
        return result;
    }

    public boolean isSubmitted() {
        return this.getBoolean("submitted", true);
    }

    public void addPresetValue(String fieldName, int value) {
        Integer fieldValue = new Integer(value);
        this.presetValues.put(fieldName, fieldValue);
    }

    public void addPresetValue(String fieldName, float value) {
        Float fieldValue = new Float(value);
        this.presetValues.put(fieldName, fieldValue);
    }

    public void addPresetValue(String fieldName, boolean value) {
        Boolean fieldValue = new Boolean(value);
        this.presetValues.put(fieldName, fieldValue);
    }

    public void addPresetValue(String fieldName, String fieldValue) {
        this.presetValues.put(fieldName, fieldValue);
    }

    public void addPresetValue(String fieldName, EntityBean value) {
        int id = value.getId();
        this.presetValues.put(fieldName, value);
    }

    public void setCurrentStringValuesAsPreset(String[] fieldNames) {
        for (String fieldName : fieldNames) {
            String fieldValue = this.getString(fieldName);
            this.addPresetValue(fieldName, fieldValue);
        }
    }

    public void setCurrentIntValuesAsPreset(String[] fieldNames) {
        for (String fieldName : fieldNames) {
            int fieldValue = this.getInt(fieldName);
            this.addPresetValue(fieldName, fieldValue);
        }
    }

    public void setCurrentBoolValuesAsPreset(String[] fieldNames) {
        for (String fieldName : fieldNames) {
            boolean fieldValue = this.getBoolean(fieldName);
            this.addPresetValue(fieldName, fieldValue);
        }
    }

    public void setCurrentDateTimeValuesAsPreset(String[] prefixes) {
        for (String prefix : prefixes) {
            String fieldName = prefix + "Date";
            String date = this.getString(fieldName);
            this.addPresetValue(fieldName, date);
            fieldName = prefix + "Hour";
            int hour = this.getInt(fieldName);
            this.addPresetValue(fieldName, hour);
            fieldName = prefix + "Minute";
            int minute = this.getInt(fieldName);
            this.addPresetValue(fieldName, minute);
            fieldName = prefix + "Half";
            String half = this.getString(fieldName);
            this.addPresetValue(fieldName, half);
        }
    }

    public org.akaza.openclinica.web.bean.EntityBeanTable getEntityBeanTable() {
        org.akaza.openclinica.web.bean.EntityBeanTable answer = new org.akaza.openclinica.web.bean.EntityBeanTable();
        String sortingColumn = this.request.getParameter("ebl_sortColumnInd");
        if (sortingColumn != null && !"".equals(sortingColumn)) {
            answer.setSortingColumnExplicitlySet(true);
        }
        answer.setCurrPageNumber(this.getInt("ebl_page"));
        answer.setSortingColumnInd(this.getInt("ebl_sortColumnInd"));
        answer.setKeywordFilter(this.getString("ebl_filterKeyword"));
        String[] blnFields = new String[]{"ebl_sortAscending", "ebl_filtered", "ebl_paginated"};
        for (int i = 0; i < blnFields.length; ++i) {
            String value = this.getString(blnFields[i]);
            boolean b = this.getBoolean(blnFields[i]);
            if ("".equals(value)) continue;
            if (i == 0) {
                answer.setAscendingSort(b);
                continue;
            }
            if (i == 1) {
                answer.setFiltered(b);
                continue;
            }
            answer.setPaginated(b);
        }
        return answer;
    }

    public EntityBeanTable getWebEntityBeanTable() {
        EntityBeanTable answer = new EntityBeanTable();
        String sortingColumn = this.request.getParameter("ebl_sortColumnInd");
        if (sortingColumn != null && !"".equals(sortingColumn)) {
            answer.setSortingColumnExplicitlySet(true);
        }
        answer.setCurrPageNumber(this.getInt("ebl_page"));
        answer.setSortingColumnInd(this.getInt("ebl_sortColumnInd"));
        answer.setKeywordFilter(this.getString("ebl_filterKeyword"));
        String[] blnFields = new String[]{"ebl_sortAscending", "ebl_filtered", "ebl_paginated"};
        for (int i = 0; i < blnFields.length; ++i) {
            String value = this.getString(blnFields[i]);
            boolean b = this.getBoolean(blnFields[i]);
            if ("".equals(value)) continue;
            if (i == 0) {
                answer.setAscendingSort(b);
                continue;
            }
            if (i == 1) {
                answer.setFiltered(b);
                continue;
            }
            answer.setPaginated(b);
        }
        return answer;
    }

    public String getDateTimeInputString(String prefix) {
        String str = "";
        str = this.getString(prefix + "Date");
        String temp = this.getString(prefix + "Hour");
        str = str + ("-1".equals(temp) ? "" : temp);
        temp = this.getString(prefix + "Minute");
        str = str + ("-1".equals(temp) ? "" : temp);
        temp = this.getString(prefix + "Half");
        str = str + (temp == null || "-1".equals(temp) ? "" : temp);
        return str;
    }

    public boolean timeEntered(String prefix) {
        ResourceBundle resformat = ResourceBundleProvider.getFormatBundle();
        if (!"-1".equals(this.getString(prefix + "Hour")) && !"-1".equals(this.getString(prefix + "Minute"))) {
            if (resformat.getString("date_time_format_string").contains("HH")) {
                return true;
            }
            if (!"".equals(this.getString(prefix + "Half"))) {
                return true;
            }
        }
        return false;
    }
}

