/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.form.spreadsheet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.akaza.openclinica.control.form.spreadsheet.OnChangeSheetValidationCell;
import org.akaza.openclinica.control.form.spreadsheet.OnChangeSheetValidationType;
import org.akaza.openclinica.control.form.spreadsheet.SheetCell;
import org.akaza.openclinica.control.form.spreadsheet.SheetErrors;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationCell;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationContainer;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationType;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidatorHelper;
import org.akaza.openclinica.control.form.spreadsheet.SpreadSheetValidator;
import org.akaza.openclinica.domain.crfdata.InstantOnChangeType;

/*
 * Exception performing whole class analysis ignored.
 */
public class OnChangeSheetValidator
implements SpreadSheetValidator {
    private final SheetValidationContainer sheetValidationContainer;
    private List<OnChangeSheetValidationCell> cells;
    private SheetErrors sheetErrors;

    public OnChangeSheetValidator(SheetValidationContainer spreadSheetValidationContainer, ResourceBundle resPageMsg) {
        this.sheetValidationContainer = spreadSheetValidationContainer;
        this.cells = new ArrayList();
        this.sheetErrors = new SheetErrors(resPageMsg);
    }

    public void validate() {
        for (OnChangeSheetValidationCell cell : this.cells) {
            this.validateWithOrder(cell);
        }
    }

    private void validateWithOrder(OnChangeSheetValidationCell cell) {
        if (cell.getOnChangeTypeFirst() == Boolean.TRUE) {
            this.validateOnChangeType(cell);
            SheetValidatorHelper.validateSheetValidationCell((SheetValidationCell)cell.getSheetValidationCell(), (SheetErrors)this.sheetErrors);
        } else {
            SheetValidatorHelper.validateSheetValidationCell((SheetValidationCell)cell.getSheetValidationCell(), (SheetErrors)this.sheetErrors);
            this.validateOnChangeType(cell);
        }
    }

    private void validateOnChangeType(OnChangeSheetValidationCell cell) {
        if (cell.getType() == OnChangeSheetValidationType.ALL) {
            this.validateCellResValueAll(cell);
        }
    }

    private void validateCellResValueAll(OnChangeSheetValidationCell onChangeSheetValidationCell) {
        boolean printHtmlErr = false;
        SheetCell cell = onChangeSheetValidationCell.getSheetValidationCell().getSheetArgumentCell().getSheetCell();
        ResourceBundle resPageMsg = this.sheetErrors.getResPageMsg();
        if (cell.getColValue() == null || cell.getColValue().isEmpty()) {
            StringBuffer message = this.sheetErrors.errorMessage(resPageMsg.getString(cell.getColTitle()), resPageMsg.getString(SheetValidationType.IS_REQUIRED.getDescription()), resPageMsg.getString(cell.getForWhich()));
            this.sheetErrors.addError(cell.getRowNum(), message);
            this.sheetErrors.putHtmlError(cell.getSheetNum(), cell.getRowNum(), cell.getColNum(), resPageMsg.getString("required_field"));
        } else if (!OnChangeSheetValidator.isValidInstantOnChangeSyntax((String)cell.getColValue())) {
            StringBuffer message = this.sheetErrors.errorMessage(resPageMsg.getString(cell.getColTitle()), resPageMsg.getString(OnChangeSheetValidationType.SHOULD_BE_FUNC_ONCHANGE.getDescription()), resPageMsg.getString(cell.getForWhich()));
            this.sheetErrors.addError(cell.getRowNum(), message);
            printHtmlErr = true;
        } else {
            onChangeSheetValidationCell.setOriAndOption();
            if (!OnChangeSheetValidator.isValidInstantOnChangeType((OnChangeSheetValidationCell)onChangeSheetValidationCell)) {
                StringBuffer message = this.sheetErrors.errorMessage(resPageMsg.getString(cell.getColTitle()), resPageMsg.getString(OnChangeSheetValidationType.SHOULD_BE_FUNC_ONCHANGE_TYPE.getDescription()), resPageMsg.getString(cell.getForWhich()));
                this.sheetErrors.addError(cell.getRowNum(), message);
                printHtmlErr = true;
            }
            if (!this.isValidInstantOnChangeItemPair(onChangeSheetValidationCell)) {
                // empty if block
            }
        }
        if (printHtmlErr && !this.sheetErrors.htmlErrors.containsKey(this.sheetErrors.htmlErrorKey(cell.getSheetNum(), cell.getRowNum(), cell.getColNum()))) {
            this.sheetErrors.putHtmlError(cell.getSheetNum(), cell.getRowNum(), cell.getColNum(), resPageMsg.getString("INVALID_FIELD"));
        }
    }

    public void addValidationCells(OnChangeSheetValidationCell cell) {
        this.cells.add(cell);
    }

    public static boolean isValidInstantOnChangeSyntax(String resValues) {
        String[] t;
        String ss;
        String s;
        String value = resValues.trim();
        return value.startsWith("func:") && "onChange".equalsIgnoreCase(s = (ss = value.substring(5).trim()).substring(0, 8).trim()) && (s = ss.substring(8).trim()).startsWith("(") && s.endsWith(")") && (t = (s = s.substring(1, s.length() - 1).trim()).split(",")).length == 2;
    }

    private boolean isValidInstantOnChangeItemPair(OnChangeSheetValidationCell onChangeSheetValidationCell) {
        SheetCell cell = onChangeSheetValidationCell.getSheetValidationCell().getSheetArgumentCell().getSheetCell();
        ResourceBundle resPageMsg = this.sheetErrors.getResPageMsg();
        Map allItems = this.sheetValidationContainer.getAllItems();
        if (cell.getColValue() != null && cell.getColValue().length() > 0 && allItems.containsKey(onChangeSheetValidationCell.getOriName())) {
            if (this.sheetValidationContainer.inSameSection(cell.getRowName(), onChangeSheetValidationCell.getOriName())) {
                if (this.isValidInstantOnChangeGroupPair(onChangeSheetValidationCell.getOriName(), cell.getRowName())) {
                    return true;
                }
                StringBuffer s = new StringBuffer(onChangeSheetValidationCell.getOriName());
                s.append(" ");
                s.append(resPageMsg.getString("and"));
                s.append(" ");
                s.append(cell.getRowName());
                s.append(" ");
                s.append(resPageMsg.getString(OnChangeSheetValidationType.SHOULD_IN_SAME_REPEATING_GROUP.getDescription()));
                StringBuffer message = this.sheetErrors.errorMessage(resPageMsg.getString(cell.getColTitle()), s.toString(), resPageMsg.getString(cell.getForWhich()));
                this.sheetErrors.addError(cell.getRowNum(), message);
                this.sheetErrors.putHtmlError(cell.getSheetNum(), cell.getRowNum(), 6, resPageMsg.getString("INVALID_FIELD"));
            } else {
                StringBuffer s = new StringBuffer(cell.getRowName());
                s.append(", ");
                s.append(onChangeSheetValidationCell.getOriName());
                s.append(" ");
                s.append(resPageMsg.getString(OnChangeSheetValidationType.SHOULD_IN_SAME_SECTION.getDescription()));
                StringBuffer message = this.sheetErrors.errorMessage(resPageMsg.getString(cell.getColTitle()), s.toString(), resPageMsg.getString(cell.getForWhich()));
                this.sheetErrors.addError(cell.getRowNum(), message);
                this.sheetErrors.putHtmlError(cell.getSheetNum(), cell.getRowNum(), 5, resPageMsg.getString("INVALID_FIELD"));
            }
        } else {
            StringBuffer s = new StringBuffer(onChangeSheetValidationCell.getOriName());
            s.append(" ");
            s.append(resPageMsg.getString(SheetValidationType.ITEM_NAME_SHOULD_PROVIDED.getDescription()));
            StringBuffer message = this.sheetErrors.errorMessage(resPageMsg.getString(cell.getColTitle()), s.toString(), resPageMsg.getString(cell.getForWhich()));
            this.sheetErrors.addError(cell.getRowNum(), message);
            if (!this.sheetErrors.htmlErrors.containsKey(this.sheetErrors.htmlErrorKey(cell.getSheetNum(), cell.getRowNum(), cell.getColNum()))) {
                this.sheetErrors.putHtmlError(cell.getSheetNum(), cell.getRowNum(), cell.getColNum(), resPageMsg.getString("INVALID_FIELD"));
            }
        }
        return this.sheetErrors.getErrors().size() == 0;
    }

    public static boolean isValidInstantOnChangeType(OnChangeSheetValidationCell cell) {
        return cell.getOptionValue() != null && cell.getOptionValue().length() > 0 && InstantOnChangeType.isValidTypeByDescription((String)cell.getOptionValue());
    }

    public boolean isValidInstantOnChangeGroupPair(String oriName, String destName) {
        if (!this.sheetValidationContainer.inRepeatingGroup(oriName) && !this.sheetValidationContainer.inRepeatingGroup(destName)) {
            return true;
        }
        return this.sheetValidationContainer.inSameRepeatingGroup(oriName, destName);
    }

    public SheetErrors getSheetErrors() {
        return this.sheetErrors;
    }

    public List<OnChangeSheetValidationCell> getCells() {
        return this.cells;
    }

    public void setCells(List<OnChangeSheetValidationCell> cells) {
        this.cells = cells;
    }

    public SheetValidationContainer getSheetValidationContainer() {
        return this.sheetValidationContainer;
    }

    public void setSheetErrors(SheetErrors sheetErrors) {
        this.sheetErrors = sheetErrors;
    }
}

