/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.form.spreadsheet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;

public final class SheetErrors {
    List<StringBuffer> errors;
    Map<String, String> htmlErrors;
    ResourceBundle resPageMsg;

    public SheetErrors() {
        this.errors = new ArrayList();
        this.htmlErrors = new HashMap();
        this.resPageMsg = ResourceBundleProvider.getPageMessagesBundle((Locale)Locale.US);
    }

    public SheetErrors(ResourceBundle resPageMsg) {
        this.resPageMsg = resPageMsg;
        this.errors = new ArrayList();
        this.htmlErrors = new HashMap();
    }

    public void putHtmlError(int sheetNum, int rowNum, int colNum, String message) {
        this.htmlErrors.put(this.htmlErrorKey(sheetNum, rowNum, colNum), message);
    }

    protected String htmlErrorKey(int sheetNum, int rowNum, int colNum) {
        StringBuilder s = new StringBuilder();
        s.append(sheetNum);
        s.append(",");
        s.append(rowNum);
        s.append(",");
        s.append(colNum);
        return s.toString();
    }

    protected StringBuffer errorMessage(String colTitle, String message, String forWhich) {
        StringBuffer s = new StringBuffer(colTitle);
        s.append(",");
        s.append(message);
        s.append(" ");
        s.append(this.resPageMsg.getString("for"));
        s.append(" ");
        s.append(forWhich);
        return s;
    }

    protected void addError(int rowNum, StringBuffer message) {
        StringBuffer s = new StringBuffer(message);
        s.append(" ");
        s.append(this.resPageMsg.getString("at_row"));
        s.append(" ");
        s.append(rowNum);
        s.append(", ");
        s.append(this.resPageMsg.getString("items_worksheet"));
        s.append(".");
        this.errors.add(s);
    }

    public Map<String, String> putHtmlErrorsToSheet(Map<String, String> htmlErrorsFromSheet) {
        htmlErrorsFromSheet.putAll(this.htmlErrors);
        return htmlErrorsFromSheet == null ? new HashMap<String, String>() : htmlErrorsFromSheet;
    }

    public List<String> addErrorsToSheet(List<String> errorsFromSheet) {
        if (this.errors.size() > 0) {
            for (StringBuffer s : this.errors) {
                errorsFromSheet.add(s.toString());
            }
        }
        return errorsFromSheet == null ? new ArrayList<String>() : errorsFromSheet;
    }

    public List<StringBuffer> getErrors() {
        return this.errors;
    }

    public void setErrors(List<StringBuffer> errors) {
        this.errors = errors;
    }

    public Map<String, String> getHtmlErrors() {
        return this.htmlErrors;
    }

    public void setHtmlErrors(Map<String, String> htmlErrors) {
        this.htmlErrors = htmlErrors;
    }

    public ResourceBundle getResPageMsg() {
        return this.resPageMsg;
    }

    public void setResPageMsg(ResourceBundle resPageMsg) {
        this.resPageMsg = resPageMsg;
    }
}

