/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.form.spreadsheet;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.akaza.openclinica.control.form.spreadsheet.SheetErrors;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationCell;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationContainer;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidatorHelper;
import org.akaza.openclinica.control.form.spreadsheet.SpreadSheetValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetValidator
implements SpreadSheetValidator {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private SheetValidationContainer sheetValidationContainer;
    private List<SheetValidationCell> cells;
    private SheetErrors sheetErrors;

    public SheetValidator() {
        this.sheetValidationContainer = new SheetValidationContainer();
        this.cells = new ArrayList();
        this.sheetErrors = new SheetErrors();
    }

    public SheetValidator(SheetValidationContainer spreadSheetValidationContainer, ResourceBundle resPageMsg) {
        this.sheetValidationContainer = spreadSheetValidationContainer;
        this.sheetErrors = new SheetErrors(resPageMsg);
    }

    public void validate() {
        for (SheetValidationCell cell : this.cells) {
            this.validate(cell);
        }
    }

    public void validate(SheetValidationCell sheetValidationCell) {
        SheetValidatorHelper.validateSheetValidationCell((SheetValidationCell)sheetValidationCell, (SheetErrors)this.sheetErrors);
    }

    public SheetValidationContainer getSheetValidationContainer() {
        return this.sheetValidationContainer;
    }

    public void setSheetValidationContainer(SheetValidationContainer sheetValidationContainer) {
        this.sheetValidationContainer = sheetValidationContainer;
    }

    public List<SheetValidationCell> getCells() {
        return this.cells;
    }

    public void setCells(List<SheetValidationCell> cells) {
        this.cells = cells;
    }

    public SheetErrors getSheetErrors() {
        return this.sheetErrors;
    }

    public void setSheetErrors(SheetErrors sheetErrors) {
        this.sheetErrors = sheetErrors;
    }
}

