/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.TermType;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.SessionManager;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class RequestAccountServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList studies = (ArrayList)sdao.findAll();
        ArrayList roles = Role.toArrayList();
        roles.remove(Role.ADMIN);
        this.request.setAttribute("roles", (Object)roles);
        this.request.setAttribute("studies", (Object)studies);
        if (StringUtil.isBlank((String)action)) {
            this.session.setAttribute("newUserBean", (Object)new UserAccountBean());
            this.forwardPage(Page.REQUEST_ACCOUNT);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmAccount();
        } else if ("submit".equalsIgnoreCase(action)) {
            this.submitAccount();
        } else {
            this.logger.info("here...");
            this.forwardPage(Page.REQUEST_ACCOUNT);
        }
    }

    private void confirmAccount() throws Exception {
        Validator v = new Validator(this.request);
        v.addValidation("name", 1);
        v.addValidation("firstName", 1);
        v.addValidation("lastName", 1);
        v.addValidation("email", 6);
        v.addValidation("email2", 5, "email");
        v.addValidation("institutionalAffiliation", 1);
        v.addValidation("activeStudyId", 10);
        v.addValidation("activeStudyRole", 17, TermType.ROLE);
        HashMap errors = v.validate();
        FormProcessor fp = new FormProcessor(this.request);
        UserAccountBean ubForm = this.getUserBean();
        this.request.setAttribute("otherStudy", (Object)fp.getString("otherStudy"));
        this.session.setAttribute("newUserBean", (Object)ubForm);
        if (!errors.isEmpty()) {
            this.logger.info("after processing form,error is not empty");
            this.request.setAttribute("formMessages", (Object)errors);
            this.forwardPage(Page.REQUEST_ACCOUNT);
        } else {
            this.logger.info("after processing form,no errors");
            this.sm = new SessionManager(null, ubForm.getName());
            UserAccountBean ubDB = this.sm.getUserBean();
            if (StringUtil.isBlank((String)ubDB.getName())) {
                StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
                StudyBean study = (StudyBean)sdao.findByPK(ubForm.getActiveStudyId());
                String studyName = study.getName();
                this.request.setAttribute("studyName", (Object)studyName);
                this.forwardPage(Page.REQUEST_ACCOUNT_CONFIRM);
            } else {
                this.addPageMessage(respage.getString("your_user_name_used_by_other_try_another"));
                this.forwardPage(Page.REQUEST_ACCOUNT);
            }
        }
    }

    private void submitAccount() throws Exception {
        String otherStudy = this.request.getParameter("otherStudy");
        String studyName = this.request.getParameter("studyName");
        UserAccountBean ubForm = (UserAccountBean)this.session.getAttribute("newUserBean");
        this.logger.info("Sending email...");
        StringBuffer email = new StringBuffer("From: " + ubForm.getEmail() + "\n");
        email.append("Sent: " + new Date() + "\n");
        email.append("To: " + SQLInitServlet.getField((String)"adminEmail") + "\n");
        email.append("Subject: Request Account\n\n\n");
        email.append("Dear Admin, \n\n");
        email.append(ubForm.getFirstName() + " is requesting for an account on the OpenClinica system running at " + SQLInitServlet.getField((String)"sysURL") + ". \n\n");
        email.append("His/her information is shown as follows: \n\n");
        email.append(resword.getString("name") + ": " + ubForm.getFirstName() + " " + ubForm.getLastName());
        email.append("\n" + resword.getString("user_name") + ": " + ubForm.getName());
        email.append("\n" + resword.getString("email") + ": " + ubForm.getEmail());
        email.append("\n" + resword.getString("institutional_affiliation") + ": " + ubForm.getInstitutionalAffiliation());
        email.append("\n" + resword.getString("default_active_study") + ":" + studyName + ", id:" + ubForm.getActiveStudyId());
        email.append("\n" + resword.getString("other_study") + otherStudy);
        email.append("\n" + resword.getString("user_role_requested") + ubForm.getActiveStudyRoleName());
        String emailBody = email.toString();
        this.logger.info("Sending email...begin" + emailBody);
        this.sendEmail(EmailEngine.getAdminEmail(), ubForm.getEmail().trim(), "request account", emailBody, Boolean.valueOf(false));
        this.session.removeAttribute("newUserBean");
        this.forwardPage(Page.LOGIN);
    }

    private UserAccountBean getUserBean() {
        FormProcessor fp = new FormProcessor(this.request);
        UserAccountBean ubForm = new UserAccountBean();
        ubForm.setName(fp.getString("name"));
        ubForm.setFirstName(fp.getString("firstName"));
        ubForm.setLastName(fp.getString("lastName"));
        ubForm.setEmail(fp.getString("email"));
        ubForm.setInstitutionalAffiliation(fp.getString("institutionalAffiliation"));
        ubForm.setActiveStudyId(fp.getInt("activeStudyId"));
        StudyUserRoleBean uRole = new StudyUserRoleBean();
        uRole.setStudyId(fp.getInt("activeStudyId"));
        uRole.setRole(Role.get((int)fp.getInt("activeStudyRole")));
        ubForm.addRole(uRole);
        return ubForm;
    }
}

