/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.login.PwdChallengeQuestion;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.core.SessionManager;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.filter.OpenClinicaJdbcService;

public class RequestPasswordServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        this.session.setAttribute("challengeQuestions", (Object)PwdChallengeQuestion.toArrayList());
        if (StringUtil.isBlank((String)action)) {
            this.request.setAttribute("userBean1", (Object)new UserAccountBean());
            this.forwardPage(Page.REQUEST_PWD);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmPassword();
        } else {
            this.request.setAttribute("userBean1", (Object)new UserAccountBean());
            this.forwardPage(Page.REQUEST_PWD);
        }
    }

    private void confirmPassword() throws Exception {
        UserAccountBean ubDB;
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("email", 6);
        v.addValidation("passwdChallengeQuestion", 1);
        v.addValidation("passwdChallengeAnswer", 1);
        this.errors = v.validate();
        UserAccountBean ubForm = new UserAccountBean();
        ubForm.setName(fp.getString("name"));
        ubForm.setEmail(fp.getString("email"));
        ubForm.setPasswdChallengeQuestion(fp.getString("passwdChallengeQuestion"));
        ubForm.setPasswdChallengeAnswer(fp.getString("passwdChallengeAnswer"));
        this.sm = new SessionManager(null, ubForm.getName(), SpringServletAccess.getApplicationContext((ServletContext)this.context));
        UserAccountDAO uDAO = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean updater = ubDB = (UserAccountBean)uDAO.findByUserName(ubForm.getName());
        this.request.setAttribute("userBean1", (Object)ubForm);
        if (!this.errors.isEmpty()) {
            this.logger.info("after processing form,has errors");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.REQUEST_PWD);
        } else {
            this.logger.info("after processing form,no errors");
            if (ubDB.getEmail() != null && ubDB.getEmail().equalsIgnoreCase(ubForm.getEmail())) {
                this.logger.info("ubDB.getPasswdChallengeQuestion()" + ubDB.getPasswdChallengeQuestion());
                this.logger.info("ubForm.getPasswdChallengeQuestion()" + ubForm.getPasswdChallengeQuestion());
                this.logger.info("ubDB.getPasswdChallengeAnswer()" + ubDB.getPasswdChallengeAnswer());
                this.logger.info("ubForm.getPasswdChallengeAnswer()" + ubForm.getPasswdChallengeAnswer());
                if (ubDB.getPasswdChallengeQuestion().equals(ubForm.getPasswdChallengeQuestion()) && ubDB.getPasswdChallengeAnswer().equalsIgnoreCase(ubForm.getPasswdChallengeAnswer())) {
                    SecurityManager sm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
                    String newPass = sm.genPassword();
                    OpenClinicaJdbcService ocService = (OpenClinicaJdbcService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ocUserDetailsService");
                    String newDigestPass = sm.encrytPassword(newPass, ocService.loadUserByUsername(ubForm.getName()));
                    ubDB.setPasswd(newDigestPass);
                    Calendar cal = Calendar.getInstance();
                    ubDB.setPasswdTimestamp(null);
                    ubDB.setUpdater(updater);
                    ubDB.setLastVisitDate(new Date());
                    this.logger.info("user bean to be updated:" + ubDB.getId() + ubDB.getName() + ubDB.getActiveStudyId());
                    uDAO.update((EntityBean)ubDB);
                    this.sendPassword(newPass, ubDB);
                } else {
                    this.addPageMessage(respage.getString("your_password_not_verified_try_again"));
                    this.forwardPage(Page.REQUEST_PWD);
                }
            } else {
                this.addPageMessage(respage.getString("your_email_address_not_found_try_again"));
                this.forwardPage(Page.REQUEST_PWD);
            }
        }
    }

    private void sendPassword(String passwd, UserAccountBean ubDB) throws Exception {
        this.logger.info("Sending email...");
        StringBuffer email = new StringBuffer("Hello, " + ubDB.getFirstName() + ", <br>");
        email.append(restext.getString("this_email_is_from_openclinica_admin") + "<br>");
        email.append(restext.getString("your_password_has_been_reset_as") + ": " + passwd);
        email.append("<br> " + restext.getString("you_will_be_required_to_change") + " ");
        email.append(restext.getString("time_you_login_to_the_system") + " ");
        email.append(restext.getString("use_the_following_link_to_log") + ":<br> ");
        email.append(SQLInitServlet.getField((String)"sysURL"));
        String emailBody = email.toString();
        this.sendEmail(ubDB.getEmail().trim(), EmailEngine.getAdminEmail(), restext.getString("your_openclinica_password"), emailBody, Boolean.valueOf(true), respage.getString("your_password_reset_new_password_emailed"), respage.getString("your_password_not_send_due_mail_server_problem"), Boolean.valueOf(true));
        this.session.removeAttribute("challengeQuestions");
        this.forwardPage(Page.LOGIN);
    }
}

