/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.login.PasswordValidator;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.hibernate.ConfigurationDao;
import org.akaza.openclinica.dao.hibernate.PasswordRequirementsDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.lang.StringUtils;

public class ResetPasswordServlet
extends SecureController {
    private static final long serialVersionUID = -5259201015824317949L;

    public void mayProceed() throws InsufficientPermissionException {
    }

    public void processRequest() throws Exception {
        this.logger.info("Change expired password");
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        Validator v = new Validator(this.request);
        this.errors.clear();
        FormProcessor fp = new FormProcessor(this.request);
        String mustChangePwd = this.request.getParameter("mustChangePwd");
        String newPwd = fp.getString("passwd").trim();
        String passwdChallengeQ = fp.getString("passwdChallengeQ");
        String passwdChallengeA = fp.getString("passwdChallengeA");
        if ("yes".equalsIgnoreCase(mustChangePwd)) {
            this.addPageMessage(respage.getString("your_password_has_expired_must_change"));
        } else {
            this.addPageMessage(respage.getString("password_expired") + " " + respage.getString("if_you_do_not_want_change_leave_blank"));
        }
        this.request.setAttribute("mustChangePass", (Object)mustChangePwd);
        String oldPwd = fp.getString("oldPasswd").trim();
        UserAccountBean ubForm = new UserAccountBean();
        ubForm.setPasswd(oldPwd);
        ubForm.setPasswdChallengeQuestion(passwdChallengeQ);
        ubForm.setPasswdChallengeAnswer(passwdChallengeA);
        this.request.setAttribute("userBean1", (Object)ubForm);
        SecurityManager sm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
        if (!sm.isPasswordValid(this.ub.getPasswd(), oldPwd, this.getUserDetails())) {
            Validator.addError((HashMap)this.errors, (String)"oldPasswd", (String)resexception.getString("wrong_old_password"));
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.forwardPage(Page.RESET_PASSWORD);
        } else {
            if (mustChangePwd.equalsIgnoreCase("yes")) {
                v.addValidation("passwd", 1);
                v.addValidation("passwd1", 1);
                v.addValidation("passwdChallengeQ", 1);
                v.addValidation("passwdChallengeA", 1);
                v.addValidation("passwd", 29, "oldPasswd");
            }
            String newDigestPass = sm.encrytPassword(newPwd, this.getUserDetails());
            List pwdErrors = new ArrayList();
            if (!StringUtils.isEmpty((String)newPwd)) {
                v.addValidation("passwd", 15);
                v.addValidation("passwd1", 5, "passwd");
                ConfigurationDao configurationDao = (ConfigurationDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(ConfigurationDao.class);
                PasswordRequirementsDao passwordRequirementsDao = new PasswordRequirementsDao(configurationDao);
                Locale locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
                ResourceBundle resexception = ResourceBundleProvider.getExceptionsBundle((Locale)locale);
                pwdErrors = PasswordValidator.validatePassword((PasswordRequirementsDao)passwordRequirementsDao, (UserAccountDAO)udao, (int)this.ub.getId(), (String)newPwd, (String)newDigestPass, (ResourceBundle)resexception);
            }
            this.errors = v.validate();
            for (String err : pwdErrors) {
                Validator.addError((HashMap)this.errors, (String)"passwd", (String)err);
            }
            if (!this.errors.isEmpty()) {
                this.logger.info("ResetPassword page has validation errors");
                this.request.setAttribute("formMessages", (Object)this.errors);
                this.forwardPage(Page.RESET_PASSWORD);
            } else {
                this.logger.info("ResetPassword page has no errors");
                if (!StringUtils.isBlank((String)newPwd)) {
                    this.ub.setPasswd(newDigestPass);
                    this.ub.setPasswdTimestamp(new Date());
                } else if ("no".equalsIgnoreCase(mustChangePwd)) {
                    this.ub.setPasswdTimestamp(new Date());
                }
                this.ub.setOwner(this.ub);
                this.ub.setUpdater(this.ub);
                this.ub.setPasswdChallengeQuestion(passwdChallengeQ);
                this.ub.setPasswdChallengeAnswer(passwdChallengeA);
                udao.update((EntityBean)this.ub);
                ArrayList pageMessages = new ArrayList();
                this.request.setAttribute("pageMessages", pageMessages);
                this.addPageMessage(respage.getString("your_expired_password_reset_successfully"));
                this.ub.incNumVisitsToMainMenu();
                this.forwardPage(Page.MENU_SERVLET);
            }
        }
    }
}

