/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.ItemGroupMetadataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;

public class CRFVersionMetadataUtil {
    private DataSource dataSource = null;

    public CRFVersionMetadataUtil(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ArrayList<SectionBean> retrieveFormMetadata(CRFVersionBean version) throws Exception {
        ArrayList its;
        ItemBean item;
        int i;
        ItemDAO idao = new ItemDAO(this.dataSource);
        ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(this.dataSource);
        SectionDAO sdao = new SectionDAO(this.dataSource);
        ItemGroupDAO igdao = new ItemGroupDAO(this.dataSource);
        ItemGroupMetadataDAO igmdao = new ItemGroupMetadataDAO(this.dataSource);
        ArrayList sections = (ArrayList)sdao.findByVersionId(version.getId());
        HashMap<Integer, ArrayList> versionMap = new HashMap<Integer, ArrayList>();
        for (int i2 = 0; i2 < sections.size(); ++i2) {
            SectionBean section = (SectionBean)sections.get(i2);
            versionMap.put(new Integer(section.getId()), section.getItems());
            ArrayList igs = (ArrayList)igdao.findGroupBySectionId(section.getId());
            for (int j = 0; j < igs.size(); ++j) {
                ArrayList igms = (ArrayList)igmdao.findMetaByGroupAndSection(((ItemGroupBean)igs.get(j)).getId(), section.getCRFVersionId(), section.getId());
                if (igms.isEmpty()) continue;
                ((ItemGroupBean)igs.get(j)).setMeta((ItemGroupMetadataBean)igms.get(0));
                ((ItemGroupBean)igs.get(j)).setItemGroupMetaBeans(igms);
            }
            ((SectionBean)sections.get(i2)).setGroups(igs);
        }
        ArrayList items = idao.findAllItemsByVersionId(version.getId());
        if (igmdao.versionIncluded(version.getId())) {
            for (i = 0; i < items.size(); ++i) {
                item = (ItemBean)items.get(i);
                ItemFormMetadataBean ifm = ifmdao.findByItemIdAndCRFVersionId(item.getId(), version.getId());
                item.setItemMeta(ifm);
                its = (ArrayList)versionMap.get(new Integer(ifm.getSectionId()));
                its.add(item);
            }
        } else {
            for (i = 0; i < items.size(); ++i) {
                item = (ItemBean)items.get(i);
                ItemFormMetadataBean ifm = ifmdao.findByItemIdAndCRFVersionIdNotInIGM(item.getId(), version.getId());
                item.setItemMeta(ifm);
                its = (ArrayList)versionMap.get(new Integer(ifm.getSectionId()));
                its.add(item);
            }
        }
        for (i = 0; i < sections.size(); ++i) {
            SectionBean section = (SectionBean)sections.get(i);
            section.setItems((ArrayList)versionMap.get(new Integer(section.getId())));
        }
        return sections;
    }
}

