/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.NullValue;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class InitUpdateEventDefinitionServlet
extends SecureController {
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_DEFINITION_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        StudyEventDAO sdao = new StudyEventDAO(this.sm.getDataSource());
        int studyId = this.currentStudy.getId();
        if (this.ub.hasRoleInStudy(studyId)) {
            Role r = this.ub.getRoleByStudy(studyId).getRole();
            if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
                return;
            }
            this.addPageMessage(respage.getString("no_have_permission_to_update_study_event_definition") + respage.getString("please_contact_sysadmin_questions"));
            throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_study_director"), "1");
        }
        String idString = this.request.getParameter("id");
        int defId = Integer.valueOf(idString.trim());
        this.logger.info("defId" + defId);
        ArrayList events = (ArrayList)sdao.findAllByDefinition(defId);
        if (events != null && events.size() > 0) {
            this.logger.info("has events");
            for (int i = 0; i < events.size(); ++i) {
                StudyEventBean sb = (StudyEventBean)events.get(i);
                if (sb.getStatus().equals((Term)Status.DELETED) || sb.getStatus().equals((Term)Status.AUTO_DELETED)) continue;
                this.logger.info("found one event");
                this.addPageMessage(respage.getString("sorry_but_at_this_time_may_not_modufy_SED"));
                throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_unpopulated"), "1");
            }
        }
    }

    public void processRequest() throws Exception {
        StudyEventDefinitionDAO sdao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        String idString = this.request.getParameter("id");
        this.logger.info("definition id: " + idString);
        if (StringUtil.isBlank((String)idString)) {
            this.addPageMessage(respage.getString("please_choose_a_definition_to_edit"));
            this.forwardPage(Page.LIST_DEFINITION_SERVLET);
        } else {
            int defId = Integer.valueOf(idString.trim());
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)sdao.findByPK(defId);
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            if (this.currentStudy.getId() != sed.getStudyId()) {
                this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                this.forwardPage(Page.MENU_SERVLET);
                return;
            }
            EventDefinitionCRFDAO edao = new EventDefinitionCRFDAO(this.sm.getDataSource());
            ArrayList eventDefinitionCRFs = (ArrayList)edao.findAllParentsByDefinition(defId);
            CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            ArrayList<EventDefinitionCRFBean> newEventDefinitionCRFs = new ArrayList<EventDefinitionCRFBean>();
            for (int i = 0; i < eventDefinitionCRFs.size(); ++i) {
                EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
                ArrayList versions = (ArrayList)cvdao.findAllActiveByCRF(edc.getCrfId());
                edc.setVersions(versions);
                CRFBean crf = (CRFBean)cdao.findByPK(edc.getCrfId());
                edc.setCrfName(crf.getName());
                edc.setCrf(crf);
                edc.setParticipantForm(edc.isParticipantForm());
                edc.setNullFlags(this.processNullValues(edc));
                CRFVersionBean defaultVersion = (CRFVersionBean)cvdao.findByPK(edc.getDefaultVersionId());
                edc.setDefaultVersionName(defaultVersion.getName());
                String crfPath = sed.getOid() + "." + edc.getCrf().getOid();
                edc.setOffline(this.getEventDefinitionCrfTagService().getEventDefnCrfOfflineStatus(2, crfPath, true));
                newEventDefinitionCRFs.add(edc);
            }
            this.session.setAttribute("definition", (Object)sed);
            this.session.setAttribute("eventDefinitionCRFs", newEventDefinitionCRFs);
            ArrayList<String> sdvOptions = new ArrayList<String>();
            sdvOptions.add(SourceDataVerification.AllREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.PARTIALREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.NOTREQUIRED.toString());
            sdvOptions.add(SourceDataVerification.NOTAPPLICABLE.toString());
            this.request.setAttribute("sdvOptions", sdvOptions);
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
        }
    }

    private HashMap processNullValues(EventDefinitionCRFBean edc) {
        LinkedHashMap<String, String> flags = new LinkedHashMap<String, String>();
        String s = "";
        for (int j = 0; j < edc.getNullValuesList().size(); ++j) {
            NullValue nv1 = (NullValue)edc.getNullValuesList().get(j);
            s = s + nv1.getName().toUpperCase() + ",";
        }
        this.logger.info("********:" + s);
        if (s != null) {
            for (int i = 1; i <= NullValue.toArrayList().size(); ++i) {
                String nv = NullValue.get((int)i).getName().toUpperCase();
                Pattern p = Pattern.compile(nv + "\\W");
                Matcher m = p.matcher(s);
                if (m.find()) {
                    flags.put(nv, "1");
                    this.logger.info("********1:" + nv + " found at " + m.start() + ", " + m.end());
                    continue;
                }
                flags.put(nv, "0");
                this.logger.info("********0:" + nv);
            }
        }
        return flags;
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

