/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudySubjectBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ListStudySubjectServlet;
import org.akaza.openclinica.control.managestudy.SubjectMatrixUtil;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.crfdata.HideCRFManager;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.DisplayStudySubjectEventsRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

public class ListEventsForSubjectServlet
extends SecureController {
    Locale locale;

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        String pageNumber = fp.getString(ListStudySubjectServlet.SUBJECT_PAGE_NUMBER);
        String filterKeyword = fp.getString(ListStudySubjectServlet.FILTER_KEYWORD);
        String tmpSearch = fp.getString(ListStudySubjectServlet.SEARCH_SUBMITTED);
        boolean searchSubmitted = tmpSearch != null && !"".equalsIgnoreCase(tmpSearch) && !"".equalsIgnoreCase(filterKeyword);
        SubjectMatrixUtil matrixUtil = new SubjectMatrixUtil();
        String query = matrixUtil.createPaginatingQuery(pageNumber);
        StringBuilder extendedQuery = new StringBuilder(query);
        String filterKeywordURLEncode = URLEncoder.encode(filterKeyword, "UTF-8");
        if (searchSubmitted) {
            extendedQuery.append("&ebl_sortColumnInd=0&submitted=1&ebl_sortAscending=1&ebl_filtered=1");
            extendedQuery.append("&").append(ListStudySubjectServlet.FILTER_KEYWORD).append("=").append(filterKeywordURLEncode);
        }
        this.request.setAttribute(ListStudySubjectServlet.PAGINATING_QUERY, (Object)extendedQuery.toString());
        int definitionId = fp.getInt("defId");
        int tabId = fp.getInt("tab");
        if (definitionId <= 0) {
            this.addPageMessage(respage.getString("please_choose_an_ED_ta_to_vies_details"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
            return;
        }
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(definitionId);
        StudySubjectDAO sdao = new StudySubjectDAO(this.sm.getDataSource());
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        ArrayList studyGroupClasses = sgcdao.findAllActiveByStudy(this.currentStudy);
        ArrayList allDefs = seddao.findAllActiveByStudy(this.currentStudy);
        boolean isASite = false;
        if (this.currentStudy.getParentStudyId() > 0) {
            StudyDAO stdao = new StudyDAO(this.sm.getDataSource());
            StudyBean parent = (StudyBean)stdao.findByPK(this.currentStudy.getParentStudyId());
            allDefs = seddao.findAllActiveByStudy(parent);
        }
        ArrayList eventDefinitionCRFs = (ArrayList)edcdao.findAllActiveByEventDefinitionId(this.currentStudy, definitionId);
        for (int i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            CRFBean crf = (CRFBean)crfdao.findByPK(edc.getCrfId());
            edc.setCrf(crf);
        }
        this.request.setAttribute("studyGroupClasses", (Object)studyGroupClasses);
        this.request.setAttribute("allDefsArray", (Object)allDefs);
        this.request.setAttribute("allDefsNumber", (Object)new Integer(allDefs.size()));
        this.request.setAttribute("groupSize", (Object)new Integer(studyGroupClasses.size()));
        this.request.setAttribute("eventDefCRFSize", (Object)new Integer(eventDefinitionCRFs.size()));
        this.request.setAttribute("tabId", (Object)new Integer(tabId));
        this.request.setAttribute("studyEventDef", (Object)sed);
        this.request.setAttribute("eventDefCRFs", (Object)eventDefinitionCRFs);
        ArrayList subjects = sdao.findAllByStudyId(this.currentStudy.getId());
        ArrayList<DisplayStudySubjectBean> displayStudySubs = new ArrayList<DisplayStudySubjectBean>();
        for (int i = 0; i < subjects.size(); ++i) {
            DisplayStudyEventBean dseb;
            int k;
            StudySubjectBean studySub = (StudySubjectBean)subjects.get(i);
            ArrayList groups = (ArrayList)sgmdao.findAllByStudySubject(studySub.getId());
            ArrayList<SubjectGroupMapBean> subGClasses = new ArrayList<SubjectGroupMapBean>();
            for (int j = 0; j < studyGroupClasses.size(); ++j) {
                StudyGroupClassBean sgc = (StudyGroupClassBean)studyGroupClasses.get(j);
                boolean hasClass = false;
                for (k = 0; k < groups.size(); ++k) {
                    SubjectGroupMapBean sgmb = (SubjectGroupMapBean)groups.get(k);
                    if (!sgmb.getGroupClassName().equalsIgnoreCase(sgc.getName())) continue;
                    subGClasses.add(sgmb);
                    hasClass = true;
                    break;
                }
                if (hasClass) continue;
                subGClasses.add(new SubjectGroupMapBean());
            }
            ArrayList displaySubjectEvents = new ArrayList();
            ArrayList<DisplayStudyEventBean> displayEvents = new ArrayList<DisplayStudyEventBean>();
            ArrayList events = sedao.findAllByStudySubjectAndDefinition(studySub, sed);
            for (k = 0; k < events.size(); ++k) {
                StudyEventBean seb = (StudyEventBean)events.get(k);
                dseb = ListStudySubjectServlet.getDisplayStudyEventsForStudySubject((StudySubjectBean)studySub, (StudyEventBean)seb, (DataSource)this.sm.getDataSource(), (UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole, (StudyBean)this.currentStudy);
                displayEvents.add(dseb);
            }
            ArrayList al = new ArrayList();
            for (int k2 = 0; k2 < displayEvents.size(); ++k2) {
                dseb = (DisplayStudyEventBean)displayEvents.get(k2);
                ArrayList eventCRFs = dseb.getDisplayEventCRFs();
                for (int a = 0; a < eventDefinitionCRFs.size(); ++a) {
                    EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(a);
                    int crfId = edc.getCrfId();
                    boolean hasCRF = false;
                    for (int b = 0; b < eventCRFs.size(); ++b) {
                        DisplayEventCRFBean decb = (DisplayEventCRFBean)eventCRFs.get(b);
                        if (decb.getEventCRF().getCrf().getId() != crfId) continue;
                        dseb.getAllEventCRFs().add(decb);
                        hasCRF = true;
                        break;
                    }
                    if (hasCRF) continue;
                    DisplayEventCRFBean db = new DisplayEventCRFBean();
                    db.setEventDefinitionCRF(edc);
                    db.getEventDefinitionCRF().setCrf(edc.getCrf());
                    dseb.getAllEventCRFs().add(db);
                }
                if (this.currentStudy.getParentStudyId() <= 0) continue;
                HideCRFManager hideCRFManager = HideCRFManager.createHideCRFManager();
                hideCRFManager.optionallyCheckHideCRFProperty(dseb);
                hideCRFManager.removeHiddenEventCRF(dseb);
                boolean hideCRFs = hideCRFManager.studyEventHasAHideCRFProperty(dseb);
                this.request.setAttribute("hideCRFs", (Object)hideCRFs);
            }
            DisplayStudySubjectBean dssb = new DisplayStudySubjectBean();
            dssb.setStudySubject(studySub);
            dssb.setStudyGroups(subGClasses);
            dssb.setStudyEvents(displayEvents);
            if (definitionId > 0) {
                dssb.setSedId(definitionId);
            } else {
                dssb.setSedId(-1);
            }
            displayStudySubs.add(dssb);
        }
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allStudyRows = DisplayStudySubjectEventsRow.generateRowsFromBeans(displayStudySubs);
        ArrayList<String> columnArray = new ArrayList<String>();
        columnArray.add(resword.getString("ID"));
        columnArray.add(resword.getString("subject_status"));
        columnArray.add(resword.getString("gender"));
        for (int i = 0; i < studyGroupClasses.size(); ++i) {
            StudyGroupClassBean sgc = (StudyGroupClassBean)studyGroupClasses.get(i);
            columnArray.add(sgc.getName());
        }
        columnArray.add(resword.getString("event_status"));
        columnArray.add(resword.getString("event_date"));
        HideCRFManager hideCRFMgr = HideCRFManager.createHideCRFManager();
        hideCRFMgr.hideSpecifiedEventCRFDefBeans((List)eventDefinitionCRFs);
        for (int i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            if (this.currentStudy.getParentStudyId() <= 0) {
                columnArray.add(edc.getCrf().getName());
                continue;
            }
            if (edc.isHideCrf()) continue;
            columnArray.add(edc.getCrf().getName());
        }
        columnArray.add(resword.getString("actions"));
        String[] columns = new String[columnArray.size()];
        columnArray.toArray(columns);
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.setQuery("ListEventsForSubject?module=" + module + "&defId=" + definitionId + "&tab=" + tabId, new HashMap());
        table.hideColumnLink(columnArray.size() - 1);
        table.setRows(allStudyRows);
        if (filterKeyword != null && !"".equalsIgnoreCase(filterKeyword)) {
            table.setKeywordFilter(filterKeyword);
        }
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        this.forwardPage(Page.LIST_EVENTS_FOR_SUBJECT);
    }
}

