/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.StudyGroupClassRow;

public class ListSubjectGroupClassServlet
extends SecureController {
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MANAGE_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        StudyDAO stdao = new StudyDAO(this.sm.getDataSource());
        int parentStudyId = this.currentStudy.getParentStudyId();
        ArrayList groups = new ArrayList();
        if (parentStudyId > 0) {
            StudyBean parentStudy = (StudyBean)stdao.findByPK(parentStudyId);
            groups = sgcdao.findAllByStudy(parentStudy);
        } else {
            groups = sgcdao.findAllByStudy(this.currentStudy);
        }
        String isReadOnly = this.request.getParameter("read");
        StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
        for (int i = 0; i < groups.size(); ++i) {
            StudyGroupClassBean group = (StudyGroupClassBean)groups.get(i);
            ArrayList studyGroups = sgdao.findAllByGroupClass(group);
            group.setStudyGroups(studyGroups);
        }
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allGroupRows = StudyGroupClassRow.generateRowsFromBeans((ArrayList)groups);
        boolean isParentStudy = this.currentStudy.getParentStudyId() <= 0;
        this.request.setAttribute("isParentStudy", (Object)isParentStudy);
        String[] columns = new String[]{resword.getString("subject_group_class"), resword.getString("type"), resword.getString("subject_assignment"), resword.getString("study_name"), resword.getString("subject_groups"), resword.getString("status"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(4);
        table.hideColumnLink(6);
        table.setQuery("ListSubjectGroupClass", new HashMap());
        table.setRows(allGroupRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        if (this.request.getParameter("read") != null && this.request.getParameter("read").equals("true")) {
            this.request.setAttribute("readOnly", (Object)true);
        }
        this.forwardPage(Page.SUBJECT_GROUP_CLASS_LIST);
    }
}

