/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ManageStudyServlet
extends SecureController {
    Locale locale;
    public final List<String> INSTRUCTIONS = new ArrayList();

    protected void processRequest() throws Exception {
        String proto;
        if (!this.INSTRUCTIONS.isEmpty()) {
            this.INSTRUCTIONS.clear();
        }
        this.INSTRUCTIONS.add(restext.getString("director_coordinator_privileges_manage"));
        this.INSTRUCTIONS.add(restext.getString("side_tables_shows_last_modified"));
        this.request.setAttribute("instructions", (Object)this.INSTRUCTIONS);
        this.request.setAttribute("showIcons", (Object)true);
        this.request.setAttribute("openIcons", (Object)true);
        this.request.setAttribute("openAlerts", (Object)true);
        this.request.setAttribute("openInstructions", (Object)true);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList allSites = (ArrayList)sdao.findAllByParent(this.currentStudy.getId());
        ArrayList sites = new ArrayList();
        for (int i = 0; i < allSites.size(); ++i) {
            sites.add(allSites.get(i));
            if (i == 5) break;
        }
        this.request.setAttribute("sites", sites);
        this.request.setAttribute("sitesCount", (Object)new Integer(sites.size()));
        this.request.setAttribute("allSitesCount", (Object)new Integer(allSites.size()));
        if (this.currentStudy != null) {
            this.request.setAttribute("studyIdentifier", (Object)this.currentStudy.getIdentifier());
        }
        StudyEventDefinitionDAO edao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        ArrayList seds = (ArrayList)edao.findAllByStudyAndLimit(this.currentStudy.getId());
        ArrayList allSeds = edao.findAllByStudy(this.currentStudy);
        this.request.setAttribute("seds", (Object)seds);
        this.request.setAttribute("sedsCount", (Object)new Integer(seds.size()));
        this.request.setAttribute("allSedsCount", (Object)new Integer(allSeds.size()));
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        ArrayList users = udao.findAllUsersByStudyIdAndLimit(this.currentStudy.getId(), true);
        ArrayList allUsers = udao.findAllUsersByStudy(this.currentStudy.getId());
        this.request.setAttribute("users", (Object)users);
        this.request.setAttribute("usersCount", (Object)new Integer(users.size()));
        this.request.setAttribute("allUsersCount", (Object)new Integer(allUsers.size()));
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        ArrayList allSubjects = ssdao.findAllByStudyId(this.currentStudy.getId());
        ArrayList subjects = new ArrayList();
        for (int i = 0; i < allSubjects.size(); ++i) {
            subjects.add(allSubjects.get(i));
            if (i == 5) break;
        }
        this.request.setAttribute("subs", subjects);
        this.request.setAttribute("subsCount", (Object)new Integer(subjects.size()));
        this.request.setAttribute("allSubsCount", (Object)new Integer(allSubjects.size()));
        this.resetPanel();
        if (allSubjects.size() > 0) {
            this.setToPanel("Subjects", new Integer(allSubjects.size()).toString());
        }
        if (allUsers.size() > 0) {
            this.setToPanel("Users", new Integer(allUsers.size()).toString());
        }
        if (allSites.size() > 0) {
            this.setToPanel("Sites", new Integer(allSites.size()).toString());
        }
        if (allSeds.size() > 0) {
            this.setToPanel("Event Definitions", new Integer(allSeds.size()).toString());
        }
        if ((proto = this.request.getParameter("proto")) == null || "".equalsIgnoreCase(proto)) {
            this.forwardPage(Page.MANAGE_STUDY);
        } else {
            this.forwardPage(Page.MANAGE_STUDY_BODY);
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, restext.getString("not_study_director"), "1");
    }
}

