/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.view.display.DisplaySectionBeanHandler;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class PrintDataEntryServlet
extends DataEntryServlet {
    Locale locale;

    public void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        if (ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)ub, (StudyUserRoleBean)currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"), request);
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        EventCRFBean ecb;
        FormProcessor fp = new FormProcessor(request);
        boolean isSubmitted = false;
        int eventCRFId = fp.getInt("ecId");
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        ArrayList<SectionBean> allSectionBeans = new ArrayList<SectionBean>();
        ArrayList sectionBeans = new ArrayList();
        String age = "";
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        SectionBean sb = (SectionBean)request.getAttribute("section_bean");
        String isIE = fp.getString("ie");
        if ("y".equalsIgnoreCase(isIE)) {
            request.setAttribute("isInternetExplorer", (Object)"true");
        }
        if (eventCRFId == 0) {
            ecb = new EventCRFBean();
        } else {
            StudyDAO studydao;
            StudyBean study;
            EventCRFDAO ecdao = new EventCRFDAO(this.getDataSource());
            ecb = (EventCRFBean)ecdao.findByPK(eventCRFId);
            ArrayList sects = sdao.findAllByCRFVersionId(ecb.getCRFVersionId());
            for (int i = 0; i < sects.size(); ++i) {
                sb = (SectionBean)sects.get(i);
                int sectId = sb.getId();
                if (sectId <= 0) continue;
                allSectionBeans.add((SectionBean)sdao.findByPK(sectId));
            }
            StudySubjectDAO ssdao = new StudySubjectDAO(this.getDataSource());
            StudySubjectBean sub = (StudySubjectBean)ssdao.findByPK(ecb.getStudySubjectId());
            SubjectDAO subjectDao = new SubjectDAO(this.getDataSource());
            int subjectId = sub.getSubjectId();
            int studyId = sub.getStudyId();
            SubjectBean subject = (SubjectBean)subjectDao.findByPK(subjectId);
            StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
            StudyEventBean se = (StudyEventBean)sedao.findByPK(ecb.getStudyEventId());
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.getDataSource());
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
            se.setStudyEventDefinition(sed);
            if (currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
                age = Utils.getInstacne().processAge(sub.getEnrollmentDate(), subject.getDateOfBirth());
            }
            if ((study = (StudyBean)(studydao = new StudyDAO(this.getDataSource())).findByPK(studyId)).getParentStudyId() > 0) {
                StudyBean parentStudy = (StudyBean)studydao.findByPK(study.getParentStudyId());
                request.setAttribute("studyTitle", (Object)(parentStudy.getName() + " - " + study.getName()));
            } else {
                request.setAttribute("studyTitle", (Object)study.getName());
            }
            request.setAttribute("studySubject", (Object)sub);
            request.setAttribute("subject", (Object)subject);
            request.setAttribute("studyEvent", (Object)se);
            request.setAttribute("age", (Object)age);
            request.setAttribute("event", (Object)ecb);
            request.setAttribute("section_bean", (Object)sb);
            request.setAttribute("all_section_bean", allSectionBeans);
            sectionBeans = super.getAllDisplayBeans(request);
        }
        ItemGroupDAO itemGroupDao = new ItemGroupDAO(this.getDataSource());
        int crfVersionId = ecb.getCRFVersionId();
        List itemGroupBeans = itemGroupDao.findOnlyGroupsByCRFVersionID(crfVersionId);
        boolean sectionsHaveGroups = false;
        if (itemGroupBeans.size() > 0) {
            sectionsHaveGroups = true;
            DisplaySectionBeanHandler handler = new DisplaySectionBeanHandler(true, this.getDataSource(), this.getServletContext());
            handler.setCrfVersionId(crfVersionId);
            handler.setEventCRFId(eventCRFId);
            List displaySectionBeans = handler.getDisplaySectionBeans();
            CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.getDataSource());
            CRFDAO crfDao = new CRFDAO(this.getDataSource());
            request.setAttribute("listOfDisplaySectionBeans", (Object)displaySectionBeans);
            CRFVersionBean crfverBean = (CRFVersionBean)crfVersionDAO.findByPK(crfVersionId);
            request.setAttribute("crfVersionBean", (Object)crfverBean);
            CRFBean crfBean = crfDao.findByVersionId(crfVersionId);
            request.setAttribute("crfBean", (Object)crfBean);
            request.setAttribute("dataInvolved", (Object)"true");
        }
        request.setAttribute("annotations", (Object)ecb.getAnnotations());
        request.setAttribute("EventCRFBean", (Object)ecb);
        if (!sectionsHaveGroups) {
            request.setAttribute("event", (Object)ecb);
            request.setAttribute("section_bean", (Object)sb);
            DisplaySectionBean dsb = super.getDisplayBean(false, false, request, isSubmitted);
            request.setAttribute("allSections", sectionBeans);
            request.setAttribute("displayAll", (Object)"1");
            request.setAttribute("section", (Object)dsb);
            request.setAttribute("sec", (Object)sb);
            this.forwardPage(Page.VIEW_SECTION_DATA_ENTRY_PRINT, request, response);
        } else {
            this.forwardPage(Page.VIEW_SECTION_DATA_ENTRY_PRINT_GROUPS, request, response);
        }
    }

    protected Status getBlankItemStatus() {
        return Status.AVAILABLE;
    }

    protected Status getNonBlankItemStatus(HttpServletRequest request) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        return edcb.isDoubleEntry() ? Status.PENDING : Status.UNAVAILABLE;
    }

    protected String getEventCRFAnnotations(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        return ecb.getAnnotations();
    }

    protected void setEventCRFAnnotations(String annotations, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        ecb.setAnnotations(annotations);
    }

    protected Page getJSPPage() {
        return Page.VIEW_SECTION_DATA_ENTRY;
    }

    protected String getServletPage(HttpServletRequest request) {
        return Page.VIEW_SECTION_DATA_ENTRY_SERVLET.getFileName();
    }

    protected boolean validateInputOnFirstRound() {
        return true;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ItemBean ib = dib.getItem();
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        dib = this.loadFormValue(dib, request);
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            dib = this.validateDisplayItemBeanSingleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
            dib = this.validateDisplayItemBeanMultipleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, HttpServletRequest request, HttpServletResponse response) {
        return formGroups;
    }

    protected boolean shouldLoadDBValues(DisplayItemBean dib) {
        return true;
    }

    protected boolean shouldRunRules() {
        return false;
    }

    protected boolean isAdministrativeEditing() {
        return false;
    }

    protected boolean isAdminForcedReasonForChange(HttpServletRequest request) {
        return false;
    }
}

