/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RemoveCRFFromDefinitionServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_permission_to_update_study_event_definition") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        ArrayList edcs = (ArrayList)this.session.getAttribute("eventDefinitionCRFs");
        ArrayList<EventDefinitionCRFBean> updatedEdcs = new ArrayList<EventDefinitionCRFBean>();
        String crfName = "";
        StudyEventDefinitionBean sed = (StudyEventDefinitionBean)this.session.getAttribute("definition");
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
        this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
        if (edcs != null && edcs.size() > 1) {
            String idString = this.request.getParameter("id");
            this.logger.info("crf id:" + idString);
            if (StringUtil.isBlank((String)idString)) {
                this.addPageMessage(respage.getString("please_choose_a_crf_to_remove"));
                this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
            } else {
                int id = Integer.valueOf(idString.trim());
                for (int i = 0; i < edcs.size(); ++i) {
                    EventDefinitionCRFBean edc = (EventDefinitionCRFBean)edcs.get(i);
                    if (edc.getCrfId() == id) {
                        edc.setStatus(Status.DELETED);
                        crfName = edc.getCrfName();
                    }
                    if (edc.getId() <= 0 && edc.getStatus().equals((Term)Status.DELETED)) continue;
                    updatedEdcs.add(edc);
                    this.logger.info("\nversion:" + edc.getDefaultVersionId());
                }
                this.session.setAttribute("eventDefinitionCRFs", updatedEdcs);
                this.addPageMessage(respage.getString("has_been_removed_need_confirmation"));
                this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
            }
        } else {
            this.addPageMessage(respage.getString("an_ED_needs_to_have_least_one_CRF"));
            this.forwardPage(Page.UPDATE_EVENT_DEFINITION1);
        }
    }
}

