/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.AuditEventBean;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.admin.StudyEventAuditBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DisplayEventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.AuditEventDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.AuditableEntityDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.DisplayStudyEventRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignStudySubjectServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"));
        this.mayAccess();
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public static ArrayList getDisplayStudyEventsForStudySubject(StudyBean study, StudySubjectBean studySub, DataSource ds, UserAccountBean ub, StudyUserRoleBean currentRole) {
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(ds);
        StudyEventDAO sedao = new StudyEventDAO(ds);
        EventCRFDAO ecdao = new EventCRFDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        StudySubjectDAO ssdao = new StudySubjectDAO(ds);
        ArrayList events = sedao.findAllByStudySubject(studySub);
        ArrayList<DisplayStudyEventBean> displayEvents = new ArrayList<DisplayStudyEventBean>();
        for (int i = 0; i < events.size(); ++i) {
            StudyEventBean event = (StudyEventBean)events.get(i);
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(event.getStudyEventDefinitionId());
            event.setStudyEventDefinition(sed);
            ArrayList eventDefinitionCRFs = (ArrayList)edcdao.findAllActiveByEventDefinitionId(study, sed.getId());
            ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
            DisplayStudyEventBean de = new DisplayStudyEventBean();
            de.setStudyEvent(event);
            de.setDisplayEventCRFs(SignStudySubjectServlet.getDisplayEventCRFs((StudyBean)study, (DataSource)ds, (ArrayList)eventCRFs, (UserAccountBean)ub, (StudyUserRoleBean)currentRole, (SubjectEventStatus)event.getSubjectEventStatus()));
            ArrayList al = SignStudySubjectServlet.getUncompletedCRFs((DataSource)ds, (ArrayList)eventDefinitionCRFs, (ArrayList)eventCRFs, (SubjectEventStatus)event.getSubjectEventStatus());
            SignStudySubjectServlet.populateUncompletedCRFsWithCRFAndVersions((DataSource)ds, (ArrayList)al);
            de.setUncompletedCRFs(al);
            StudySubjectBean studySubject = (StudySubjectBean)ssdao.findByPK(event.getStudySubjectId());
            de.setMaximumSampleOrdinal(sedao.getMaxSampleOrdinal(sed, studySubject));
            displayEvents.add(de);
        }
        return displayEvents;
    }

    public static boolean permitSign(StudySubjectBean studySub, DataSource ds) {
        boolean sign = true;
        StudyEventDAO sedao = new StudyEventDAO(ds);
        EventCRFDAO ecdao = new EventCRFDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        StudyDAO sdao = new StudyDAO(ds);
        StudyBean studyBean = (StudyBean)sdao.findByPK(studySub.getStudyId());
        ArrayList studyEvents = sedao.findAllByStudySubject(studySub);
        block0: for (int l = 0; l < studyEvents.size(); ++l) {
            StudyEventBean studyEvent = (StudyEventBean)studyEvents.get(l);
            ArrayList eventCrfs = ecdao.findAllByStudyEvent(studyEvent);
            for (int i = 0; i < eventCrfs.size(); ++i) {
                EventCRFBean ecrf = (EventCRFBean)eventCrfs.get(i);
                EventDefinitionCRFBean edcBean = edcdao.findByStudyEventIdAndCRFVersionId(studyBean, studyEvent.getId(), ecrf.getCRFVersionId());
                if (!ecrf.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && (!ecrf.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || !edcBean.isDoubleEntry())) continue;
                sign = false;
                continue block0;
            }
        }
        return sign;
    }

    public static boolean signSubjectEvents(StudySubjectBean studySub, DataSource ds, UserAccountBean ub) {
        boolean updated = true;
        StudyEventDAO sedao = new StudyEventDAO(ds);
        EventCRFDAO ecdao = new EventCRFDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        DiscrepancyNoteDAO discDao = new DiscrepancyNoteDAO(ds);
        ArrayList studyEvents = sedao.findAllByStudySubject(studySub);
        for (int l = 0; l < studyEvents.size(); ++l) {
            try {
                StudyEventBean studyEvent = (StudyEventBean)studyEvents.get(l);
                studyEvent.setUpdater(ub);
                studyEvent.setUpdatedDate(new Date());
                studyEvent.setSubjectEventStatus(SubjectEventStatus.SIGNED);
                sedao.update((EntityBean)studyEvent);
                continue;
            }
            catch (Exception ex) {
                updated = false;
            }
        }
        return updated;
    }

    public void processRequest() throws Exception {
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        String action = fp.getString("action");
        int studySubId = fp.getInt("id", true);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        if (studySubId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_to_view"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
            return;
        }
        StudySubjectBean studySub = (StudySubjectBean)subdao.findByPK(studySubId);
        if (!SignStudySubjectServlet.permitSign((StudySubjectBean)studySub, (DataSource)this.sm.getDataSource())) {
            this.addPageMessage(respage.getString("subject_event_cannot_signed"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
            return;
        }
        if (action.equalsIgnoreCase("confirm")) {
            String username = this.request.getParameter("j_user");
            String password = this.request.getParameter("j_pass");
            SecurityManager securityManager = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
            UserAccountBean ub = (UserAccountBean)this.session.getAttribute("userBean");
            if (securityManager.verifyPassword(password, this.getUserDetails()) && ub.getName().equals(username)) {
                if (SignStudySubjectServlet.signSubjectEvents((StudySubjectBean)studySub, (DataSource)this.sm.getDataSource(), (UserAccountBean)ub)) {
                    studySub.setStatus(Status.SIGNED);
                    studySub.setUpdater(ub);
                    subdao.update((EntityBean)studySub);
                    this.addPageMessage(respage.getString("subject_event_signed"));
                    this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
                    return;
                }
                this.addPageMessage(respage.getString("errors_in_submission_see_below"));
                this.forwardPage(Page.LIST_STUDY_SUBJECTS);
                return;
            }
            this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
            this.addPageMessage(restext.getString("password_match"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
            return;
        }
        this.request.setAttribute("studySub", (Object)studySub);
        int studyId = studySub.getStudyId();
        int subjectId = studySub.getSubjectId();
        SubjectBean subject = (SubjectBean)sdao.findByPK(subjectId);
        if (this.currentStudy.getStudyParameterConfig().getCollectDob().equals("2")) {
            Date dob = subject.getDateOfBirth();
            if (dob != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(dob);
                int year = cal.get(1);
                this.request.setAttribute("yearOfBirth", (Object)new Integer(year));
            } else {
                this.request.setAttribute("yearOfBirth", (Object)"");
            }
        }
        this.request.setAttribute("subject", (Object)subject);
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = (StudyBean)studydao.findByPK(studyId);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        study.getStudyParameterConfig().setCollectDob(spvdao.findByHandleAndStudy(studyId, "collectDob").getValue());
        if (study.getParentStudyId() > 0) {
            StudyBean parentStudy = (StudyBean)studydao.findByPK(study.getParentStudyId());
            this.request.setAttribute("parentStudy", (Object)parentStudy);
        } else {
            this.request.setAttribute("parentStudy", (Object)new StudyBean());
        }
        ArrayList children = (ArrayList)sdao.findAllChildrenByPK(subjectId);
        this.request.setAttribute("children", (Object)children);
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ArrayList displayEvents = SignStudySubjectServlet.getDisplayStudyEventsForStudySubject((StudyBean)study, (StudySubjectBean)studySub, (DataSource)this.sm.getDataSource(), (UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole);
        DiscrepancyNoteUtil discNoteUtil = new DiscrepancyNoteUtil();
        discNoteUtil.injectParentDiscNotesIntoDisplayStudyEvents((List)displayEvents, new HashSet(), this.sm.getDataSource(), 0);
        this.request.setAttribute("displayStudyEvents", (Object)displayEvents);
        Map discNoteByEventCRFid = discNoteUtil.createDiscNoteMapByEventCRF((List)displayEvents);
        this.request.setAttribute("discNoteByEventCRFid", (Object)discNoteByEventCRFid);
        EntityBeanTable table = fp.getEntityBeanTable();
        table.setSortingIfNotExplicitlySet(1, false);
        ArrayList allEventRows = DisplayStudyEventRow.generateRowsFromBeans((List)displayEvents);
        String[] columns = new String[]{resword.getString("event") + " (" + resword.getString("occurrence_number") + ")", resword.getString("start_date1"), resword.getString("location"), resword.getString("status"), resword.getString("actions"), resword.getString("CRFs_atrib")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(4);
        table.hideColumnLink(5);
        if (!"removed".equalsIgnoreCase(studySub.getStatus().getName()) && !"auto-removed".equalsIgnoreCase(studySub.getStatus().getName())) {
            table.addLink(resword.getString("add_new_event"), "CreateNewStudyEvent?studySubjectId=" + studySub.getId());
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("id", new Integer(studySubId).toString());
        table.setQuery("ViewStudySubject", args);
        table.setRows(allEventRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
        ArrayList groupMaps = (ArrayList)sgmdao.findAllByStudySubject(studySubId);
        this.request.setAttribute("groups", (Object)groupMaps);
        AuditEventDAO aedao = new AuditEventDAO(this.sm.getDataSource());
        ArrayList logs = aedao.findEventStatusLogByStudySubject(studySubId);
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        ArrayList<StudyEventAuditBean> eventLogs = new ArrayList<StudyEventAuditBean>();
        for (int i = 0; i < logs.size(); ++i) {
            AuditEventBean avb = (AuditEventBean)logs.get(i);
            StudyEventAuditBean sea = new StudyEventAuditBean();
            sea.setAuditEvent(avb);
            StudyEventBean se = (StudyEventBean)sedao.findByPK(avb.getEntityId());
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
            sea.setDefinition(sed);
            String old = avb.getOldValue().trim();
            try {
                String newValue;
                if (!StringUtil.isBlank((String)old)) {
                    SubjectEventStatus oldStatus = SubjectEventStatus.get((int)new Integer(old));
                    sea.setOldSubjectEventStatus(oldStatus);
                }
                if (!StringUtil.isBlank((String)(newValue = avb.getNewValue().trim()))) {
                    SubjectEventStatus newStatus = SubjectEventStatus.get((int)new Integer(newValue));
                    sea.setNewSubjectEventStatus(newStatus);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            UserAccountBean updater = (UserAccountBean)udao.findByPK(avb.getUserId());
            sea.setUpdater(updater);
            eventLogs.add(sea);
        }
        this.request.setAttribute("eventLogs", eventLogs);
        this.forwardPage(Page.SIGN_STUDY_SUBJECT);
    }

    public static ArrayList getDisplayEventCRFs(StudyBean study, DataSource ds, ArrayList eventCRFs, UserAccountBean ub, StudyUserRoleBean currentRole, SubjectEventStatus status) {
        ArrayList<DisplayEventCRFBean> answer = new ArrayList<DisplayEventCRFBean>();
        StudyEventDAO sedao = new StudyEventDAO(ds);
        CRFDAO cdao = new CRFDAO(ds);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        ItemDataDAO iddao = new ItemDataDAO(ds);
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(ds);
        for (int i = 0; i < eventCRFs.size(); ++i) {
            EventCRFBean ecb = (EventCRFBean)eventCRFs.get(i);
            int crfVersionId = ecb.getCRFVersionId();
            CRFBean cb = cdao.findByVersionId(crfVersionId);
            ecb.setCrf(cb);
            CRFVersionBean cvb = (CRFVersionBean)cvdao.findByPK(crfVersionId);
            ecb.setCrfVersion(cvb);
            int studyEventId = ecb.getStudyEventId();
            int studyEventDefinitionId = sedao.getDefinitionIdFromStudyEventId(studyEventId);
            EventDefinitionCRFBean edc = edcdao.findByStudyEventDefinitionIdAndCRFId(study, studyEventDefinitionId, cb.getId());
            if (status.equals((Term)SubjectEventStatus.LOCKED) || status.equals((Term)SubjectEventStatus.SKIPPED) || status.equals((Term)SubjectEventStatus.STOPPED)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (status.equals((Term)SubjectEventStatus.INVALID)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (!cb.getStatus().equals((Term)Status.AVAILABLE)) {
                ecb.setStage(DataEntryStage.LOCKED);
            } else if (!cvb.getStatus().equals((Term)Status.AVAILABLE)) {
                ecb.setStage(DataEntryStage.LOCKED);
            }
            if (edc == null) continue;
            DisplayEventCRFBean dec = new DisplayEventCRFBean();
            dec.setFlags(ecb, ub, currentRole, edc.isDoubleEntry());
            ArrayList idata = iddao.findAllByEventCRFId(ecb.getId());
            if (idata.isEmpty()) continue;
            answer.add(dec);
        }
        return answer;
    }

    public static ArrayList getUncompletedCRFs(DataSource ds, ArrayList eventDefinitionCRFs, ArrayList eventCRFs, SubjectEventStatus status) {
        int i;
        HashMap<Integer, Boolean> completed = new HashMap<Integer, Boolean>();
        HashMap<Integer, EventCRFBean> startedButIncompleted = new HashMap<Integer, EventCRFBean>();
        ArrayList<DisplayEventDefinitionCRFBean> answer = new ArrayList<DisplayEventDefinitionCRFBean>();
        for (i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edcrf = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            completed.put(new Integer(edcrf.getCrfId()), Boolean.FALSE);
            startedButIncompleted.put(new Integer(edcrf.getCrfId()), new EventCRFBean());
        }
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        ItemDataDAO iddao = new ItemDataDAO(ds);
        for (i = 0; i < eventCRFs.size(); ++i) {
            EventCRFBean ecrf = (EventCRFBean)eventCRFs.get(i);
            int crfId = cvdao.getCRFIdFromCRFVersionId(ecrf.getCRFVersionId());
            ArrayList idata = iddao.findAllByEventCRFId(ecrf.getId());
            if (!idata.isEmpty()) {
                completed.put(new Integer(crfId), Boolean.TRUE);
                continue;
            }
            startedButIncompleted.put(new Integer(crfId), ecrf);
        }
        for (i = 0; i < eventDefinitionCRFs.size(); ++i) {
            DisplayEventDefinitionCRFBean dedc = new DisplayEventDefinitionCRFBean();
            EventDefinitionCRFBean edcrf = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            dedc.setEdc(edcrf);
            if (status.equals((Term)SubjectEventStatus.LOCKED)) {
                dedc.setStatus(Status.LOCKED);
            }
            Boolean b = (Boolean)completed.get(new Integer(edcrf.getCrfId()));
            EventCRFBean ev = (EventCRFBean)startedButIncompleted.get(new Integer(edcrf.getCrfId()));
            if (b != null && b.booleanValue()) continue;
            dedc.setEventCRF(ev);
            answer.add(dedc);
        }
        return answer;
    }

    public static void populateUncompletedCRFsWithCRFAndVersions(DataSource ds, ArrayList uncompletedEventDefinitionCRFs) {
        CRFDAO cdao = new CRFDAO(ds);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        int size = uncompletedEventDefinitionCRFs.size();
        for (int i = 0; i < size; ++i) {
            DisplayEventDefinitionCRFBean dedcrf = (DisplayEventDefinitionCRFBean)uncompletedEventDefinitionCRFs.get(i);
            CRFBean cb = (CRFBean)cdao.findByPK(dedcrf.getEdc().getCrfId());
            dedcrf.getEdc().setCrf(cb);
            ArrayList versions = (ArrayList)cvdao.findAllActiveByCRF(dedcrf.getEdc().getCrfId());
            dedcrf.getEdc().setVersions(versions);
            uncompletedEventDefinitionCRFs.set(i, dedcrf);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public void mayAccess() throws InsufficientPermissionException {
        FormProcessor fp = new FormProcessor(this.request);
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        int studySubId = fp.getInt("id", true);
        if (studySubId > 0 && !this.entityIncluded(studySubId, this.ub.getName(), (AuditableEntityDAO)subdao, this.sm.getDataSource())) {
            this.addPageMessage(respage.getString("required_study_subject_not_belong"));
            throw new InsufficientPermissionException(Page.MENU, resexception.getString("entity_not_belong_studies"), "1");
        }
    }
}

