/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ViewEventDefinitionServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;

public class ViewEventDefinitionReadOnlyServlet
extends ViewEventDefinitionServlet {
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;
    public static String EVENT_ID = "id";
    public static String EVENT_OID = "Oid";

    public void processRequest() throws Exception {
        StudyEventDefinitionDAO sdao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int defId = fp.getInt(EVENT_ID, true);
        String eventOid = fp.getString(EVENT_OID);
        if (defId == 0 && eventOid == null) {
            this.addPageMessage(respage.getString("please_choose_a_definition_to_view"));
            this.forwardPage(Page.LIST_DEFINITION_SERVLET);
            return;
        }
        StudyEventDefinitionBean sed = defId > 0 ? (StudyEventDefinitionBean)sdao.findByPK(defId) : sdao.findByOid(eventOid);
        EventDefinitionCRFDAO edao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList eventDefinitionCRFs = (ArrayList)edao.findAllByDefinition(this.currentStudy, sed.getId());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        for (int i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
            ArrayList versions = (ArrayList)cvdao.findAllByCRF(edc.getCrfId());
            edc.setVersions(versions);
            CRFBean crf = (CRFBean)cdao.findByPK(edc.getCrfId());
            edc.setCrfName(crf.getName());
            if (crf.getStatus().equals((Term)Status.AVAILABLE)) {
                edc.setOwner(crf.getOwner());
            }
            CRFBean cBean = (CRFBean)cdao.findByPK(edc.getCrfId());
            String crfPath = sed.getOid() + "." + cBean.getOid();
            edc.setOffline(this.getEventDefinitionCrfTagService().getEventDefnCrfOfflineStatus(2, crfPath, true));
            CRFVersionBean defaultVersion = (CRFVersionBean)cvdao.findByPK(edc.getDefaultVersionId());
            edc.setDefaultVersionName(defaultVersion.getName());
        }
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
        this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
        this.request.setAttribute("definition", (Object)sed);
        this.request.setAttribute("eventDefinitionCRFs", (Object)eventDefinitionCRFs);
        this.request.setAttribute("defSize", (Object)new Integer(eventDefinitionCRFs.size()));
        if (defId > 0) {
            this.forwardPage(Page.VIEW_EVENT_DEFINITION_READONLY);
        } else {
            this.forwardPage(Page.VIEW_EVENT_DEFINITION_NOSIDEBAR);
        }
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

