/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplayItemWithGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.DisplayTableOfContentsBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ViewTableOfContentServlet;
import org.akaza.openclinica.control.submit.AddNewSubjectServlet;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.control.submit.TableOfContentsServlet;
import org.akaza.openclinica.control.submit.VariableSubstitutionHelper;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.DiscrepancyNoteThread;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSectionDataEntryServlet
extends DataEntryServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewSectionDataEntryServlet.class);
    Locale locale;
    public static String EVENT_CRF_ID = "ecId";
    public static String ENCLOSING_PAGE = "enclosingPage";

    public void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
        this.mayAccess(request);
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        if (ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)ub, (StudyUserRoleBean)currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"), request);
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }

    public Map getErrors() {
        return this.errors;
    }

    public void initializeMembers(Locale locale) {
        resadmin = ResourceBundleProvider.getAdminBundle((Locale)locale);
        resaudit = ResourceBundleProvider.getAuditEventsBundle((Locale)locale);
        resexception = ResourceBundleProvider.getExceptionsBundle((Locale)locale);
        resformat = ResourceBundleProvider.getFormatBundle((Locale)locale);
        restext = ResourceBundleProvider.getTextsBundle((Locale)locale);
        resterm = ResourceBundleProvider.getTermsBundle((Locale)locale);
        resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        respage = ResourceBundleProvider.getPageMessagesBundle((Locale)locale);
        resworkflow = ResourceBundleProvider.getWorkflowBundle((Locale)locale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StudySubjectBean sub;
        StudySubjectDAO ssdao;
        String age;
        SectionDAO sdao;
        EventCRFDAO ecdao;
        String printVersion;
        int eventDefinitionCRFId;
        HttpSession session;
        String action;
        int studySubjectId;
        int eventCRFId;
        int sectionId;
        EventDefinitionCRFBean edcb;
        boolean isSubmitted;
        SectionBean sb;
        EventCRFBean ecb;
        StudyBean currentStudy;
        FormProcessor fp;
        block48: {
            String formattedInterviewerDate;
            Iterator iterator;
            int notAppNum;
            int resolvedNum;
            int closedNum;
            int openNum;
            int updatedNum;
            block47: {
                int crfVersionId;
                block46: {
                    CRFVersionDAO crfVDao;
                    CRFVersionBean crvVBean;
                    fp = new FormProcessor(request);
                    currentStudy = (StudyBean)request.getSession().getAttribute("study");
                    ecb = (EventCRFBean)request.getAttribute("event");
                    sb = (SectionBean)request.getAttribute("section_bean");
                    isSubmitted = false;
                    edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
                    if (!fp.getString("exitTo").equals("")) {
                        request.setAttribute("exitTo", (Object)fp.getString("exitTo"));
                    }
                    crfVersionId = fp.getInt("crfVersionId", true);
                    sectionId = fp.getInt("sectionId");
                    eventCRFId = fp.getInt(EVENT_CRF_ID, true);
                    studySubjectId = fp.getInt("studySubjectId", true);
                    action = fp.getString("action");
                    session = request.getSession();
                    String fromResolvingNotes = fp.getString("fromResolvingNotes", true);
                    if (StringUtil.isBlank((String)fromResolvingNotes)) {
                        session.removeAttribute("window_location");
                        session.removeAttribute("notesTable");
                    }
                    request.setAttribute("studySubjectId", (Object)(studySubjectId + ""));
                    request.setAttribute("crfListPage", (Object)fp.getString("crfListPage"));
                    request.setAttribute("eventId", (Object)fp.getString("eventId"));
                    int sedId = fp.getInt("sedId");
                    request.setAttribute("sedId", (Object)(sedId + ""));
                    int crfId = fp.getInt("crfId");
                    if (crfId == 0 && crfVersionId > 0 && (crvVBean = (CRFVersionBean)(crfVDao = new CRFVersionDAO(this.getDataSource())).findByPK(crfVersionId)) != null) {
                        crfId = crvVBean.getCrfId();
                    }
                    eventDefinitionCRFId = fp.getInt("eventDefinitionCRFId");
                    EventDefinitionCRFDAO eventCrfDao = new EventDefinitionCRFDAO(this.getDataSource());
                    edcb = (EventDefinitionCRFBean)eventCrfDao.findByPK(eventDefinitionCRFId);
                    if (eventCRFId == 0 && edcb.getStudyId() != currentStudy.getParentStudyId() && edcb.getStudyId() != currentStudy.getId()) {
                        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"), request);
                        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
                    }
                    if (crfId == 0 && eventDefinitionCRFId > 0 && edcb != null) {
                        crfId = edcb.getCrfId();
                    }
                    request.setAttribute("crfId", (Object)(crfId + ""));
                    request.setAttribute("eventDefinitionCRFId", (Object)(eventDefinitionCRFId + ""));
                    printVersion = fp.getString("print");
                    session.removeAttribute("presetValues");
                    ecdao = new EventCRFDAO(this.getDataSource());
                    sdao = new SectionDAO(this.getDataSource());
                    age = "";
                    if (sectionId == 0 && crfVersionId == 0 && eventCRFId == 0) {
                        this.addPageMessage(respage.getString("please_choose_a_CRF_to_view"), request);
                        this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET, request, response);
                        return;
                    }
                    if (studySubjectId > 0) {
                        ssdao = new StudySubjectDAO(this.getDataSource());
                        sub = (StudySubjectBean)ssdao.findByPK(studySubjectId);
                        request.setAttribute("studySubject", (Object)sub);
                    }
                    if (eventCRFId <= 0) break block46;
                    ecb = (EventCRFBean)ecdao.findByPK(eventCRFId);
                    StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
                    StudyEventBean event = (StudyEventBean)sedao.findByPK(ecb.getStudyEventId());
                    if (event.getSubjectEventStatus().equals((Term)SubjectEventStatus.LOCKED)) {
                        request.setAttribute("isLocked", (Object)"yes");
                    } else {
                        request.setAttribute("isLocked", (Object)"no");
                    }
                    if (studySubjectId <= 0) {
                        studySubjectId = event.getStudySubjectId();
                        request.setAttribute("studySubjectId", (Object)(studySubjectId + ""));
                    }
                    DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.getDataSource());
                    ArrayList allNotes = new ArrayList();
                    ArrayList eventCrfNotes = new ArrayList();
                    List noteThreads = new ArrayList();
                    allNotes = dndao.findAllTopNotesByEventCRF(eventCRFId);
                    eventCrfNotes = dndao.findOnlyParentEventCRFDNotesFromEventCRF(ecb);
                    if (!eventCrfNotes.isEmpty()) {
                        allNotes.addAll(eventCrfNotes);
                        this.setAttributeForInterviewerDNotes((List)eventCrfNotes, request);
                    }
                    DiscrepancyNoteUtil dNoteUtil = new DiscrepancyNoteUtil();
                    noteThreads = dNoteUtil.createThreadsOfParents((List)allNotes, this.getDataSource(), currentStudy, null, -1, true);
                    updatedNum = 0;
                    openNum = 0;
                    closedNum = 0;
                    resolvedNum = 0;
                    notAppNum = 0;
                    iterator = noteThreads.iterator();
                    break block47;
                }
                if (crfVersionId <= 0) break block48;
                DisplayTableOfContentsBean displayBean = ViewTableOfContentServlet.getDisplayBean((DataSource)this.getDataSource(), (int)crfVersionId);
                request.setAttribute("toc", (Object)displayBean);
                ArrayList sections = displayBean.getSections();
                request.setAttribute("sectionNum", (Object)(sections.size() + ""));
                if (!sections.isEmpty()) {
                    if (sectionId == 0) {
                        SectionBean firstSec = (SectionBean)sections.get(0);
                        sectionId = firstSec.getId();
                    }
                    break block48;
                } else {
                    this.addPageMessage(respage.getString("there_are_no_sections_ins_this_CRF_version"), request);
                    if (eventCRFId == 0) {
                        this.forwardPage(Page.CRF_LIST_SERVLET, request, response);
                        return;
                    }
                    this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET, request, response);
                    return;
                }
            }
            while (iterator.hasNext()) {
                DiscrepancyNoteThread dnThread = (DiscrepancyNoteThread)iterator.next();
                DiscrepancyNoteBean tempBean = (DiscrepancyNoteBean)dnThread.getLinkedNoteList().getLast();
                if (tempBean == null) continue;
                if (ResolutionStatus.UPDATED.equals((Term)tempBean.getResStatus())) {
                    ++updatedNum;
                    continue;
                }
                if (ResolutionStatus.OPEN.equals((Term)tempBean.getResStatus())) {
                    ++openNum;
                    continue;
                }
                if (ResolutionStatus.CLOSED.equals((Term)tempBean.getResStatus())) {
                    ++closedNum;
                    continue;
                }
                if (ResolutionStatus.RESOLVED.equals((Term)tempBean.getResStatus())) {
                    ++resolvedNum;
                    continue;
                }
                if (!ResolutionStatus.NOT_APPLICABLE.equals((Term)tempBean.getResStatus())) continue;
                ++notAppNum;
            }
            request.setAttribute("updatedNum", (Object)(updatedNum + ""));
            request.setAttribute("openNum", (Object)(openNum + ""));
            request.setAttribute("closedNum", (Object)(closedNum + ""));
            request.setAttribute("resolvedNum", (Object)(resolvedNum + ""));
            request.setAttribute("notAppNum", (Object)(notAppNum + ""));
            DisplayTableOfContentsBean displayBean = TableOfContentsServlet.getDisplayBean((EventCRFBean)ecb, (DataSource)this.getDataSource(), (StudyBean)currentStudy);
            Date tmpDate = displayBean.getEventCRF().getDateInterviewed();
            try {
                SimpleDateFormat local_df = new SimpleDateFormat(resformat.getString("date_format_string"), ResourceBundleProvider.getLocale());
                formattedInterviewerDate = local_df.format(tmpDate);
            }
            catch (Exception e) {
                formattedInterviewerDate = "";
            }
            HashMap<String, String> presetVals = (HashMap<String, String>)session.getAttribute("presetValues");
            if (presetVals == null) {
                presetVals = new HashMap<String, String>();
                session.setAttribute("presetValues", presetVals);
            }
            presetVals.put("interviewDate", formattedInterviewerDate);
            request.setAttribute("toc", (Object)displayBean);
            ArrayList sections = displayBean.getSections();
            request.setAttribute("sectionNum", (Object)(sections.size() + ""));
            if (sections.isEmpty()) {
                this.addPageMessage(respage.getString("there_are_no_sections_ins_this_CRF"), request);
                this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET, request, response);
                return;
            }
            if (sectionId == 0) {
                SectionBean firstSec = (SectionBean)sections.get(0);
                sectionId = firstSec.getId();
            }
        }
        sb = (SectionBean)sdao.findByPK(sectionId);
        if (eventCRFId == 0) {
            ecb = new EventCRFBean();
            ecb.setCRFVersionId(sb.getCRFVersionId());
            if (currentStudy.getParentStudyId() > 0) {
                StudyDAO studydao = new StudyDAO(this.getDataSource());
                StudyBean parentStudy = (StudyBean)studydao.findByPK(currentStudy.getParentStudyId());
                request.setAttribute("studyTitle", (Object)parentStudy.getName());
                request.setAttribute("siteTitle", (Object)currentStudy.getName());
            } else {
                request.setAttribute("studyTitle", (Object)currentStudy.getName());
            }
        } else {
            StudyDAO studydao;
            StudyBean study;
            ecb = (EventCRFBean)ecdao.findByPK(eventCRFId);
            request.setAttribute("event", (Object)ecb);
            request.setAttribute("section_bean", (Object)sb);
            ssdao = new StudySubjectDAO(this.getDataSource());
            sub = (StudySubjectBean)ssdao.findByPK(ecb.getStudySubjectId());
            SubjectDAO subjectDao = new SubjectDAO(this.getDataSource());
            int subjectId = sub.getSubjectId();
            int studyId = sub.getStudyId();
            SubjectBean subject = (SubjectBean)subjectDao.findByPK(subjectId);
            if (currentStudy.getStudyParameterConfig().getCollectDob().equals("1")) {
                StudyEventDAO sedao = new StudyEventDAO(this.getDataSource());
                StudyEventBean se = (StudyEventBean)sedao.findByPK(ecb.getStudyEventId());
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.getDataSource());
                StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seddao.findByPK(se.getStudyEventDefinitionId());
                se.setStudyEventDefinition(sed);
                request.setAttribute("studyEvent", (Object)se);
                age = Utils.getInstacne().processAge(sub.getEnrollmentDate(), subject.getDateOfBirth());
            }
            if ((study = (StudyBean)(studydao = new StudyDAO(this.getDataSource())).findByPK(studyId)).getParentStudyId() > 0) {
                StudyBean parentStudy = (StudyBean)studydao.findByPK(study.getParentStudyId());
                request.setAttribute("studyTitle", (Object)parentStudy.getName());
                request.setAttribute("siteTitle", (Object)study.getName());
            } else {
                request.setAttribute("studyTitle", (Object)study.getName());
            }
            request.setAttribute("studySubject", (Object)sub);
            request.setAttribute("subject", (Object)subject);
            request.setAttribute("age", (Object)age);
        }
        boolean hasItemGroup = false;
        ItemGroupDAO igdao = new ItemGroupDAO(this.getDataSource());
        List itemGroups = igdao.findLegitGroupBySectionId(sectionId);
        if (!itemGroups.isEmpty()) {
            hasItemGroup = true;
        }
        request.setAttribute("event_def_crf_bean", (Object)edcb);
        request.setAttribute("event", (Object)ecb);
        request.setAttribute("section_bean", (Object)sb);
        DisplaySectionBean dsb = super.getDisplayBean(hasItemGroup, false, request, isSubmitted);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.getDataSource());
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.getDataSource());
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.getDataSource());
        StudyEventDefinitionBean studyEventDefinition = (StudyEventDefinitionBean)studyEventDefinitionDAO.findByPK(edcb.getStudyEventDefinitionId());
        StudyEventBean studyEvent = (StudyEventBean)studyEventDAO.findByPK(ecb.getStudyEventId());
        VariableSubstitutionHelper.replaceVariables((DisplaySectionBean)dsb, (StudyBean)currentStudy, (StudySubjectBean)((StudySubjectBean)studySubjectDAO.findByPK(studySubjectId)), (StudyEventDefinitionBean)studyEventDefinition, (StudyEventBean)studyEvent, (DataSource)this.getDataSource());
        FormDiscrepancyNotes discNotes = (FormDiscrepancyNotes)session.getAttribute("fdnotes");
        if (discNotes == null) {
            discNotes = new FormDiscrepancyNotes();
            session.setAttribute("fdnotes", (Object)discNotes);
        }
        List displayItemWithGroups = super.createItemWithGroups(dsb, hasItemGroup, eventDefinitionCRFId, request, isSubmitted);
        dsb.setDisplayItemGroups(displayItemWithGroups);
        super.populateNotesWithDBNoteCounts(discNotes, dsb, request);
        if (fp.getString("fromViewNotes") != null && "1".equals(fp.getString("fromViewNotes"))) {
            request.setAttribute("fromViewNotes", (Object)fp.getString("fromViewNotes"));
        } else {
            session.removeAttribute("viewNotesURL");
        }
        if (!"saveNotes".equalsIgnoreCase(action)) {
            request.setAttribute("section", (Object)dsb);
            request.setAttribute("annotations", (Object)ecb.getAnnotations());
            request.setAttribute("sec", (Object)sb);
            request.setAttribute("EventCRFBean", (Object)ecb);
            int tabNum = 1;
            tabNum = "".equalsIgnoreCase(fp.getString("tabId")) ? 1 : fp.getInt("tabId");
            request.setAttribute("tabId", (Object)new Integer(tabNum).toString());
            request.setAttribute(ENCLOSING_PAGE, (Object)"viewSectionData");
            if ("yes".equalsIgnoreCase(printVersion)) {
                this.forwardPage(Page.VIEW_SECTION_DATA_ENTRY_PRINT, request, response);
                return;
            }
            this.forwardPage(Page.VIEW_SECTION_DATA_ENTRY, request, response);
            return;
        }
        LOGGER.info("33333how many group rows:" + dsb.getDisplayItemGroups().size());
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.getDataSource());
        discNotes = (FormDiscrepancyNotes)session.getAttribute("fdnotes");
        int i = 0;
        while (true) {
            if (i >= dsb.getDisplayItemGroups().size()) {
                this.addPageMessage("Discrepancy notes are saved successfully.", request);
                request.setAttribute("id", (Object)(studySubjectId + ""));
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET, request, response);
                return;
            }
            DisplayItemWithGroupBean diwb = (DisplayItemWithGroupBean)dsb.getDisplayItemGroups().get(i);
            if (!diwb.isInGroup()) {
                DisplayItemBean dib = diwb.getSingleItem();
                String inputName = this.getInputName(dib);
                AddNewSubjectServlet.saveFieldNotes((String)inputName, (FormDiscrepancyNotes)discNotes, (DiscrepancyNoteDAO)dndao, (int)dib.getData().getId(), (String)"itemData", (StudyBean)currentStudy);
                ArrayList childItems = dib.getChildren();
                for (int j = 0; j < childItems.size(); ++j) {
                    DisplayItemBean child = (DisplayItemBean)childItems.get(j);
                    inputName = this.getInputName(child);
                    AddNewSubjectServlet.saveFieldNotes((String)inputName, (FormDiscrepancyNotes)discNotes, (DiscrepancyNoteDAO)dndao, (int)dib.getData().getId(), (String)"itemData", (StudyBean)currentStudy);
                }
            } else {
                List dgbs = diwb.getItemGroups();
                LOGGER.info("dgbs size: " + dgbs.size());
                for (int j = 0; j < dgbs.size(); ++j) {
                    DisplayItemGroupBean displayGroup = (DisplayItemGroupBean)dgbs.get(j);
                    List items = displayGroup.getItems();
                    LOGGER.info("item size: " + items.size());
                    for (DisplayItemBean displayItem : items) {
                        String inputName = this.getGroupItemInputName(displayGroup, j, displayItem);
                        LOGGER.info("inputName:" + inputName);
                        LOGGER.info("item data id:" + displayItem.getData().getId());
                        AddNewSubjectServlet.saveFieldNotes((String)inputName, (FormDiscrepancyNotes)discNotes, (DiscrepancyNoteDAO)dndao, (int)displayItem.getData().getId(), (String)"itemData", (StudyBean)currentStudy);
                    }
                }
            }
            ++i;
        }
    }

    protected Status getBlankItemStatus() {
        return Status.AVAILABLE;
    }

    protected Status getNonBlankItemStatus(HttpServletRequest request) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        return edcb.isDoubleEntry() ? Status.PENDING : Status.UNAVAILABLE;
    }

    protected String getEventCRFAnnotations(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        return ecb.getAnnotations();
    }

    protected void setEventCRFAnnotations(String annotations, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        ecb.setAnnotations(annotations);
    }

    protected Page getJSPPage() {
        return Page.VIEW_SECTION_DATA_ENTRY;
    }

    protected String getServletPage(HttpServletRequest request) {
        return Page.VIEW_SECTION_DATA_ENTRY_SERVLET.getFileName();
    }

    protected boolean validateInputOnFirstRound() {
        return true;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        dib = this.loadFormValue(dib, request);
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA) || rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            dib = this.validateDisplayItemBeanSingleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
            dib = this.validateDisplayItemBeanMultipleCV(v, dib, inputName);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, HttpServletRequest request, HttpServletResponse response) {
        return formGroups;
    }

    protected boolean shouldLoadDBValues(DisplayItemBean dib) {
        return true;
    }

    private void setAttributeForInterviewerDNotes(List<DiscrepancyNoteBean> eventCrfNotes, HttpServletRequest request) {
        for (DiscrepancyNoteBean dnBean : eventCrfNotes) {
            if ("interviewer_name".equalsIgnoreCase(dnBean.getColumn())) {
                request.setAttribute("hasNameNote", (Object)"yes");
                request.setAttribute("InterviewerNameNote", (Object)dnBean);
            }
            if (!"date_interviewed".equalsIgnoreCase(dnBean.getColumn())) continue;
            request.setAttribute("hasDateNote", (Object)"yes");
            request.setAttribute("InterviewerDateNote", (Object)dnBean);
        }
    }

    protected boolean shouldRunRules() {
        return false;
    }

    protected boolean isAdministrativeEditing() {
        return false;
    }

    protected boolean isAdminForcedReasonForChange(HttpServletRequest request) {
        return false;
    }
}

