/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewSiteServlet
extends SecureController {
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;

    public void mayProceed() throws InsufficientPermissionException {
        int siteId;
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        int n = siteId = this.request.getParameter("id") == null ? 0 : Integer.valueOf(this.request.getParameter("id"));
        if (this.currentStudy.getId() == siteId) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        String idString = "";
        idString = this.request.getAttribute("siteId") == null ? this.request.getParameter("id") : this.request.getAttribute("siteId").toString();
        this.logger.info("site id:" + idString);
        if (StringUtil.isBlank((String)idString)) {
            this.addPageMessage(respage.getString("please_choose_a_site_to_edit"));
            this.forwardPage(Page.SITE_LIST_SERVLET);
        } else {
            int siteId = Integer.valueOf(idString.trim());
            StudyBean study = (StudyBean)sdao.findByPK(siteId);
            this.checkRoleByUserAndStudy(this.ub, study.getParentStudyId(), study.getId());
            ArrayList configs = new ArrayList();
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            configs = spvdao.findParamConfigByStudy(study);
            study.setStudyParameters(configs);
            String parentStudyName = "";
            if (study.getParentStudyId() > 0) {
                StudyBean parent = (StudyBean)sdao.findByPK(study.getParentStudyId());
                parentStudyName = parent.getName();
            }
            this.request.setAttribute("parentName", (Object)parentStudyName);
            this.request.setAttribute("siteToView", (Object)study);
            this.request.setAttribute("idToSort", this.request.getAttribute("idToSort"));
            this.viewSiteEventDefinitions(study);
            this.forwardPage(Page.VIEW_SITE);
        }
    }

    private void viewSiteEventDefinitions(StudyBean siteToView) throws MalformedURLException {
        int siteId = siteToView.getId();
        ArrayList seds = new ArrayList();
        StudyEventDefinitionDAO sedDao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        seds = sedDao.findAllByStudy(siteToView);
        int start = 0;
        for (StudyEventDefinitionBean sed : seds) {
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            int defId = sed.getId();
            ArrayList edcs = (ArrayList)edcdao.findAllByDefinitionAndSiteIdAndParentStudyId(defId, siteId, siteToView.getParentStudyId());
            ArrayList<EventDefinitionCRFBean> defCrfs = new ArrayList<EventDefinitionCRFBean>();
            for (EventDefinitionCRFBean edcBean : edcs) {
                CRFBean cBean = (CRFBean)cdao.findByPK(edcBean.getCrfId());
                String crfPath = sed.getOid() + "." + cBean.getOid();
                edcBean.setOffline(this.getEventDefinitionCrfTagService().getEventDefnCrfOfflineStatus(2, crfPath, true));
                int edcStatusId = edcBean.getStatus().getId();
                CRFBean crf = (CRFBean)cdao.findByPK(edcBean.getCrfId());
                int crfStatusId = crf.getStatusId();
                ArrayList versions = (ArrayList)cvdao.findAllActiveByCRF(edcBean.getCrfId());
                edcBean.setVersions(versions);
                edcBean.setCrfName(crf.getName());
                CRFVersionBean defaultVersion = (CRFVersionBean)cvdao.findByPK(edcBean.getDefaultVersionId());
                edcBean.setDefaultVersionName(defaultVersion.getName());
                String sversionIds = edcBean.getSelectedVersionIds();
                ArrayList<Integer> idList = new ArrayList<Integer>();
                String idNames = "";
                if (sversionIds.length() > 0) {
                    String[] ids;
                    block2: for (String id : ids = sversionIds.split("\\,")) {
                        idList.add(Integer.valueOf(id));
                        for (CRFVersionBean v : versions) {
                            if (v.getId() != Integer.valueOf(id).intValue()) continue;
                            idNames = idNames + v.getName() + ",";
                            continue block2;
                        }
                    }
                    idNames = idNames.substring(0, idNames.length() - 1);
                }
                if (edcBean.getParentId() < 1) {
                    edcBean.setSubmissionUrl("");
                }
                edcBean.setSelectedVersionIdList(idList);
                edcBean.setSelectedVersionNames(idNames);
                defCrfs.add(edcBean);
                ++start;
            }
            sed.setCrfs(defCrfs);
            sed.setCrfNum(defCrfs.size());
        }
        this.request.setAttribute("definitions", (Object)seds);
        ArrayList<String> sdvOptions = new ArrayList<String>();
        sdvOptions.add(SourceDataVerification.AllREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.PARTIALREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.NOTREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.NOTAPPLICABLE.toString());
        this.request.setAttribute("sdvOptions", sdvOptions);
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

