/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.managestudy.ViewEventDefinitionBean;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.StudyEventRow;

public class ViewStudyEventsServlet
extends SecureController {
    Locale locale;
    public static final String INPUT_STARTDATE = "startDate";
    public static final String INPUT_ENDDATE = "endDate";
    public static final String INPUT_DEF_ID = "definitionId";
    public static final String INPUT_STATUS_ID = "statusId";
    public static final String STATUS_MAP = "statuses";
    public static final String DEFINITION_MAP = "definitions";
    public static final String PRINT = "print";

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, restext.getString("not_correct_role"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        int sedId = fp.getInt("sedId");
        int statusId = fp.getInt(INPUT_STATUS_ID);
        int definitionId = fp.getInt(INPUT_DEF_ID);
        Date startDate = fp.getDate(INPUT_STARTDATE);
        Date endDate = fp.getDate(INPUT_ENDDATE);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        String defaultStartDateString = month + "/01/" + year;
        Date defaultStartDate = new Date();
        defaultStartDate = new SimpleDateFormat("MM/dd/yy").parse(defaultStartDateString);
        DateFormat dateFormatter = DateFormat.getDateInstance(2, this.locale);
        defaultStartDateString = dateFormatter.format(defaultStartDate);
        cal.setTime(defaultStartDate);
        cal.add(5, 30);
        Date defaultEndDate = cal.getTime();
        if (!fp.isSubmitted()) {
            this.logger.info("not submitted");
            HashMap<String, String> presetValues = new HashMap<String, String>();
            presetValues.put(INPUT_STARTDATE, this.local_df.format(defaultStartDate));
            presetValues.put(INPUT_ENDDATE, this.local_df.format(defaultEndDate));
            startDate = defaultStartDate;
            endDate = defaultEndDate;
            this.setPresetValues(presetValues);
        } else {
            Validator v = new Validator(this.request);
            v.addValidation(INPUT_STARTDATE, 4);
            v.addValidation(INPUT_ENDDATE, 4);
            this.errors = v.validate();
            if (!this.errors.isEmpty()) {
                this.setInputMessages(this.errors);
                startDate = defaultStartDate;
                endDate = defaultEndDate;
            }
            fp.addPresetValue(INPUT_STARTDATE, fp.getString(INPUT_STARTDATE));
            fp.addPresetValue(INPUT_ENDDATE, fp.getString(INPUT_ENDDATE));
            fp.addPresetValue(INPUT_DEF_ID, fp.getInt(INPUT_DEF_ID));
            fp.addPresetValue(INPUT_STATUS_ID, fp.getInt(INPUT_STATUS_ID));
            this.setPresetValues(fp.getPresetValues());
        }
        this.request.setAttribute(STATUS_MAP, (Object)SubjectEventStatus.toArrayList());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        ArrayList definitions = seddao.findAllByStudy(this.currentStudy);
        this.request.setAttribute(DEFINITION_MAP, (Object)definitions);
        ArrayList allEvents = new ArrayList();
        allEvents = this.genTables(fp, definitions, startDate, endDate, sedId, definitionId, statusId);
        this.request.setAttribute("allEvents", (Object)allEvents);
        String queryUrl = "startDate=" + this.local_df.format(startDate) + "&" + INPUT_ENDDATE + "=" + this.local_df.format(endDate) + "&" + INPUT_DEF_ID + "=" + definitionId + "&" + INPUT_STATUS_ID + "=" + statusId + "&sedId=" + sedId + "&submitted=" + fp.getInt("submitted");
        this.request.setAttribute("queryUrl", (Object)queryUrl);
        if ("yes".equalsIgnoreCase(fp.getString(PRINT))) {
            allEvents = this.genEventsForPrint(fp, definitions, startDate, endDate, sedId, definitionId, statusId);
            this.request.setAttribute("allEvents", (Object)allEvents);
            this.forwardPage(Page.VIEW_STUDY_EVENTS_PRINT);
        } else {
            this.forwardPage(Page.VIEW_STUDY_EVENTS);
        }
    }

    private ArrayList genTables(FormProcessor fp, ArrayList definitions, Date startDate, Date endDate, int sedId, int definitionId, int statusId) {
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ArrayList<ViewEventDefinitionBean> allEvents = new ArrayList<ViewEventDefinitionBean>();
        definitions = this.findDefinitionById(definitions, definitionId);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        ArrayList studySubjects = ssdao.findAllByStudyId(this.currentStudy.getId());
        for (int i = 0; i < definitions.size(); ++i) {
            StudyEventBean se;
            int k;
            ViewEventDefinitionBean ved = new ViewEventDefinitionBean();
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)definitions.get(i);
            ved.setDefinition(sed);
            ArrayList events = new ArrayList();
            for (int s = 0; s < studySubjects.size(); ++s) {
                StudySubjectBean ssb = (StudySubjectBean)studySubjects.get(s);
                ArrayList evts = sedao.findAllWithSubjectLabelByStudySubjectAndDefinition(ssb, sed.getId());
                for (int v = 0; v < evts.size(); ++v) {
                    StudyEventBean seb = (StudyEventBean)evts.get(v);
                    if (!this.currentRole.isDirector() && !this.currentRole.isCoordinator() && seb.getSubjectEventStatus().isLocked()) {
                        seb.setEditable(false);
                    }
                    events.add(seb);
                }
            }
            int subjectScheduled = 0;
            int subjectCompleted = 0;
            int subjectDiscontinued = 0;
            events = this.findEventByStatusAndDate(events, statusId, startDate, endDate);
            Date firstStartDateForScheduled = null;
            Date lastCompletionDate = null;
            for (k = 0; k < events.size(); ++k) {
                se = (StudyEventBean)events.get(k);
                if (!se.getSubjectEventStatus().equals((Term)SubjectEventStatus.SCHEDULED)) continue;
                firstStartDateForScheduled = se.getDateStarted();
                break;
            }
            for (k = 0; k < events.size(); ++k) {
                se = (StudyEventBean)events.get(k);
                if (!se.getSubjectEventStatus().equals((Term)SubjectEventStatus.COMPLETED) || se.getDateEnded() == null) continue;
                lastCompletionDate = se.getDateEnded();
                break;
            }
            for (int j = 0; j < events.size(); ++j) {
                se = (StudyEventBean)events.get(j);
                if (se.getSubjectEventStatus().equals((Term)SubjectEventStatus.SCHEDULED)) {
                    ArrayList eventCRFs;
                    ++subjectScheduled;
                    if (se.getDateStarted().before(new Date()) && (eventCRFs = ecdao.findAllByStudyEvent(se)).isEmpty()) {
                        se.setScheduledDatePast(true);
                    }
                    if (firstStartDateForScheduled == null) {
                        firstStartDateForScheduled = se.getDateStarted();
                        continue;
                    }
                    if (!se.getDateStarted().before(firstStartDateForScheduled)) continue;
                    firstStartDateForScheduled = se.getDateStarted();
                    continue;
                }
                if (se.getSubjectEventStatus().equals((Term)SubjectEventStatus.COMPLETED)) {
                    ++subjectCompleted;
                    if (lastCompletionDate == null) {
                        lastCompletionDate = se.getDateEnded();
                        continue;
                    }
                    if (se.getDateEnded() == null || !se.getDateEnded().after(lastCompletionDate)) continue;
                    lastCompletionDate = se.getDateEnded();
                    continue;
                }
                if (se.getSubjectEventStatus().getId() <= 4) continue;
                ++subjectDiscontinued;
            }
            ved.setSubjectCompleted(subjectCompleted);
            ved.setSubjectScheduled(subjectScheduled);
            ved.setSubjectDiscontinued(subjectDiscontinued);
            ved.setFirstScheduledStartDate(firstStartDateForScheduled);
            ved.setLastCompletionDate(lastCompletionDate);
            EntityBeanTable table = sedId == sed.getId() ? fp.getEntityBeanTable() : new EntityBeanTable();
            table.setSortingIfNotExplicitlySet(1, false);
            ArrayList allEventRows = StudyEventRow.generateRowsFromBeans((ArrayList)events);
            String[] columns = new String[]{resword.getString("study_subject_ID"), resword.getString("event_date_started"), resword.getString("subject_event_status"), resword.getString("actions")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(3);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("sedId", new Integer(sed.getId()).toString());
            args.put(INPUT_DEF_ID, new Integer(definitionId).toString());
            args.put(INPUT_STATUS_ID, new Integer(statusId).toString());
            args.put(INPUT_STARTDATE, this.local_df.format(startDate));
            args.put(INPUT_ENDDATE, this.local_df.format(endDate));
            table.setQuery("ViewStudyEvents", args);
            table.setRows(allEventRows);
            table.computeDisplay();
            ved.setStudyEventTable(table);
            if (events.isEmpty()) continue;
            allEvents.add(ved);
        }
        return allEvents;
    }

    private ArrayList genEventsForPrint(FormProcessor fp, ArrayList definitions, Date startDate, Date endDate, int sedId, int definitionId, int statusId) {
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ArrayList<ViewEventDefinitionBean> allEvents = new ArrayList<ViewEventDefinitionBean>();
        definitions = this.findDefinitionById(definitions, definitionId);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        ArrayList studySubjects = ssdao.findAllByStudyId(this.currentStudy.getId());
        for (int i = 0; i < definitions.size(); ++i) {
            StudyEventBean se;
            int k;
            ViewEventDefinitionBean ved = new ViewEventDefinitionBean();
            StudyEventDefinitionBean sed = (StudyEventDefinitionBean)definitions.get(i);
            ved.setDefinition(sed);
            ArrayList events = new ArrayList();
            for (int s = 0; s < studySubjects.size(); ++s) {
                StudySubjectBean ssb = (StudySubjectBean)studySubjects.get(s);
                ArrayList evts = sedao.findAllWithSubjectLabelByStudySubjectAndDefinition(ssb, sed.getId());
                for (int v = 0; v < evts.size(); ++v) {
                    events.add(evts.get(v));
                }
            }
            int subjectScheduled = 0;
            int subjectCompleted = 0;
            int subjectDiscontinued = 0;
            events = this.findEventByStatusAndDate(events, statusId, startDate, endDate);
            Date firstStartDateForScheduled = null;
            Date lastCompletionDate = null;
            for (k = 0; k < events.size(); ++k) {
                se = (StudyEventBean)events.get(k);
                if (!se.getSubjectEventStatus().equals((Term)SubjectEventStatus.SCHEDULED)) continue;
                firstStartDateForScheduled = se.getDateStarted();
                break;
            }
            for (k = 0; k < events.size(); ++k) {
                se = (StudyEventBean)events.get(k);
                if (!se.getSubjectEventStatus().equals((Term)SubjectEventStatus.COMPLETED)) continue;
                lastCompletionDate = se.getDateEnded();
                break;
            }
            for (int j = 0; j < events.size(); ++j) {
                se = (StudyEventBean)events.get(j);
                if (se.getSubjectEventStatus().equals((Term)SubjectEventStatus.SCHEDULED)) {
                    ArrayList eventCRFs;
                    ++subjectScheduled;
                    if (se.getDateStarted().before(new Date()) && (eventCRFs = ecdao.findAllByStudyEvent(se)).isEmpty()) {
                        se.setScheduledDatePast(true);
                    }
                    if (firstStartDateForScheduled == null) {
                        firstStartDateForScheduled = se.getDateStarted();
                        continue;
                    }
                    if (!se.getDateStarted().before(firstStartDateForScheduled)) continue;
                    firstStartDateForScheduled = se.getDateStarted();
                    continue;
                }
                if (se.getSubjectEventStatus().equals((Term)SubjectEventStatus.COMPLETED)) {
                    ++subjectCompleted;
                    if (lastCompletionDate == null) {
                        lastCompletionDate = se.getDateEnded();
                        continue;
                    }
                    if (!se.getDateEnded().after(lastCompletionDate)) continue;
                    lastCompletionDate = se.getDateEnded();
                    continue;
                }
                if (se.getSubjectEventStatus().getId() <= 4) continue;
                ++subjectDiscontinued;
            }
            ved.setSubjectCompleted(subjectCompleted);
            ved.setSubjectScheduled(subjectScheduled);
            ved.setSubjectDiscontinued(subjectDiscontinued);
            ved.setFirstScheduledStartDate(firstStartDateForScheduled);
            ved.setLastCompletionDate(lastCompletionDate);
            ved.setStudyEvents(events);
            if (events.isEmpty()) continue;
            allEvents.add(ved);
        }
        return allEvents;
    }

    private ArrayList findDefinitionById(ArrayList definitions, int definitionId) {
        if (definitionId > 0) {
            for (int i = 0; i < definitions.size(); ++i) {
                StudyEventDefinitionBean sed = (StudyEventDefinitionBean)definitions.get(i);
                if (sed.getId() != definitionId) continue;
                ArrayList<StudyEventDefinitionBean> a = new ArrayList<StudyEventDefinitionBean>();
                a.add(sed);
                return a;
            }
        }
        return definitions;
    }

    private ArrayList findEventByStatusAndDate(ArrayList events, int statusId, Date startDate, Date endDate) {
        ArrayList<StudyEventBean> a = new ArrayList<StudyEventBean>();
        for (int i = 0; i < events.size(); ++i) {
            StudyEventBean se = (StudyEventBean)events.get(i);
            if (se.getDateStarted().before(startDate) || se.getDateStarted().after(endDate)) continue;
            a.add(se);
        }
        ArrayList<StudyEventBean> b = new ArrayList<StudyEventBean>();
        if (statusId > 0) {
            for (int i = 0; i < a.size(); ++i) {
                StudyEventBean se = (StudyEventBean)a.get(i);
                if (se.getSubjectEventStatus().getId() != statusId) continue;
                b.add(se);
            }
            return b;
        }
        return a;
    }
}

