/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewStudyUserServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_USER_IN_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        String name = this.request.getParameter("name");
        String studyIdString = this.request.getParameter("studyId");
        if (StringUtil.isBlank((String)name) || StringUtil.isBlank((String)studyIdString)) {
            this.addPageMessage(respage.getString("please_choose_a_user_to_view"));
            this.forwardPage(Page.LIST_USER_IN_STUDY_SERVLET);
        } else {
            int studyId = Integer.valueOf(studyIdString.trim());
            UserAccountBean user = (UserAccountBean)udao.findByUserName(name);
            this.request.setAttribute("user", (Object)user);
            StudyUserRoleBean uRole = udao.findRoleByUserNameAndStudyId(name, studyId);
            this.request.setAttribute("uRole", (Object)uRole);
            StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
            StudyBean study = (StudyBean)sdao.findByPK(studyId);
            this.request.setAttribute("uStudy", (Object)study);
            this.request.setAttribute("siteRoleMap", (Object)Role.siteRoleMap);
            String pattn = "";
            pattn = ResourceBundleProvider.getFormatBundle().getString("date_format_string");
            this.request.setAttribute("dateFormatPattern", (Object)pattn);
            this.request.setAttribute("action", (Object)"");
            this.forwardPage(Page.VIEW_USER_IN_STUDY);
        }
    }
}

