/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class CreateOneDiscrepancyNoteServlet
extends SecureController {
    Locale locale;
    public static final String ENTITY_ID = "id";
    public static final String SUBJECT_ID = "subjectId";
    public static final String ITEM_ID = "itemId";
    public static final String PARENT_ID = "parentId";
    public static final String ENTITY_TYPE = "name";
    public static final String ENTITY_COLUMN = "column";
    public static final String ENTITY_FIELD = "field";
    public static final String RES_STATUS_ID = "resStatusId";
    public static final String SUBMITTED_USER_ACCOUNT_ID = "userAccountId";
    public static final String PRESET_USER_ACCOUNT_ID = "preUserAccountId";
    public static final String EMAIL_USER_ACCOUNT = "sendEmail";
    public static final String BOX_DN_MAP = "boxDNMap";
    public static final String BOX_TO_SHOW = "boxToShow";

    protected void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.MENU_SERVLET, respage.getString("current_study_locked"));
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        String exceptionName = resexception.getString("no_permission_to_create_discrepancy_note");
        String noAccessMessage = respage.getString("you_may_not_create_discrepancy_note") + respage.getString("change_study_contact_sysadmin");
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(noAccessMessage);
        throw new InsufficientPermissionException(Page.MENU, exceptionName, "1");
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
        int eventCRFId = fp.getInt("eventCRFId");
        this.request.setAttribute("eventCRFId", (Object)new Integer(eventCRFId));
        int parentId = fp.getInt(PARENT_ID);
        DiscrepancyNoteBean parent = parentId > 0 ? (DiscrepancyNoteBean)dndao.findByPK(parentId) : new DiscrepancyNoteBean();
        HashMap boxDNMap = (HashMap)this.session.getAttribute(BOX_DN_MAP);
        boxDNMap = boxDNMap == null ? new HashMap() : boxDNMap;
        DiscrepancyNoteBean dn = boxDNMap.size() > 0 && boxDNMap.containsKey(parentId) ? (DiscrepancyNoteBean)boxDNMap.get(parentId) : new DiscrepancyNoteBean();
        int entityId = fp.getInt(ENTITY_ID, true);
        int n = entityId = entityId > 0 ? entityId : parent.getEntityId();
        if (entityId == 0) {
            Validator.addError((HashMap)this.errors, (String)("newChildAdded" + parentId), (String)respage.getString("note_cannot_be_saved"));
            this.logger.info("entityId is 0. Note saving can not be started.");
        }
        String entityType = fp.getString(ENTITY_TYPE, true);
        FormDiscrepancyNotes noteTree = (FormDiscrepancyNotes)this.session.getAttribute("fdnotes");
        if (noteTree == null) {
            noteTree = new FormDiscrepancyNotes();
        }
        String ypos = fp.getString("ypos" + parentId);
        int refresh = 0;
        String field = fp.getString(ENTITY_FIELD, true);
        String description = fp.getString("description" + parentId);
        int typeId = fp.getInt("typeId" + parentId);
        String detailedDes = fp.getString("detailedDes" + parentId);
        int resStatusId = fp.getInt(RES_STATUS_ID + parentId);
        int assignedUserAccountId = fp.getInt(SUBMITTED_USER_ACCOUNT_ID + parentId);
        String viewNoteLink = fp.getString("viewDNLink" + parentId);
        viewNoteLink = this.appendPageFileName(viewNoteLink, "fromBox", "1");
        Validator v = new Validator(this.request);
        v.addValidation("description" + parentId, 1);
        v.addValidation("description" + parentId, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("detailedDes" + parentId, 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 1000);
        v.addValidation("typeId" + parentId, 1);
        HashMap errors = v.validate();
        dn.setParentDnId(parentId);
        dn.setDescription(description);
        dn.setDiscrepancyNoteTypeId(typeId);
        dn.setDetailedNotes(detailedDes);
        dn.setResolutionStatusId(resStatusId);
        if (typeId != DiscrepancyNoteType.ANNOTATION.getId() && typeId != DiscrepancyNoteType.REASON_FOR_CHANGE.getId()) {
            dn.setAssignedUserId(assignedUserAccountId);
        }
        if (DiscrepancyNoteType.ANNOTATION.getId() == dn.getDiscrepancyNoteTypeId()) {
            this.updateStudyEvent(entityType, entityId);
            this.updateStudySubjectStatus(entityType, entityId);
        }
        if (DiscrepancyNoteType.ANNOTATION.getId() == dn.getDiscrepancyNoteTypeId() || DiscrepancyNoteType.REASON_FOR_CHANGE.getId() == dn.getDiscrepancyNoteTypeId()) {
            dn.setResStatus(ResolutionStatus.NOT_APPLICABLE);
            dn.setResolutionStatusId(ResolutionStatus.NOT_APPLICABLE.getId());
        }
        if ((DiscrepancyNoteType.FAILEDVAL.getId() == dn.getDiscrepancyNoteTypeId() || DiscrepancyNoteType.QUERY.getId() == dn.getDiscrepancyNoteTypeId()) && ResolutionStatus.NOT_APPLICABLE.getId() == dn.getResolutionStatusId()) {
            Validator.addError((HashMap)errors, (String)(RES_STATUS_ID + parentId), (String)restext.getString("not_valid_res_status"));
        }
        if (errors.isEmpty()) {
            boolean success;
            HashMap results = new HashMap();
            ArrayList<String> mess = new ArrayList<String>();
            String column = fp.getString(ENTITY_COLUMN, true);
            dn.setOwner(this.ub);
            dn.setStudyId(this.currentStudy.getId());
            dn.setEntityId(entityId);
            dn.setEntityType(entityType);
            dn.setColumn(column);
            dn.setField(field);
            if (parentId > 0) {
                if (dn.getResolutionStatusId() != parent.getResolutionStatusId()) {
                    parent.setResolutionStatusId(dn.getResolutionStatusId());
                    dndao.update((EntityBean)parent);
                    if (!parent.isActive()) {
                        this.logger.info("Failed to update resolution status ID for the parent dn ID = " + parentId + ". ");
                    }
                }
                if (dn.getAssignedUserId() != parent.getAssignedUserId()) {
                    parent.setAssignedUserId(dn.getAssignedUserId());
                    if (parent.getAssignedUserId() > 0) {
                        dndao.updateAssignedUser((EntityBean)parent);
                    } else {
                        dndao.updateAssignedUserToNull((EntityBean)parent);
                    }
                    if (!parent.isActive()) {
                        this.logger.info("Failed to update assigned user ID for the parent dn ID= " + parentId + ". ");
                    }
                }
            } else {
                ypos = "0";
            }
            boolean bl = success = (dn = (DiscrepancyNoteBean)dndao.create((EntityBean)dn)).getId() > 0;
            if (success) {
                refresh = 1;
                dndao.createMapping(dn);
                success = dndao.isQuerySuccessful();
                if (!success) {
                    mess.add(restext.getString("failed_create_dn_mapping_for_dnId") + dn.getId() + ". ");
                }
                noteTree.addNote(eventCRFId + "_" + field, dn);
                noteTree.addIdNote(dn.getEntityId(), field);
                this.session.setAttribute("fdnotes", (Object)noteTree);
                if (dn.getParentDnId() == 0) {
                    dn.setParentDnId(dn.getId());
                    dn = (DiscrepancyNoteBean)dndao.create((EntityBean)dn);
                    if (dn.getId() > 0) {
                        dndao.createMapping(dn);
                        if (!dndao.isQuerySuccessful()) {
                            mess.add(restext.getString("failed_create_dn_mapping_for_dnId") + dn.getId() + ". ");
                        }
                        noteTree.addNote(eventCRFId + "_" + field, dn);
                        noteTree.addIdNote(dn.getEntityId(), field);
                        this.session.setAttribute("fdnotes", (Object)noteTree);
                    } else {
                        mess.add(restext.getString("failed_create_child_dn_for_new_parent_dnId") + dn.getId() + ". ");
                    }
                }
            } else {
                mess.add(restext.getString("failed_create_new_dn") + ". ");
            }
            if (success) {
                String close;
                if (boxDNMap.size() > 0 && boxDNMap.containsKey(parentId)) {
                    boxDNMap.remove(parentId);
                }
                this.session.removeAttribute(BOX_TO_SHOW);
                this.manageReasonForChangeState(this.session, eventCRFId + "_" + field);
                String email = fp.getString(EMAIL_USER_ACCOUNT + parentId);
                if (dn.getAssignedUserId() > 0 && "1".equals(email.trim())) {
                    this.logger.info("++++++ found our way here");
                    StringBuffer message = new StringBuffer();
                    dn = this.getNoteInfo(dn);
                    EmailEngine em = new EmailEngine(EmailEngine.getSMTPHost());
                    UserAccountDAO userAccountDAO = new UserAccountDAO(this.sm.getDataSource());
                    ItemDAO itemDAO = new ItemDAO(this.sm.getDataSource());
                    ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                    ItemBean item = new ItemBean();
                    ItemDataBean itemData = new ItemDataBean();
                    StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
                    UserAccountBean assignedUser = (UserAccountBean)userAccountDAO.findByPK(dn.getAssignedUserId());
                    String alertEmail = assignedUser.getEmail();
                    message.append(MessageFormat.format(respage.getString("mailDNHeader"), assignedUser.getFirstName(), assignedUser.getLastName()));
                    message.append("<A HREF='" + SQLInitServlet.getField((String)"sysURL.base") + "ViewNotes?module=submit&listNotes_f_discrepancyNoteBean.user=" + assignedUser.getName() + "&listNotes_f_entityName=" + dn.getEntityName() + "'>" + SQLInitServlet.getField((String)"sysURL.base") + "</A><BR/>");
                    message.append(respage.getString("you_received_this_from"));
                    StudyBean study = (StudyBean)studyDAO.findByPK(dn.getStudyId());
                    if ("itemData".equalsIgnoreCase(entityType)) {
                        itemData = (ItemDataBean)iddao.findByPK(dn.getEntityId());
                        item = (ItemBean)itemDAO.findByPK(itemData.getItemId());
                    }
                    message.append(respage.getString("email_body_separator"));
                    message.append(respage.getString("disc_note_info"));
                    message.append(respage.getString("email_body_separator"));
                    message.append(MessageFormat.format(respage.getString("mailDNParameters1"), dn.getDescription(), dn.getDetailedNotes(), this.ub.getName()));
                    message.append(respage.getString("email_body_separator"));
                    message.append(respage.getString("entity_information"));
                    message.append(respage.getString("email_body_separator"));
                    message.append(MessageFormat.format(respage.getString("mailDNParameters2"), study.getName(), dn.getSubjectName()));
                    if (!"studySub".equalsIgnoreCase(entityType) && !"subject".equalsIgnoreCase(entityType)) {
                        message.append(MessageFormat.format(respage.getString("mailDNParameters3"), dn.getEventName()));
                        if (!"studyEvent".equalsIgnoreCase(dn.getEntityType())) {
                            message.append(MessageFormat.format(respage.getString("mailDNParameters4"), dn.getCrfName()));
                            if (!"eventCrf".equalsIgnoreCase(dn.getEntityType())) {
                                message.append(MessageFormat.format(respage.getString("mailDNParameters6"), item.getName()));
                            }
                        }
                    }
                    message.append(respage.getString("email_body_separator"));
                    message.append(MessageFormat.format(respage.getString("mailDNThanks"), study.getName()));
                    message.append(respage.getString("email_body_separator"));
                    message.append(respage.getString("disclaimer"));
                    message.append(respage.getString("email_body_separator"));
                    message.append(respage.getString("email_footer"));
                    String emailBodyString = message.toString();
                    this.sendEmail(alertEmail.trim(), EmailEngine.getAdminEmail(), MessageFormat.format(respage.getString("mailDNSubject"), study.getName(), dn.getEntityName()), emailBodyString, Boolean.valueOf(true), null, null, Boolean.valueOf(true));
                }
                if ("true".equals(close = fp.getString("close" + parentId))) {
                    this.addPageMessage(respage.getString("note_saved_into_db"));
                    this.addPageMessage(respage.getString("page_close_automatically"));
                    this.forwardPage(Page.ADD_DISCREPANCY_NOTE_SAVE_DONE);
                    this.logger.info("Should forwardPage to ADD_DISCREPANCY_NOTE_SAVE_DONE.");
                } else if (parentId == dn.getParentDnId()) {
                    mess.add(restext.getString("a_new_child_dn_added"));
                    results.put("newChildAdded" + parentId, mess);
                    this.setInputMessages(results);
                } else {
                    this.addPageMessage(restext.getString("a_new_dn_thread_added"));
                }
            } else {
                this.session.setAttribute(BOX_TO_SHOW, (Object)(parentId + ""));
            }
        } else {
            this.setInputMessages(errors);
            boxDNMap.put(parentId, dn);
            this.session.setAttribute(BOX_TO_SHOW, (Object)(parentId + ""));
        }
        this.session.setAttribute(BOX_DN_MAP, (Object)boxDNMap);
        viewNoteLink = this.appendPageFileName(viewNoteLink, "refresh", refresh + "");
        viewNoteLink = this.appendPageFileName(viewNoteLink, "y", ypos != null && ypos.length() > 0 ? ypos : "0");
        this.getServletContext().getRequestDispatcher(viewNoteLink).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    private void updateStudySubjectStatus(String entityType, int entityId) {
        if ("itemData".equalsIgnoreCase(entityType)) {
            EventCRFBean ec;
            StudyEventBean event;
            int itemDataId = entityId;
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            ItemDataBean itemData = (ItemDataBean)iddao.findByPK(itemDataId);
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.sm.getDataSource());
            StudySubjectBean studySubject = (StudySubjectBean)studySubjectDAO.findByPK((event = (StudyEventBean)svdao.findByPK((ec = (EventCRFBean)ecdao.findByPK(itemData.getEventCRFId())).getStudyEventId())).getStudySubjectId());
            if (studySubject.getStatus() != null && studySubject.getStatus().equals((Term)Status.SIGNED)) {
                studySubject.setStatus(Status.AVAILABLE);
                studySubject.setUpdater(this.ub);
                studySubject.setUpdatedDate(new Date());
                studySubjectDAO.update((EntityBean)studySubject);
            }
            if (ec.isSdvStatus()) {
                studySubject.setStatus(Status.AVAILABLE);
                studySubject.setUpdater(this.ub);
                studySubject.setUpdatedDate(new Date());
                studySubjectDAO.update((EntityBean)studySubject);
                ec.setSdvStatus(false);
                ecdao.update((EntityBean)ec);
            }
        }
    }

    private void updateStudyEvent(String entityType, int entityId) {
        if ("itemData".equalsIgnoreCase(entityType)) {
            EventCRFBean ec;
            int itemDataId = entityId;
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            ItemDataBean itemData = (ItemDataBean)iddao.findByPK(itemDataId);
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            StudyEventBean event = (StudyEventBean)svdao.findByPK((ec = (EventCRFBean)ecdao.findByPK(itemData.getEventCRFId())).getStudyEventId());
            if (event.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED)) {
                event.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
                event.setUpdater(this.ub);
                event.setUpdatedDate(new Date());
                svdao.update((EntityBean)event);
            }
        } else if ("eventCrf".equalsIgnoreCase(entityType)) {
            EventCRFBean ec;
            int eventCRFId = entityId;
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            StudyEventBean event = (StudyEventBean)svdao.findByPK((ec = (EventCRFBean)ecdao.findByPK(eventCRFId)).getStudyEventId());
            if (event.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED)) {
                event.setSubjectEventStatus(SubjectEventStatus.COMPLETED);
                event.setUpdater(this.ub);
                event.setUpdatedDate(new Date());
                svdao.update((EntityBean)event);
            }
        }
    }

    private void manageReasonForChangeState(HttpSession session, String itemDataBeanId) {
        HashMap<String, Boolean> noteSubmitted = (HashMap<String, Boolean>)session.getAttribute("note_submitted");
        if (noteSubmitted == null) {
            noteSubmitted = new HashMap<String, Boolean>();
        }
        noteSubmitted.put(itemDataBeanId, Boolean.TRUE);
        session.setAttribute("note_submitted", noteSubmitted);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String appendPageFileName(String origin, String parameterName, String parameterValue) {
        String parameter = parameterName + "=" + parameterValue;
        String[] a = origin.split("\\?");
        if (a.length == 2) {
            if (!("&" + a[1]).contains("&" + parameterName + "=")) return origin + "&" + parameter;
            String result = a[0] + "?";
            String[] b = ("&" + a[1]).split("&" + parameterName + "=");
            if (b.length == 2) {
                return result + b[0].substring(1) + "&" + parameter + (b[1].contains("&") ? b[1].substring(b[1].indexOf("&")) : "");
            }
            if (b.length > 2) {
                result = result + b[0].substring(1) + "&" + parameter;
                for (int i = 2; i < b.length - 2; ++i) {
                    result = result + b[i].substring(b[i].indexOf("&"));
                }
                int j = b.length - 1;
                return result + (b[j].contains("&") ? b[j].substring(b[j].indexOf("&")) : "");
            }
        } else if (a.length == 1) {
            if (!origin.endsWith("?")) return origin + "?" + parameter;
            return origin + parameter;
        }
        this.logger.info("Original pageFileName: " + origin);
        return origin;
    }
}

