/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.akaza.openclinica.control.submit.EnterDataProgress;
import org.akaza.openclinica.control.submit.SectionVisit;

public class DoubleDataProgress
implements EnterDataProgress {
    private List<SectionVisit> synchronizedList = Collections.synchronizedList(new ArrayList());
    private int eventCRFId = 0;

    public DoubleDataProgress() {
    }

    public DoubleDataProgress(int numberOfSections, int eventCRFId) {
        this();
        this.eventCRFId = eventCRFId;
        numberOfSections = numberOfSections < 1 ? 1 : numberOfSections;
        ArrayList<SectionVisit> sectionVisits = new ArrayList<SectionVisit>();
        for (int i = 1; i <= numberOfSections; ++i) {
            SectionVisit sectionVisit = new SectionVisit();
            sectionVisit.setSectionNumber(i);
            sectionVisit.setEventCRFId(eventCRFId);
            sectionVisits.add(sectionVisit);
        }
        this.synchronizedList = Collections.synchronizedList(sectionVisits);
    }

    public boolean getSectionVisited(int sectionNumber, int eventCRFId) {
        for (SectionVisit secVisit : this.synchronizedList) {
            if (secVisit.getEventCRFId() != eventCRFId || secVisit.getSectionNumber() != sectionNumber) continue;
            return secVisit.isVisitedOnce();
        }
        return false;
    }

    public void setSectionVisited(int eventCRFId, int sectionNumber, boolean hasVisited) {
        for (SectionVisit secVisit : this.synchronizedList) {
            if (secVisit.getEventCRFId() != eventCRFId || secVisit.getSectionNumber() != sectionNumber) continue;
            secVisit.setVisitedOnce(hasVisited);
        }
    }

    public int getEventCRFId() {
        return this.eventCRFId;
    }

    public void setEventCRFId(int eventCRFId) {
        this.eventCRFId = eventCRFId;
    }
}

