/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class DownloadAttachedFileServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        FormProcessor fp = new FormProcessor(this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.request.setAttribute("downloadStatus", (Object)"false");
        this.addPageMessage(respage.getString("you_not_have_permission_download_attached_file"));
        throw new InsufficientPermissionException(Page.DOWNLOAD_ATTACHED_FILE, resexception.getString("no_permission"), "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest() throws Exception {
        String definedDownloadPath;
        String canonicalPath;
        String fileName;
        String filePathName;
        block14: {
            String testName;
            String tail;
            String testPath;
            block16: {
                File temp;
                int parentStudyId;
                block15: {
                    FormProcessor fp = new FormProcessor(this.request);
                    filePathName = "";
                    fileName = fp.getString("fileName");
                    this.logger.debug("fileName .... " + fileName);
                    File f = new File(fileName);
                    if (fileName == null || fileName.length() <= 0) break block14;
                    parentStudyId = this.currentStudy.getParentStudyId();
                    testPath = Utils.getAttachedFileRootPath();
                    this.logger.debug("testPath .... " + testPath);
                    tail = File.separator + f.getName();
                    this.logger.debug("tail .... " + tail);
                    testName = testPath + this.currentStudy.getOid() + tail;
                    this.logger.debug("testName .... " + testName);
                    String filePath = testPath + this.currentStudy.getOid() + File.separator;
                    this.logger.debug("filePath .... " + filePath);
                    temp = new File(filePath, f.getName());
                    String canonicalPath2 = temp.getCanonicalPath();
                    this.logger.debug("canonicalPath .... " + canonicalPath2);
                    this.logger.debug("canonicalPath.startsWith(filePath) .... " + canonicalPath2);
                    if (!this.startsWithIgnoringSlashes(canonicalPath2, filePath)) {
                        throw new RuntimeException("Traversal attempt - file path not allowed " + fileName);
                    }
                    if (!temp.exists()) break block15;
                    filePathName = testName;
                    this.logger.info(this.currentStudy.getName() + " existing filePathName=" + filePathName);
                    break block14;
                }
                if (!this.currentStudy.isSite(parentStudyId)) break block16;
                testName = testPath + ((StudyBean)new StudyDAO(this.sm.getDataSource()).findByPK(parentStudyId)).getOid() + tail;
                temp = new File(testName);
                if (!temp.exists()) break block14;
                filePathName = testName;
                this.logger.info("parent existing filePathName=" + filePathName);
                break block14;
            }
            ArrayList sites = (ArrayList)new StudyDAO(this.sm.getDataSource()).findAllByParent(this.currentStudy.getId());
            for (StudyBean s : sites) {
                testPath = Utils.getAttachedFilePath((StudyBean)s);
                testName = testPath + tail;
                File test = new File(testName);
                if (!test.exists()) continue;
                filePathName = testName;
                this.logger.info("site of currentStudy existing filePathName=" + filePathName);
                break;
            }
        }
        this.logger.info("filePathName=" + filePathName + " fileName=" + fileName);
        File file = null;
        file = filePathName != null && filePathName.trim().length() > 0 ? new File(filePathName) : new File(fileName);
        if (file != null && file.exists() && !this.startsWithIgnoringSlashes(canonicalPath = file.getCanonicalPath(), definedDownloadPath = Utils.getAttachedFileRootPath())) {
            throw new RuntimeException("Traversal attempt - file path not allowed " + fileName);
        }
        if (!file.exists() || file.length() <= 0L) {
            this.addPageMessage("File " + filePathName + " " + respage.getString("not_exist"));
        } else {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\";");
            this.response.setHeader("Pragma", "public");
            ServletOutputStream outStream = this.response.getOutputStream();
            FilterInputStream inStream = null;
            try {
                int length;
                this.response.setContentType("application/download");
                this.response.setHeader("Cache-Control", "max-age=0");
                this.response.setContentLength((int)file.length());
                byte[] bbuf = new byte[(int)file.length()];
                inStream = new DataInputStream(new FileInputStream(file));
                while (inStream != null && (length = ((DataInputStream)inStream).read(bbuf)) != -1) {
                    outStream.write(bbuf, 0, length);
                }
                inStream.close();
                outStream.flush();
                outStream.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
        }
    }

    private boolean startsWithIgnoringSlashes(String str1, String str2) {
        String normalizedStr1 = str1.replace("/", "").replace("\\", "");
        String normalizedStr2 = str2.replace("/", "").replace("\\", "");
        this.logger.debug("normalizedStr1 .... {}", (Object)normalizedStr1);
        this.logger.debug("normalizedStr2 .... {}", (Object)normalizedStr2);
        return normalizedStr1.startsWith(normalizedStr2);
    }
}

