/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.rule.FileProperties;
import org.akaza.openclinica.bean.rule.FileUploadHelper;
import org.akaza.openclinica.bean.rule.XmlSchemaValidationHelper;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.core.XMLContextFactory;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.domain.rule.RulesPostImportContainer;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.rule.RulesPostImportContainerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRuleServlet
extends SecureController {
    private static final long serialVersionUID = 9116068126651934226L;
    protected final Logger log = LoggerFactory.getLogger(ImportRuleServlet.class);
    Locale locale;
    FileUploadHelper uploadHelper = new FileUploadHelper(new FileProperties("xml"));
    XmlSchemaValidationHelper schemaValidator = new XmlSchemaValidationHelper();
    RulesPostImportContainerService rulesPostImportContainerService;

    public void processRequest() throws Exception {
        File file;
        String action = this.request.getParameter("action");
        this.request.setAttribute("contextPath", (Object)this.getContextPath());
        this.request.setAttribute("hostPath", (Object)this.getHostPath());
        this.copyFiles();
        if (StringUtil.isBlank((String)action)) {
            this.forwardPage(Page.IMPORT_RULES);
        }
        if ("downloadrulesxsd".equalsIgnoreCase(action)) {
            File xsdFile = this.getCoreResources().getFile("rules.xsd", "rules" + File.separator);
            this.dowloadFile(xsdFile, "text/xml");
        }
        if ("downloadtemplate".equalsIgnoreCase(action)) {
            file = this.getCoreResources().getFile("rules_template.xml", "rules" + File.separator);
            this.dowloadFile(file, "text/xml");
        }
        if ("downloadtemplateWithNotes".equalsIgnoreCase(action)) {
            file = this.getCoreResources().getFile("rules_template_with_notes.xml", "rules" + File.separator);
            this.dowloadFile(file, "text/xml");
        }
        if ("confirm".equalsIgnoreCase(action)) {
            try {
                File f = (File)this.uploadHelper.returnFiles(this.request, this.context, this.getDirToSaveUploadedFileIn()).get(0);
                InputStream xsdFile = this.getCoreResources().getInputStream("rules.xsd");
                this.schemaValidator.validateAgainstSchema(f, xsdFile);
                RulesPostImportContainer importedRules = this.handleLoadCastor(f);
                this.logger.info(this.ub.getFirstName());
                importedRules = this.getRulesPostImportContainerService().validateRuleDefs(importedRules);
                importedRules = this.getRulesPostImportContainerService().validateRuleSetDefs(importedRules);
                this.session.setAttribute("importedData", (Object)importedRules);
                this.provideMessage(importedRules);
                this.forwardPage(Page.VERIFY_RULES_IMPORT_SERVLET);
            }
            catch (OpenClinicaSystemException re) {
                MessageFormat mf = new MessageFormat("");
                mf.applyPattern(re.getErrorCode() == null ? respage.getString("OCRERR_0016") : respage.getString(re.getErrorCode()));
                Object[] arguments = new Object[]{re.getMessage()};
                if (re.getErrorCode() != null) {
                    arguments = re.getErrorParams();
                }
                this.addPageMessage(mf.format(arguments));
                this.forwardPage(Page.IMPORT_RULES);
            }
        }
    }

    private void copyFiles() {
    }

    private void provideMessage(RulesPostImportContainer rulesContainer) {
        int validRuleSetDefs = rulesContainer.getValidRuleSetDefs().size();
        int duplicateRuleSetDefs = rulesContainer.getDuplicateRuleSetDefs().size();
        int invalidRuleSetDefs = rulesContainer.getInValidRuleSetDefs().size();
        int validRuleDefs = rulesContainer.getValidRuleDefs().size();
        int duplicateRuleDefs = rulesContainer.getDuplicateRuleDefs().size();
        int invalidRuleDefs = rulesContainer.getInValidRuleDefs().size();
        if (validRuleSetDefs > 0 && duplicateRuleSetDefs == 0 && invalidRuleSetDefs == 0 && duplicateRuleDefs == 0 && invalidRuleDefs == 0) {
            this.addPageMessage(respage.getString("rules_Import_message1"));
        }
        if (duplicateRuleSetDefs > 0 && invalidRuleSetDefs == 0 && duplicateRuleDefs >= 0 && invalidRuleDefs == 0) {
            this.addPageMessage(respage.getString("rules_Import_message2"));
        }
        if (invalidRuleSetDefs > 0 && invalidRuleDefs >= 0) {
            this.addPageMessage(respage.getString("rules_Import_message3"));
        }
    }

    private String getDirToSaveUploadedFileIn() throws OpenClinicaSystemException {
        String dir = SQLInitServlet.getField((String)"filePath");
        if (!new File(dir).exists()) {
            throw new OpenClinicaSystemException(respage.getString("filepath_you_defined_not_seem_valid"));
        }
        String theDir = dir + "rules" + File.separator + "original" + File.separator;
        return theDir;
    }

    private RulesPostImportContainer handleLoadCastor(File xmlFile) {
        RulesPostImportContainer ruleImport = null;
        try {
            XMLContext xmlContext = XMLContextFactory.getXmlContextNoNamespace();
            Mapping mapping = xmlContext.createMapping();
            mapping.loadMapping(this.getCoreResources().getURL("mapping.xml"));
            xmlContext.addMapping(mapping);
            Unmarshaller unmarshaller = xmlContext.createUnmarshaller();
            unmarshaller.setWhitespacePreserve(false);
            unmarshaller.setClass(RulesPostImportContainer.class);
            FileReader reader = new FileReader(xmlFile);
            ruleImport = (RulesPostImportContainer)unmarshaller.unmarshal((Reader)reader);
            ruleImport.initializeRuleDef();
            this.logRuleImport(ruleImport);
            return ruleImport;
        }
        catch (FileNotFoundException ex) {
            throw new OpenClinicaSystemException(ex.getMessage(), ex.getCause());
        }
        catch (IOException ex) {
            throw new OpenClinicaSystemException(ex.getMessage(), ex.getCause());
        }
        catch (MarshalException e) {
            throw new OpenClinicaSystemException(e.getMessage(), e.getCause());
        }
        catch (ValidationException e) {
            throw new OpenClinicaSystemException(e.getMessage(), e.getCause());
        }
        catch (MappingException e) {
            throw new OpenClinicaSystemException(e.getMessage(), e.getCause());
        }
    }

    private void logRuleImport(RulesPostImportContainer ruleImport) {
        this.logger.info("Total Number of RuleDefs Being imported : {} ", (Object)ruleImport.getRuleDefs().size());
        this.logger.info("Total Number of RuleAssignments Being imported : {} ", (Object)ruleImport.getRuleSets().size());
    }

    private RulesPostImportContainerService getRulesPostImportContainerService() {
        this.rulesPostImportContainerService = this.rulesPostImportContainerService != null ? this.rulesPostImportContainerService : (RulesPostImportContainerService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("rulesPostImportContainerService");
        this.rulesPostImportContainerService.setCurrentStudy(this.currentStudy);
        this.rulesPostImportContainerService.setRespage(respage);
        this.rulesPostImportContainerService.setUserAccount(this.ub);
        return this.rulesPostImportContainerService;
    }

    private CoreResources getCoreResources() {
        return (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("coreResources");
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }
}

