/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.control.submit.ListNotesTableFactory;
import org.akaza.openclinica.control.submit.ListNotesTableToolbar;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.hibernate.AuditUserLoginDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.ListNotesFilter;
import org.akaza.openclinica.dao.managestudy.ListNotesSort;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.DiscrepancyNotesSummary;
import org.akaza.openclinica.service.managestudy.ViewNotesFilterCriteria;
import org.akaza.openclinica.service.managestudy.ViewNotesService;
import org.akaza.openclinica.service.managestudy.ViewNotesSortCriteria;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.DateCellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.HtmlBuilder;
import org.jmesa.view.html.toolbar.Toolbar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListNotesTableFactory
extends AbstractTableFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)ListNotesTableFactory.class.getName());
    private AuditUserLoginDao auditUserLoginDao;
    private StudySubjectDAO studySubjectDao;
    private UserAccountDAO userAccountDao;
    private DiscrepancyNoteDAO discrepancyNoteDao;
    private StudyDAO studyDao;
    private SubjectDAO subjectDao;
    private CRFVersionDAO crfVersionDao;
    private CRFDAO crfDao;
    private StudyEventDAO studyEventDao;
    private StudyEventDefinitionDAO studyEventDefinitionDao;
    private EventDefinitionCRFDAO eventDefinitionCRFDao;
    private ItemDataDAO itemDataDao;
    private ItemDAO itemDao;
    private EventCRFDAO eventCRFDao;
    private StudyBean currentStudy;
    private ResourceBundle resword;
    private ResourceBundle resformat;
    private List<DiscrepancyNoteBean> allNotes = new ArrayList();
    private ArrayList<StudyEventDefinitionBean> studyEventDefinitions;
    private String module;
    private Integer resolutionStatus;
    private Integer discNoteType;
    private Boolean studyHasDiscNotes = new Boolean(false);
    private ViewNotesService viewNotesService;
    private final boolean showMoreLink;
    private DiscrepancyNotesSummary notesSummary;
    private final TypeDroplistFilterEditor discrepancyNoteTypeDropdown = new TypeDroplistFilterEditor(this);
    private final ResolutionStatusDroplistFilterEditor resolutionStatusDropdown = new ResolutionStatusDroplistFilterEditor(this);

    public ListNotesTableFactory(boolean showMoreLink) {
        this.showMoreLink = showMoreLink;
    }

    protected String getTableName() {
        return "listNotes";
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"studySubject.label", "discrepancyNoteBean.disType", "discrepancyNoteBean.resolutionStatus", "siteId", "discrepancyNoteBean.createdDate", "discrepancyNoteBean.updatedDate", "age", "days", "eventName", "eventStartDate", "crfName", "crfStatus", "entityName", "entityValue", "discrepancyNoteBean.entityType", "discrepancyNoteBean.description", "discrepancyNoteBean.detailedNotes", "numberOfNotes", "discrepancyNoteBean.user", "discrepancyNoteBean.owner", "actions"});
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn("studySubject.label"), this.resword.getString("study_subject_ID"), null, null, true, true);
        this.configureColumn(row.getColumn("siteId"), this.resword.getString("site_id"), null, null, true, false);
        this.configureColumn(row.getColumn("discrepancyNoteBean.createdDate"), this.resword.getString("date_created"), (CellEditor)new DateCellEditor(this.getDateFormat()), null, true, true);
        this.configureColumn(row.getColumn("discrepancyNoteBean.updatedDate"), this.resword.getString("date_updated"), (CellEditor)new DateCellEditor(this.getDateFormat()), null, true, false);
        this.configureColumn(row.getColumn("eventStartDate"), this.resword.getString("event_date"), (CellEditor)new DateCellEditor(this.getDateFormat()), null, false, false);
        this.configureColumn(row.getColumn("eventName"), this.resword.getString("event_name"), null, null, true, false);
        this.configureColumn(row.getColumn("crfName"), this.resword.getString("CRF"), null, null, true, false);
        this.configureColumn(row.getColumn("crfStatus"), this.resword.getString("CRF_status"), null, null, false, false);
        this.configureColumn(row.getColumn("entityName"), this.resword.getString("entity_name"), (CellEditor)new EntityNameCellEditor(this, null), null, true, false);
        this.configureColumn(row.getColumn("entityValue"), this.resword.getString("entity_value"), null, null, true, false);
        this.configureColumn(row.getColumn("discrepancyNoteBean.description"), this.resword.getString("description"), null, null, true, false);
        this.configureColumn(row.getColumn("discrepancyNoteBean.detailedNotes"), this.resword.getString("detailed_notes"), null, null, false, false);
        this.configureColumn(row.getColumn("numberOfNotes"), this.resword.getString("of_notes"), null, null, false, false);
        this.configureColumn(row.getColumn("discrepancyNoteBean.user"), this.resword.getString("assigned_user"), (CellEditor)new AssignedUserCellEditor(this, null), null, true, false);
        this.configureColumn(row.getColumn("discrepancyNoteBean.resolutionStatus"), this.resword.getString("resolution_status"), (CellEditor)new ResolutionStatusCellEditor(this, null), (FilterEditor)this.resolutionStatusDropdown, true, false);
        this.configureColumn(row.getColumn("discrepancyNoteBean.disType"), this.resword.getString("type"), (CellEditor)new DiscrepancyNoteTypeCellEditor(this, null), (FilterEditor)this.discrepancyNoteTypeDropdown, true, false);
        this.configureColumn(row.getColumn("discrepancyNoteBean.entityType"), this.resword.getString("entity_type"), null, null, true, false);
        this.configureColumn(row.getColumn("discrepancyNoteBean.owner"), this.resword.getString("owner"), (CellEditor)new OwnerCellEditor(this, null), null, false, false);
        String actionsHeader = this.resword.getString("actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;";
        this.configureColumn(row.getColumn("actions"), actionsHeader, (CellEditor)new ActionsCellEditor(this, null), (FilterEditor)new DefaultActionsEditor(locale), true, false);
        this.configureColumn(row.getColumn("age"), this.resword.getString("days_open"), null, null);
        this.configureColumn(row.getColumn("days"), this.resword.getString("days_since_updated"), null, null);
    }

    public void configureTableFacadePostColumnConfiguration(TableFacade tableFacade) {
        ListNotesTableToolbar toolbar = new ListNotesTableToolbar(this.showMoreLink);
        toolbar.setStudyHasDiscNotes(this.studyHasDiscNotes.booleanValue());
        toolbar.setDiscNoteType(this.discNoteType.intValue());
        toolbar.setResolutionStatus(this.resolutionStatus.intValue());
        toolbar.setModule(this.module);
        toolbar.setResword(this.resword);
        Limit limit = tableFacade.getLimit();
        toolbar.setFilterSet(limit.getFilterSet());
        toolbar.setSortSet(limit.getSortSet());
        tableFacade.setToolbar((Toolbar)toolbar);
    }

    public List<DiscrepancyNoteBean> findAllNotes(TableFacade tableFacade) {
        Limit limit = tableFacade.getLimit();
        limit.setRowSelect(null);
        ViewNotesFilterCriteria filter = ViewNotesFilterCriteria.buildFilterCriteria((Limit)limit, (String)this.getDateFormat(), (Map)this.discrepancyNoteTypeDropdown.getDecoder(), (Map)this.resolutionStatusDropdown.getDecoder());
        List items = this.getViewNotesService().listNotes(this.getCurrentStudy(), filter, ViewNotesSortCriteria.buildFilterCriteria((SortSet)limit.getSortSet()));
        HashMap eventCrfCache = new HashMap();
        for (DiscrepancyNoteBean discrepancyNoteBean : items) {
            discrepancyNoteBean.setCrfStatus(this.getCrfStatus(eventCrfCache, discrepancyNoteBean));
        }
        return items;
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)this.getLocale());
        this.resformat = ResourceBundleProvider.getFormatBundle((Locale)this.getLocale());
        int parentStudyId = 0;
        Limit limit = tableFacade.getLimit();
        if (!limit.isComplete()) {
            parentStudyId = this.currentStudy.getId();
            int totalRows = this.getDiscrepancyNoteDao().getSubjectDNCountWithFilter(this.getListNoteFilter(limit), Integer.valueOf(parentStudyId));
            totalRows += this.getDiscrepancyNoteDao().getStudySubjectDNCountWithFilter(this.getListNoteFilter(limit), Integer.valueOf(parentStudyId)).intValue();
            totalRows += this.getDiscrepancyNoteDao().getStudyEventDNCountWithFilter(this.getListNoteFilter(limit), Integer.valueOf(parentStudyId)).intValue();
            totalRows += this.getDiscrepancyNoteDao().getEventCrfDNCountWithFilter(this.getListNoteFilter(limit), Integer.valueOf(parentStudyId)).intValue();
            tableFacade.setTotalRows(totalRows += this.getDiscrepancyNoteDao().getItemDataDNCountWithFilter(this.getListNoteFilter(limit), Integer.valueOf(parentStudyId)).intValue());
        }
        ViewNotesFilterCriteria filter = ViewNotesFilterCriteria.buildFilterCriteria((Limit)limit, (String)this.getDateFormat(), (Map)this.discrepancyNoteTypeDropdown.getDecoder(), (Map)this.resolutionStatusDropdown.getDecoder());
        this.notesSummary = this.getViewNotesService().calculateNotesSummary(this.getCurrentStudy(), filter);
        int pageSize = limit.getRowSelect().getMaxRows();
        int firstRecordShown = (limit.getRowSelect().getPage() - 1) * pageSize;
        if (firstRecordShown > this.notesSummary.getTotal() && this.notesSummary.getTotal() != 0) {
            limit.getRowSelect().setPage((int)Math.ceil((double)this.notesSummary.getTotal() / (double)pageSize));
            filter = ViewNotesFilterCriteria.buildFilterCriteria((Limit)limit, (String)this.getDateFormat(), (Map)this.discrepancyNoteTypeDropdown.getDecoder(), (Map)this.resolutionStatusDropdown.getDecoder());
        }
        List items = this.getViewNotesService().listNotes(this.getCurrentStudy(), filter, ViewNotesSortCriteria.buildFilterCriteria((SortSet)limit.getSortSet()));
        this.setAllNotes(items);
        ArrayList theItems = new ArrayList();
        HashMap eventCrfCache = new HashMap();
        for (DiscrepancyNoteBean discrepancyNoteBean : items) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("studySubject", discrepancyNoteBean.getStudySub());
            h.put("studySubject.label", discrepancyNoteBean.getStudySub().getLabel());
            h.put("discrepancyNoteBean.disType", discrepancyNoteBean.getDisType());
            h.put("discrepancyNoteBean.resolutionStatus", discrepancyNoteBean.getResStatus());
            h.put("age", discrepancyNoteBean.getAge());
            h.put("days", discrepancyNoteBean.getDays());
            h.put("siteId", discrepancyNoteBean.getSiteId());
            h.put("discrepancyNoteBean", discrepancyNoteBean);
            h.put("discrepancyNoteBean.createdDate", discrepancyNoteBean.getCreatedDate());
            h.put("discrepancyNoteBean.updatedDate", discrepancyNoteBean.getUpdatedDate());
            h.put("eventName", discrepancyNoteBean.getEventName());
            h.put("eventStartDate", discrepancyNoteBean.getEventStart());
            h.put("crfName", discrepancyNoteBean.getCrfName());
            h.put("crfStatus", this.getCrfStatus(eventCrfCache, discrepancyNoteBean));
            h.put("entityName", discrepancyNoteBean.getEntityName());
            h.put("entityValue", discrepancyNoteBean.getEntityValue());
            h.put("discrepancyNoteBean", discrepancyNoteBean);
            h.put("discrepancyNoteBean.description", discrepancyNoteBean.getDescription());
            h.put("discrepancyNoteBean.detailedNotes", discrepancyNoteBean.getDetailedNotes());
            h.put("numberOfNotes", discrepancyNoteBean.getNumChildren());
            h.put("discrepancyNoteBean.user", discrepancyNoteBean.getAssignedUser());
            h.put("discrepancyNoteBean.entityType", discrepancyNoteBean.getEntityType());
            h.put("discrepancyNoteBean.owner", discrepancyNoteBean.getOwner());
            theItems.add(h);
            this.setStudyHasDiscNotes(Boolean.valueOf(true));
        }
        tableFacade.setItems(theItems);
        tableFacade.getCoreContext().setPageItems(theItems);
    }

    public TableFacade getTableFacadeImpl(HttpServletRequest request, HttpServletResponse response) {
        TableFacade facade = super.getTableFacadeImpl(request, response);
        facade.autoFilterAndSort(false);
        return facade;
    }

    public ListNotesFilter getListNoteFilter(Limit limit) {
        ListNotesFilter listNotesFilter = new ListNotesFilter();
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            ResourceBundle reterm;
            String property = filter.getProperty();
            String value = filter.getValue();
            if ("discrepancyNoteBean.createdDate".equalsIgnoreCase(property) || "discrepancyNoteBean.updatedDate".equalsIgnoreCase(property)) {
                try {
                    String date;
                    value = date = this.formatDate(new Date(value));
                }
                catch (Exception ex) {
                    value = "01-Jan-1700";
                }
            } else if ("discrepancyNoteBean.disType".equalsIgnoreCase(property)) {
                reterm = ResourceBundleProvider.getTermsBundle();
                value = reterm.getString("Query_and_Failed_Validation_Check").equals(value) ? "31" : DiscrepancyNoteType.getByName((String)value).getId() + "";
            } else if ("discrepancyNoteBean.resolutionStatus".equalsIgnoreCase(property)) {
                reterm = ResourceBundleProvider.getTermsBundle();
                value = reterm.getString("New_and_Updated").equalsIgnoreCase(value) ? "21" : ResolutionStatus.getByName((String)value).getId() + "";
            }
            listNotesFilter.addFilter(property, (Object)value);
        }
        return listNotesFilter;
    }

    protected ListNotesSort getListSubjectSort(Limit limit) {
        ListNotesSort listNotesSort = new ListNotesSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            listNotesSort.addSort(property, order);
        }
        return listNotesSort;
    }

    public AuditUserLoginDao getAuditUserLoginDao() {
        return this.auditUserLoginDao;
    }

    public void setAuditUserLoginDao(AuditUserLoginDao auditUserLoginDao) {
        this.auditUserLoginDao = auditUserLoginDao;
    }

    private String downloadNotesLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        if (this.isStudyHasDiscNotes().booleanValue()) {
            if (this.getResolutionStatus() >= 1 && this.getResolutionStatus() <= 5) {
                actionLink.a().href("javascript:openDocWindow('ChooseDownloadFormat?subjectId=" + studySubject.getId() + "&discNoteType=" + this.discNoteType + "&resolutionStatus=" + this.resolutionStatus + "')");
                actionLink.img().name("bt_View1").src("images/bt_Download.gif").border("0").alt(this.resword.getString("download_discrepancy_notes")).title(this.resword.getString("download_discrepancy_notes")).append((Object)"hspace=\"4\" width=\"24 \" height=\"15\"").end().aEnd();
                actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
            } else {
                actionLink.a().href("javascript:openDocWindow('ChooseDownloadFormat?subjectId=" + studySubject.getId() + "&discNoteType=" + this.discNoteType + "&module=" + this.module + "')");
                actionLink.img().name("bt_View1").src("images/bt_Download.gif").border("0").alt(this.resword.getString("download_discrepancy_notes")).title(this.resword.getString("download_discrepancy_notes")).append((Object)"hspace=\"2\" width=\"24 \" height=\"15\"").end().aEnd();
                actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
            }
        }
        return actionLink.toString();
    }

    private String formatDate(Date date) {
        String format = this.resformat.getString("date_format_string");
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    private String getDateFormat() {
        return this.resformat.getString("date_format_string");
    }

    public StudySubjectDAO getStudySubjectDao() {
        return this.studySubjectDao;
    }

    public void setStudySubjectDao(StudySubjectDAO studySubjectDao) {
        this.studySubjectDao = studySubjectDao;
    }

    public SubjectDAO getSubjectDao() {
        return this.subjectDao;
    }

    public void setSubjectDao(SubjectDAO subjectDao) {
        this.subjectDao = subjectDao;
    }

    public StudyDAO getStudyDao() {
        return this.studyDao;
    }

    public void setStudyDao(StudyDAO studyDao) {
        this.studyDao = studyDao;
    }

    public StudyBean getCurrentStudy() {
        return this.currentStudy;
    }

    public void setCurrentStudy(StudyBean currentStudy) {
        this.currentStudy = currentStudy;
    }

    public UserAccountDAO getUserAccountDao() {
        return this.userAccountDao;
    }

    public void setUserAccountDao(UserAccountDAO userAccountDao) {
        this.userAccountDao = userAccountDao;
    }

    public DiscrepancyNoteDAO getDiscrepancyNoteDao() {
        return this.discrepancyNoteDao;
    }

    public void setDiscrepancyNoteDao(DiscrepancyNoteDAO discrepancyNoteDao) {
        this.discrepancyNoteDao = discrepancyNoteDao;
    }

    public CRFVersionDAO getCrfVersionDao() {
        return this.crfVersionDao;
    }

    public void setCrfVersionDao(CRFVersionDAO crfVersionDao) {
        this.crfVersionDao = crfVersionDao;
    }

    public CRFDAO getCrfDao() {
        return this.crfDao;
    }

    public void setCrfDao(CRFDAO crfDao) {
        this.crfDao = crfDao;
    }

    public StudyEventDAO getStudyEventDao() {
        return this.studyEventDao;
    }

    public void setStudyEventDao(StudyEventDAO studyEventDao) {
        this.studyEventDao = studyEventDao;
    }

    public EventDefinitionCRFDAO getEventDefinitionCRFDao() {
        return this.eventDefinitionCRFDao;
    }

    public void setEventDefinitionCRFDao(EventDefinitionCRFDAO eventDefinitionCRFDao) {
        this.eventDefinitionCRFDao = eventDefinitionCRFDao;
    }

    public ItemDataDAO getItemDataDao() {
        return this.itemDataDao;
    }

    public void setItemDataDao(ItemDataDAO itemDataDao) {
        this.itemDataDao = itemDataDao;
    }

    public ItemDAO getItemDao() {
        return this.itemDao;
    }

    public void setItemDao(ItemDAO itemDao) {
        this.itemDao = itemDao;
    }

    public EventCRFDAO getEventCRFDao() {
        return this.eventCRFDao;
    }

    public void setEventCRFDao(EventCRFDAO eventCRFDao) {
        this.eventCRFDao = eventCRFDao;
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        return this.studyEventDefinitionDao;
    }

    public void setStudyEventDefinitionDao(StudyEventDefinitionDAO studyEventDefinitionDao) {
        this.studyEventDefinitionDao = studyEventDefinitionDao;
    }

    public List<DiscrepancyNoteBean> getAllNotes() {
        return this.allNotes;
    }

    public void setAllNotes(List<DiscrepancyNoteBean> allNotes) {
        this.allNotes = allNotes;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public Integer getDiscNoteType() {
        return this.discNoteType;
    }

    public void setDiscNoteType(Integer discNoteType) {
        this.discNoteType = discNoteType;
    }

    public Boolean isStudyHasDiscNotes() {
        return this.studyHasDiscNotes;
    }

    public void setStudyHasDiscNotes(Boolean studyHasDiscNotes) {
        this.studyHasDiscNotes = studyHasDiscNotes;
    }

    public Integer getResolutionStatus() {
        return this.resolutionStatus;
    }

    public void setResolutionStatus(Integer resolutionStatus) {
        this.resolutionStatus = resolutionStatus;
    }

    public ViewNotesService getViewNotesService() {
        return this.viewNotesService;
    }

    public void setViewNotesService(ViewNotesService viewNotesService) {
        this.viewNotesService = viewNotesService;
    }

    public DiscrepancyNotesSummary getNotesSummary() {
        return this.notesSummary;
    }

    private String getCrfStatus(Map<Integer, EventCRFBean> eventCrfCache, DiscrepancyNoteBean discrepancyNoteBean) {
        EventCRFBean eventCrf;
        int event_crf_id = discrepancyNoteBean.getEventCRFId();
        if (eventCrfCache.containsKey(event_crf_id)) {
            eventCrf = eventCrfCache.get(event_crf_id);
        } else {
            eventCrf = (EventCRFBean)this.getEventCRFDao().findByPK(event_crf_id);
            eventCrf.setStudyEvent((StudyEventBean)this.getStudyEventDao().findByPK(eventCrf.getStudyEventId()));
            eventCrfCache.put(event_crf_id, eventCrf);
        }
        SubjectEventStatus status = eventCrf.getStudyEvent().getSubjectEventStatus();
        if (status.equals((Term)SubjectEventStatus.LOCKED) || status.equals((Term)SubjectEventStatus.SKIPPED) || status.equals((Term)SubjectEventStatus.STOPPED)) {
            eventCrf.setStage(DataEntryStage.LOCKED);
        }
        return eventCrf.getStage().getName();
    }

    static /* synthetic */ ResourceBundle access$600(ListNotesTableFactory x0) {
        return x0.resword;
    }

    static /* synthetic */ Logger access$700(ListNotesTableFactory x0) {
        return x0.logger;
    }

    static /* synthetic */ StudyBean access$800(ListNotesTableFactory x0) {
        return x0.currentStudy;
    }

    static /* synthetic */ String access$900(ListNotesTableFactory x0, StudySubjectBean x1) {
        return x0.downloadNotesLinkBuilder(x1);
    }
}

