/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.control.ListStudyView;
import org.akaza.openclinica.control.submit.ListStudySubjectTableFactory;
import org.akaza.openclinica.control.submit.ListStudySubjectTableToolbar;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.FindSubjectsFilter;
import org.akaza.openclinica.dao.managestudy.FindSubjectsSort;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.View;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.HtmlBuilder;
import org.jmesa.view.html.toolbar.Toolbar;
import org.springframework.web.util.WebUtils;

public class ListStudySubjectTableFactory
extends AbstractTableFactory {
    private StudyEventDefinitionDAO studyEventDefinitionDao;
    private StudySubjectDAO studySubjectDAO;
    private SubjectDAO subjectDAO;
    private StudyEventDAO studyEventDAO;
    private StudyGroupClassDAO studyGroupClassDAO;
    private SubjectGroupMapDAO subjectGroupMapDAO;
    private StudyGroupDAO studyGroupDAO;
    private StudyDAO studyDAO;
    private EventCRFDAO eventCRFDAO;
    private EventDefinitionCRFDAO eventDefintionCRFDAO;
    private HttpSession session;
    private StudyBean studyBean;
    private String[] columnNames = new String[0];
    private ArrayList<StudyEventDefinitionBean> studyEventDefinitions;
    private ArrayList<StudyGroupClassBean> studyGroupClasses;
    private StudyUserRoleBean currentRole;
    private UserAccountBean currentUser;
    private final boolean showMoreLink;
    private ResourceBundle resword;
    private ResourceBundle resformat;
    private final ResourceBundle resterms = ResourceBundleProvider.getTermsBundle();
    private StudyParameterValueDAO studyParameterValueDAO;
    private ParticipantPortalRegistrar participantPortalRegistrar;
    final HashMap<Integer, String> imageIconPaths = new HashMap(8);

    public TableFacade createTable(HttpServletRequest request, HttpServletResponse response) {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        this.session = request.getSession();
        TableFacade tableFacade = this.getTableFacadeImpl(request, response);
        tableFacade.setStateAttr("restore");
        try {
            String maxrows = WebUtils.findParameterValue((ServletRequest)request, (String)"maxRows");
            Integer.parseInt(maxrows);
            Cookie cookie = new Cookie("maxrows", maxrows);
            cookie.setMaxAge(604800);
            response.addCookie(cookie);
        }
        catch (Exception maxrows) {
            // empty catch block
        }
        try {
            tableFacade.setMaxRows(Integer.parseInt(WebUtils.getCookie((HttpServletRequest)request, (String)"maxrows").getValue()));
        }
        catch (Exception e) {
            tableFacade.setMaxRows(50);
        }
        this.setDataAndLimitVariables(tableFacade);
        this.configureTableFacade(response, tableFacade);
        if (!tableFacade.getLimit().isExported()) {
            this.configureColumns(tableFacade, this.locale);
            tableFacade.setMaxRowsIncrements(this.getMaxRowIncrements());
            this.configureTableFacadePostColumnConfiguration(tableFacade);
            this.configureTableFacadeCustomView(tableFacade, request);
            this.configureUnexportedTable(tableFacade, this.locale);
        } else {
            this.configureExportColumns(tableFacade, this.locale);
        }
        return tableFacade;
    }

    public ListStudySubjectTableFactory(boolean showMoreLink) {
        this.imageIconPaths.put(1, "images/icon_Scheduled.gif");
        this.imageIconPaths.put(2, "images/icon_NotStarted.gif");
        this.imageIconPaths.put(3, "images/icon_InitialDE.gif");
        this.imageIconPaths.put(4, "images/icon_DEcomplete.gif");
        this.imageIconPaths.put(5, "images/icon_Stopped.gif");
        this.imageIconPaths.put(6, "images/icon_Skipped.gif");
        this.imageIconPaths.put(7, "images/icon_Locked.gif");
        this.imageIconPaths.put(8, "images/icon_Signed.gif");
        this.showMoreLink = showMoreLink;
    }

    protected String getTableName() {
        return "findSubjects";
    }

    public void configureTableFacadeCustomView(TableFacade tableFacade, HttpServletRequest request) {
        tableFacade.setView((View)new ListStudyView(this.getLocale(), request));
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        int i;
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        this.resformat = ResourceBundleProvider.getFormatBundle((Locale)locale);
        tableFacade.setColumnProperties(this.columnNames);
        Row row = tableFacade.getTable().getRow();
        int index = 0;
        this.configureColumn(row.getColumn(this.columnNames[index]), this.resword.getString("study_subject_ID"), (CellEditor)new SubjectEditor(this, null), null);
        this.configureColumn(row.getColumn(this.columnNames[++index]), this.resword.getString("subject_status"), (CellEditor)new StatusCellEditor(this, null), (FilterEditor)new StatusDroplistFilterEditor(this, null));
        this.configureColumn(row.getColumn(this.columnNames[++index]), this.resword.getString("site_id"), null, null);
        this.configureColumn(row.getColumn(this.columnNames[++index]), this.resword.getString("rule_oid"), null, null);
        this.configureColumn(row.getColumn(this.columnNames[++index]), this.resword.getString("gender"), null, null, true, false);
        this.configureColumn(row.getColumn(this.columnNames[++index]), this.resword.getString("secondary_ID"), null, null);
        for (i = ++index; i < index + this.studyGroupClasses.size(); ++i) {
            StudyGroupClassBean studyGroupClass = (StudyGroupClassBean)this.studyGroupClasses.get(i - index);
            this.configureColumn(row.getColumn(this.columnNames[i]), studyGroupClass.getName(), (CellEditor)new StudyGroupClassCellEditor(this, studyGroupClass), (FilterEditor)new SubjectGroupClassDroplistFilterEditor(this, studyGroupClass), true, false);
        }
        for (i = index + this.studyGroupClasses.size(); i < this.columnNames.length - 1; ++i) {
            StudyEventDefinitionBean studyEventDefinition = (StudyEventDefinitionBean)this.studyEventDefinitions.get(i - (index + this.studyGroupClasses.size()));
            this.configureColumn(row.getColumn(this.columnNames[i]), studyEventDefinition.getName(), (CellEditor)new StudyEventDefinitionMapCellEditor(this, null), (FilterEditor)new SubjectEventStatusDroplistFilterEditor(this, null), true, false);
        }
        String actionsHeader = this.resword.getString("rule_actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;";
        this.configureColumn(row.getColumn(this.columnNames[this.columnNames.length - 1]), actionsHeader, (CellEditor)new ActionsCellEditor(this, null), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        int i;
        super.configureTableFacade(response, tableFacade);
        this.getColumnNamesMap();
        tableFacade.addFilterMatcher(new MatcherKey(Character.class), (FilterMatcher)new CharFilterMatcher(this, null));
        tableFacade.addFilterMatcher(new MatcherKey(Status.class), (FilterMatcher)new StatusFilterMatcher(this));
        for (i = 6; i < 6 + this.studyGroupClasses.size(); ++i) {
            tableFacade.addFilterMatcher(new MatcherKey(Integer.class, this.columnNames[i]), (FilterMatcher)new SubjectGroupFilterMatcher(this));
        }
        for (i = 6 + this.studyGroupClasses.size(); i < this.columnNames.length - 1; ++i) {
            tableFacade.addFilterMatcher(new MatcherKey(Integer.class, this.columnNames[i]), (FilterMatcher)new SubjectEventStatusFilterMatcher(this));
        }
    }

    public void configureTableFacadePostColumnConfiguration(TableFacade tableFacade) {
        Role r = this.currentRole.getRole();
        boolean addSubjectLinkShow = this.studyBean.getStatus().isAvailable() && !r.equals((Term)Role.MONITOR);
        tableFacade.setToolbar((Toolbar)new ListStudySubjectTableToolbar(this.getStudyEventDefinitions(), this.getStudyGroupClasses(), addSubjectLinkShow, this.showMoreLink));
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        Limit limit = tableFacade.getLimit();
        FindSubjectsFilter subjectFilter = this.getSubjectFilter(limit);
        if (!limit.isComplete()) {
            int totalRows = this.getStudySubjectDAO().getCountWithFilter(subjectFilter, this.getStudyBean());
            tableFacade.setTotalRows(totalRows);
        }
        FindSubjectsSort subjectSort = this.getSubjectSort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        ArrayList items = this.getStudySubjectDAO().getWithFilterAndSort(this.getStudyBean(), subjectFilter, subjectSort, rowStart, rowEnd);
        ArrayList theItems = new ArrayList();
        for (StudySubjectBean studySubjectBean : items) {
            SubjectGroupMapBean subjectGroupMapBean;
            HashMap<String, Object> theItem = new HashMap<String, Object>();
            theItem.put("studySubject", studySubjectBean);
            theItem.put("studySubject.label", studySubjectBean.getLabel());
            theItem.put("studySubject.status", studySubjectBean.getStatus());
            theItem.put("enrolledAt", ((StudyBean)this.getStudyDAO().findByPK(studySubjectBean.getStudyId())).getIdentifier());
            theItem.put("studySubject.oid", studySubjectBean.getOid());
            theItem.put("studySubject.secondaryLabel", studySubjectBean.getSecondaryLabel());
            SubjectBean subjectBean = (SubjectBean)this.getSubjectDAO().findByPK(studySubjectBean.getSubjectId());
            theItem.put("subject", subjectBean);
            theItem.put("subject.charGender", Character.valueOf(subjectBean.getGender()));
            ArrayList allStudyEventsForStudySubject = this.getStudyEventDAO().findAllByStudySubject(studySubjectBean);
            HashMap allStudyEventsForStudySubjectBySedId = new HashMap();
            theItem.put("isSignable", this.isSignable((List)allStudyEventsForStudySubject, studySubjectBean));
            for (StudyEventBean studyEventBean : allStudyEventsForStudySubject) {
                if (allStudyEventsForStudySubjectBySedId.get(studyEventBean.getStudyEventDefinitionId()) == null) {
                    ArrayList<StudyEventBean> a = new ArrayList<StudyEventBean>();
                    a.add(studyEventBean);
                    allStudyEventsForStudySubjectBySedId.put(studyEventBean.getStudyEventDefinitionId(), a);
                    continue;
                }
                ((List)allStudyEventsForStudySubjectBySedId.get(studyEventBean.getStudyEventDefinitionId())).add(studyEventBean);
            }
            for (StudyGroupClassBean studyGroupClass : this.getStudyGroupClasses()) {
                subjectGroupMapBean = this.getSubjectGroupMapDAO().findAllByStudySubjectAndStudyGroupClass(studySubjectBean.getId(), studyGroupClass.getId());
                if (null == subjectGroupMapBean) continue;
                theItem.put("sgc_" + studyGroupClass.getId(), subjectGroupMapBean.getStudyGroupId());
                theItem.put("grpName_sgc_" + studyGroupClass.getId(), subjectGroupMapBean.getStudyGroupName());
            }
            subjectGroupMapBean = null;
            for (StudyEventDefinitionBean studyEventDefinition : this.getStudyEventDefinitions()) {
                List studyEvents = (List)allStudyEventsForStudySubjectBySedId.get(studyEventDefinition.getId());
                SubjectEventStatus subjectEventStatus = null;
                List list = studyEvents = studyEvents == null ? new ArrayList() : studyEvents;
                if (studyEvents.size() < 1) {
                    subjectEventStatus = SubjectEventStatus.NOT_SCHEDULED;
                } else {
                    for (StudyEventBean studyEventBean : studyEvents) {
                        if (studyEventBean.getSampleOrdinal() != 1) continue;
                        subjectEventStatus = studyEventBean.getSubjectEventStatus();
                        break;
                    }
                }
                theItem.put("sed_" + studyEventDefinition.getId(), subjectEventStatus.getId());
                theItem.put("sed_" + studyEventDefinition.getId() + "_studyEvents", studyEvents);
                theItem.put("sed_" + studyEventDefinition.getId() + "_object", studyEventDefinition);
            }
            theItems.add(theItem);
        }
        tableFacade.setItems(theItems);
    }

    private Boolean isSignable(List<StudyEventBean> allStudyEventsForStudySubject, StudySubjectBean studySubjectBean) {
        boolean isSignable = true;
        if (studySubjectBean.getStatus().isSigned()) {
            return false;
        }
        for (StudyEventBean studyEventBean : allStudyEventsForStudySubject) {
            if (studyEventBean.getSubjectEventStatus() == SubjectEventStatus.DATA_ENTRY_STARTED || studyEventBean.getSubjectEventStatus() == SubjectEventStatus.SCHEDULED) {
                isSignable = false;
                break;
            }
            boolean isRequiredUncomplete = this.eventHasRequiredUncompleteCRFs(studyEventBean);
            if (!isRequiredUncomplete) continue;
            isSignable = false;
            break;
        }
        return isSignable;
    }

    private boolean eventHasRequiredUncompleteCRFs(StudyEventBean studyEventBean) {
        ArrayList eventCrfBeans = new ArrayList();
        eventCrfBeans.addAll(this.getEventCRFDAO().findAllByStudyEvent(studyEventBean));
        for (EventCRFBean crfBean : eventCrfBeans) {
            if (crfBean == null || crfBean.getCompletionStatusId() != 0 || !this.getEventDefintionCRFDAO().isRequiredInDefinition(crfBean.getCRFVersionId(), studyEventBean)) continue;
            return true;
        }
        return false;
    }

    private void getColumnNames() {
        ArrayList<String> columnNamesList = new ArrayList<String>();
        columnNamesList.add("label");
        columnNamesList.add("status");
        columnNamesList.add("enrolledAt");
        columnNamesList.add("oid");
        columnNamesList.add("subject.charGender");
        columnNamesList.add("secondaryLabel");
        for (StudyGroupClassBean studyGroupClass : this.getStudyGroupClasses()) {
            columnNamesList.add("sgc_" + studyGroupClass.getId());
        }
        for (StudyEventDefinitionBean studyEventDefinition : this.getStudyEventDefinitions()) {
            columnNamesList.add("sed_" + studyEventDefinition.getId());
        }
        columnNamesList.add("actions");
        this.columnNames = columnNamesList.toArray(this.columnNames);
    }

    private void getColumnNamesMap() {
        ArrayList<String> columnNamesList = new ArrayList<String>();
        columnNamesList.add("studySubject.label");
        columnNamesList.add("studySubject.status");
        columnNamesList.add("enrolledAt");
        columnNamesList.add("studySubject.oid");
        columnNamesList.add("subject.charGender");
        columnNamesList.add("studySubject.secondaryLabel");
        for (StudyGroupClassBean studyGroupClass : this.getStudyGroupClasses()) {
            columnNamesList.add("sgc_" + studyGroupClass.getId());
        }
        for (StudyEventDefinitionBean studyEventDefinition : this.getStudyEventDefinitions()) {
            columnNamesList.add("sed_" + studyEventDefinition.getId());
        }
        columnNamesList.add("actions");
        this.columnNames = columnNamesList.toArray(this.columnNames);
    }

    protected FindSubjectsFilter getSubjectFilter(Limit limit) {
        FindSubjectsFilter auditUserLoginFilter = new FindSubjectsFilter();
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            String property = filter.getProperty();
            String value = filter.getValue();
            if ("studySubject.status".equalsIgnoreCase(property)) {
                value = Status.getByName((String)value).getId() + "";
            } else if (property.startsWith("sgc_")) {
                int studyGroupClassId = property.endsWith("_") ? 0 : Integer.valueOf(property.split("_")[1]);
                value = this.studyGroupDAO.findByNameAndGroupClassID(value, studyGroupClassId).getId() + "";
            }
            auditUserLoginFilter.addFilter(property, (Object)value);
        }
        return auditUserLoginFilter;
    }

    protected FindSubjectsSort getSubjectSort(Limit limit) {
        FindSubjectsSort auditUserLoginSort = new FindSubjectsSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            auditUserLoginSort.addSort(property, order);
        }
        return auditUserLoginSort;
    }

    private ArrayList<StudyEventDefinitionBean> getStudyEventDefinitions() {
        if (this.studyEventDefinitions == null) {
            this.studyEventDefinitions = this.studyBean.getParentStudyId() > 0 ? this.getStudyEventDefinitionDao().findAllActiveByParentStudyId(this.studyBean.getParentStudyId()) : this.getStudyEventDefinitionDao().findAllActiveByParentStudyId(this.studyBean.getId());
        }
        return this.studyEventDefinitions;
    }

    private ArrayList<StudyGroupClassBean> getStudyGroupClasses() {
        if (this.studyGroupClasses == null) {
            if (this.studyBean.getParentStudyId() > 0) {
                StudyBean parentStudy = (StudyBean)this.getStudyDAO().findByPK(this.studyBean.getParentStudyId());
                this.studyGroupClasses = this.getStudyGroupClassDAO().findAllActiveByStudy(parentStudy);
            } else {
                this.studyGroupClasses = this.getStudyGroupClassDAO().findAllActiveByStudy(this.studyBean);
            }
        }
        return this.studyGroupClasses;
    }

    public StudyParameterValueDAO getStudyParameterValueDAO() {
        return this.studyParameterValueDAO;
    }

    public void setStudyParameterValueDAO(StudyParameterValueDAO studyParameterValueDAO) {
        this.studyParameterValueDAO = studyParameterValueDAO;
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        return this.studyEventDefinitionDao;
    }

    public void setStudyEventDefinitionDao(StudyEventDefinitionDAO studyEventDefinitionDao) {
        this.studyEventDefinitionDao = studyEventDefinitionDao;
    }

    public StudyBean getStudyBean() {
        return this.studyBean;
    }

    public void setStudyBean(StudyBean studyBean) {
        this.studyBean = studyBean;
    }

    public StudySubjectDAO getStudySubjectDAO() {
        return this.studySubjectDAO;
    }

    public void setStudySubjectDAO(StudySubjectDAO studySubjectDAO) {
        this.studySubjectDAO = studySubjectDAO;
    }

    public SubjectDAO getSubjectDAO() {
        return this.subjectDAO;
    }

    public void setSubjectDAO(SubjectDAO subjectDAO) {
        this.subjectDAO = subjectDAO;
    }

    public StudyEventDAO getStudyEventDAO() {
        return this.studyEventDAO;
    }

    public void setStudyEventDAO(StudyEventDAO studyEventDAO) {
        this.studyEventDAO = studyEventDAO;
    }

    public StudyGroupClassDAO getStudyGroupClassDAO() {
        return this.studyGroupClassDAO;
    }

    public void setStudyGroupClassDAO(StudyGroupClassDAO studyGroupClassDAO) {
        this.studyGroupClassDAO = studyGroupClassDAO;
    }

    public SubjectGroupMapDAO getSubjectGroupMapDAO() {
        return this.subjectGroupMapDAO;
    }

    public void setSubjectGroupMapDAO(SubjectGroupMapDAO subjectGroupMapDAO) {
        this.subjectGroupMapDAO = subjectGroupMapDAO;
    }

    public StudyDAO getStudyDAO() {
        return this.studyDAO;
    }

    public void setStudyDAO(StudyDAO studyDAO) {
        this.studyDAO = studyDAO;
    }

    public StudyUserRoleBean getCurrentRole() {
        return this.currentRole;
    }

    public void setCurrentRole(StudyUserRoleBean currentRole) {
        this.currentRole = currentRole;
    }

    public EventCRFDAO getEventCRFDAO() {
        return this.eventCRFDAO;
    }

    public void setEventCRFDAO(EventCRFDAO eventCRFDAO) {
        this.eventCRFDAO = eventCRFDAO;
    }

    public EventDefinitionCRFDAO getEventDefintionCRFDAO() {
        return this.eventDefintionCRFDAO;
    }

    public void setEventDefintionCRFDAO(EventDefinitionCRFDAO eventDefintionCRFDAO) {
        this.eventDefintionCRFDAO = eventDefintionCRFDAO;
    }

    public StudyGroupDAO getStudyGroupDAO() {
        return this.studyGroupDAO;
    }

    public void setStudyGroupDAO(StudyGroupDAO studyGroupDAO) {
        this.studyGroupDAO = studyGroupDAO;
    }

    public UserAccountBean getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(UserAccountBean currentUser) {
        this.currentUser = currentUser;
    }

    private String participateStatus(StudySubjectBean studySubjectBean) {
        StudyBean study = (StudyBean)this.studyDAO.findByPK(studySubjectBean.getStudyId());
        StudyBean pStudy = this.getParentStudy(study.getOid());
        String participateFormStatus = this.getStudyParameterValueDAO().findByHandleAndStudy(pStudy.getId(), "participantPortal").getValue();
        return participateFormStatus;
    }

    private String pManageStatus(StudySubjectBean studySubjectBean) throws Exception {
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        StudyBean study = (StudyBean)this.studyDAO.findByPK(studySubjectBean.getStudyId());
        StudyBean pStudy = this.getParentStudy(study.getOid());
        String pManageStatus = this.participantPortalRegistrar.getCachedRegistrationStatus(pStudy.getOid(), this.session).toString();
        return pManageStatus;
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = (StudyBean)this.studyDAO.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private StudyBean getStudy(String oid) {
        StudyBean studyBean = this.studyDAO.findByOid(oid);
        return studyBean;
    }

    private String viewStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("ViewStudySubject?id=" + studySubject.getId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_View1','images/bt_View_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_View1','images/bt_View.gif');\"").close();
        actionLink.img().name("bt_View1").src("images/bt_View.gif").border("0").alt(this.resword.getString("view")).title(this.resword.getString("view")).append((Object)"hspace=\"2\"").end().aEnd();
        actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        return actionLink.toString();
    }

    private String viewParticipateBuilder(StudySubjectBean studySubject) throws Exception {
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        StudyBean study = (StudyBean)this.studyDAO.findByPK(studySubject.getStudyId());
        StudyBean pStudy = this.getParentStudy(study.getOid());
        String url = this.participantPortalRegistrar.getStudyHost(pStudy.getOid());
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href(url + "?ssid=" + URLEncoder.encode(studySubject.getLabel(), "UTF-8"));
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_Participate1','images/bt_Ocui_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_Participate1','images/bt_Ocui.gif');\"").close();
        actionLink.img().name("bt_Participate1").src("images/bt_Ocui.gif").border("0").alt(this.resword.getString("connect_participant")).title(this.resword.getString("connect_participant")).append((Object)"hspace=\"2\"").end().aEnd();
        actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        return actionLink.toString();
    }

    private String removeStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("RemoveStudySubject?action=confirm&id=" + studySubject.getId() + "&subjectId=" + studySubject.getSubjectId() + "&studyId=" + studySubject.getStudyId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_Remove1','images/bt_Remove_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_Remove1','images/bt_Remove.gif');\"").close();
        actionLink.img().name("bt_Remove1").src("images/bt_Remove.gif").border("0").alt(this.resword.getString("remove")).title(this.resword.getString("remove")).append((Object)"hspace=\"2\"").end().aEnd();
        actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        return actionLink.toString();
    }

    private String signStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("SignStudySubject?id=" + studySubject.getId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('icon_signed','images/icon_Signed.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('icon_signed','images/icon_Signed.gif');\"").close();
        actionLink.img().name("bt_Sign1").src("images/icon_Signed.gif").border("0").alt(this.resword.getString("sign")).title(this.resword.getString("sign")).append((Object)"hspace=\"2\"").end().aEnd();
        actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        return actionLink.toString();
    }

    private String reAssignStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("ReassignStudySubject?id=" + studySubject.getId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_Reassign1','images/bt_Reassign_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_Reassign1','images/bt_Reassign.gif');\"").close();
        actionLink.img().name("bt_Reassign1").src("images/bt_Reassign.gif").border("0").alt(this.resword.getString("reassign")).title(this.resword.getString("reassign")).append((Object)"hspace=\"2\"").end().aEnd();
        actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        return actionLink.toString();
    }

    private String restoreStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("RestoreStudySubject?action=confirm&id=" + studySubject.getId() + "&subjectId=" + studySubject.getSubjectId() + "&studyId=" + studySubject.getStudyId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_Restor3','images/bt_Restore_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_Restor3','images/bt_Restore_d.gif');\"").close();
        actionLink.img().name("bt_Restore1").src("images/bt_Restore.gif").border("0").alt(this.resword.getString("restore")).title(this.resword.getString("restore")).append((Object)"hspace=\"2\"").end().aEnd();
        return actionLink.toString();
    }

    private String eventDivBuilder(SubjectBean subject, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed, StudySubjectBean studySubject) {
        String studySubjectLabel = studySubject.getLabel();
        String divWidth = studyEvents.size() >= 3 ? "565" : (studyEvents.size() == 2 ? "395" : "180");
        HtmlBuilder eventDiv = new HtmlBuilder();
        eventDiv.table(0).border("0").cellpadding("0").cellspacing("0").close();
        eventDiv.div().id("Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("position: absolute; visibility: hidden; z-index: 3; width: 50px; height: 30px; top: 0px;").close();
        if (studyEvents.size() > 1) {
            this.repeatingLockLinkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
        } else {
            this.lockLinkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
        }
        eventDiv.divEnd();
        eventDiv.tr(0).valign("top").close().td(0).close();
        eventDiv.div().id("Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("position: absolute; visibility: hidden; z-index: 3;width:" + divWidth + "px; top: 0px; float: left;").close();
        eventDiv.div().styleClass("box_T").close().div().styleClass("box_L").close().div().styleClass("box_R").close().div().styleClass("box_B").close().div().styleClass("box_TL").close().div().styleClass("box_TR").close().div().styleClass("box_BL").close().div().styleClass("box_BR").close();
        eventDiv.div().styleClass("tablebox_center").close();
        eventDiv.div().styleClass("ViewSubjectsPopup").style("color: rgb(91, 91, 91);").close();
        eventDiv.table(0).border("0").cellpadding("0").cellspacing("0").close();
        eventDiv.tr(0).valign("top").close();
        if (studyEvents.size() > 1) {
            this.repeatingEventDivBuilder(eventDiv, subject, rowCount, studyEvents, sed, studySubject);
        } else {
            this.singleEventDivBuilder(eventDiv, subject, rowCount, studyEvents, sed, studySubject);
        }
        return eventDiv.toString();
    }

    private void repeatingEventDivBuilder(HtmlBuilder eventDiv, SubjectBean subject, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed, StudySubjectBean studySubject) {
        int i;
        String tableHeaderRowStyleClass = "table_header_row";
        String tableHeaderRowLeftStyleClass = "table_header_row_left";
        String add_another_occurrence = this.resword.getString("add_another_occurrence");
        String click_for_more_options = this.resword.getString("click_for_more_options");
        String schedule = this.resword.getString("schedule");
        String view = this.resword.getString("view") + "/" + this.resword.getString("enter_data");
        String edit = this.resword.getString("edit");
        String remove = this.resword.getString("remove");
        String occurrence_x_of = this.resword.getString("ocurrence");
        String subjectText = this.resword.getString("subject");
        String eventText = this.resword.getString("event");
        String status = this.resword.getString("status");
        StudyEventBean defaultEvent = studyEvents.get(0);
        String studySubjectLabel = studySubject.getLabel();
        Status eventSysStatus = studySubject.getStatus();
        Integer studyEventsSize = studyEvents.size();
        eventDiv.td(0).styleClass(tableHeaderRowLeftStyleClass).colspan("2").close();
        eventDiv.append((Object)subjectText).append((Object)": ").append((Object)studySubjectLabel).br();
        eventDiv.append((Object)eventText).append((Object)": ").append((Object)sed.getName()).br();
        eventDiv.tdEnd();
        eventDiv.td(0).styleClass(tableHeaderRowLeftStyleClass).align("right").colspan("3").close();
        this.divCloseRepeatinglinkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
        eventDiv.br();
        if (eventSysStatus != Status.DELETED && eventSysStatus != Status.AUTO_DELETED && this.studyBean.getStatus() == Status.AVAILABLE) {
            eventDiv.span().styleClass("font-weight: normal;").close();
            eventDiv.ahref("CreateNewStudyEvent?studySubjectId=" + studySubject.getId() + "&studyEventDefinition=" + sed.getId(), add_another_occurrence);
        }
        eventDiv.nbsp().nbsp().nbsp();
        for (i = 1; i <= studyEventsSize; ++i) {
            eventDiv.ahref("javascript:StatusBoxSkip('" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'," + studyEventsSize + "," + i + ");", String.valueOf(i));
            if (i >= studyEventsSize) continue;
            eventDiv.append((Object)"|");
        }
        eventDiv.spanEnd();
        eventDiv.tdEnd().trEnd(0);
        eventDiv.tr(0).close();
        eventDiv.td(0).id("Scroll_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_back").styleClass("statusbox_scroll_L_dis").width("20").close();
        eventDiv.img().src("images/arrow_status_back_dis.gif").border("0").close();
        eventDiv.tdEnd();
        eventDiv.td(0).id("Scroll_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_back").styleClass("statusbox_scroll_L").width("20").style("display: none;").close();
        eventDiv.div().id("bt_Scroll_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_back").style("display: none;").close();
        eventDiv.a().href("javascript:StatusBoxBack('" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'," + studyEventsSize + ");").close();
        eventDiv.img().src("images/arrow_status_back.gif").border("0").close();
        eventDiv.aEnd();
        eventDiv.divEnd();
        eventDiv.div().id("bt_Scroll_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_back_dis").close();
        eventDiv.img().src("images/arrow_status_back_dis.gif").border("0").close();
        eventDiv.divEnd();
        eventDiv.tdEnd();
        for (i = 0; i < studyEvents.size(); ++i) {
            StudyEventBean studyEventBean = studyEvents.get(i);
            eventDiv.td(0).id("Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_" + (i + 1)).valign("top").width("180");
            if (i + 1 > 3) {
                eventDiv.style("display: none;");
            }
            eventDiv.close();
            eventDiv.table(0).border("0").cellpadding("0").cellspacing("0").width("100%").close();
            eventDiv.tr(0).valign("top").close();
            eventDiv.td(0).styleClass(tableHeaderRowStyleClass).colspan("2").close();
            eventDiv.bold().append((Object)occurrence_x_of).append((Object)("#" + (i + 1) + " of " + studyEventsSize)).br();
            eventDiv.append((Object)this.formatDate(studyEventBean.getDateStarted())).br();
            eventDiv.append((Object)(status + ": " + studyEventBean.getSubjectEventStatus().getName()));
            eventDiv.boldEnd().tdEnd().trEnd(0);
            eventDiv.tr(0).id("Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_" + (i + 1)).style("display: none").close();
            eventDiv.td(0).colspan("2").close();
            eventDiv.table(0).border("0").cellpadding("0").cellspacing("0").width("100%").close();
            this.linksDivBuilder(eventDiv, subject, rowCount, studyEvents, sed, studySubject, studyEventBean);
            eventDiv.tableEnd(0).tdEnd().trEnd(0);
            eventDiv.tableEnd(0);
            eventDiv.tdEnd();
        }
        eventDiv.td(0).id("Scroll_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_next").styleClass("statusbox_scroll_R_dis").width("20").close();
        eventDiv.img().src("images/arrow_status_next_dis.gif").border("0").close();
        eventDiv.tdEnd();
        eventDiv.td(0).id("Scroll_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_next").styleClass("statusbox_scroll_R").width("20").style("display: none;").close();
        eventDiv.div().id("bt_Scroll_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_next").close();
        eventDiv.a().href("javascript:StatusBoxNext('" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'," + studyEventsSize + ");").close();
        eventDiv.img().src("images/arrow_status_next.gif").border("0").close();
        eventDiv.aEnd();
        eventDiv.divEnd();
        eventDiv.div().id("bt_Scroll_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "_next_dis").style("display: none;").close();
        eventDiv.img().src("images/arrow_status_next_dis.gif").border("0").close();
        eventDiv.divEnd();
        eventDiv.tdEnd().trEnd(0);
        eventDiv.tr(0).id("Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("").close();
        eventDiv.td(0).styleClass("table_cell_left").colspan(String.valueOf(studyEventsSize)).close().append((Object)"<i>").append((Object)click_for_more_options).append((Object)"</i>").tdEnd();
        eventDiv.trEnd(0);
        eventDiv.tableEnd(0);
        eventDiv.divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd();
        this.repeatingIconLinkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
    }

    private void linksDivBuilder(HtmlBuilder eventDiv, SubjectBean subject, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed, StudySubjectBean studySubject, StudyEventBean currentEvent) {
        Status eventSysStatus = studySubject.getStatus();
        SubjectEventStatus eventStatus = currentEvent.getSubjectEventStatus();
        String studyEventId = String.valueOf(currentEvent.getId());
        String view = this.resword.getString("view") + "/" + this.resword.getString("enter_data");
        String edit = this.resword.getString("edit");
        String remove = this.resword.getString("remove");
        if (eventSysStatus.getId() == Status.AVAILABLE.getId() || eventSysStatus == Status.SIGNED) {
            if (eventStatus == SubjectEventStatus.COMPLETED) {
                eventDiv.tr(0).valign("top").close();
                eventDiv.td(0).styleClass("table_cell").close();
                this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                eventDiv.tdEnd().trEnd(0);
                if ((this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) && this.studyBean.getStatus() == Status.AVAILABLE) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell").close();
                    this.updateStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, edit);
                    eventDiv.tdEnd().trEnd(0);
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell").close();
                    this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                    eventDiv.tdEnd().trEnd(0);
                }
            } else if (eventStatus == SubjectEventStatus.LOCKED) {
                if (this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell").close();
                    this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                    eventDiv.tdEnd().trEnd(0);
                    if (this.studyBean.getStatus() == Status.AVAILABLE) {
                        eventDiv.tr(0).valign("top").close();
                        eventDiv.td(0).styleClass("table_cell").close();
                        this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                        eventDiv.tdEnd().trEnd(0);
                    }
                }
            } else {
                eventDiv.tr(0).valign("top").close();
                eventDiv.td(0).styleClass("table_cell_left");
                this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                eventDiv.tdEnd().trEnd(0);
                if ((this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) && this.studyBean.getStatus() == Status.AVAILABLE) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.updateStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, edit);
                    eventDiv.tdEnd().trEnd(0);
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                    eventDiv.tdEnd().trEnd(0);
                }
            }
        }
        if (eventSysStatus == Status.DELETED || eventSysStatus == Status.AUTO_DELETED) {
            eventDiv.tr(0).valign("top").close();
            eventDiv.td(0).styleClass("table_cell").close();
            this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
            eventDiv.tdEnd().trEnd(0);
        }
    }

    private void singleEventDivBuilder(HtmlBuilder eventDiv, SubjectBean subject, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed, StudySubjectBean studySubject) {
        String tableHeaderRowStyleClass = "table_header_row";
        String tableHeaderRowLeftStyleClass = "table_header_row_left";
        String add_another_occurrence = this.resword.getString("add_another_occurrence");
        String click_for_more_options = this.resword.getString("click_for_more_options");
        String schedule = this.resword.getString("schedule");
        String view = this.resword.getString("view") + "/" + this.resword.getString("enter_data");
        String edit = this.resword.getString("edit");
        String remove = this.resword.getString("remove");
        String occurrence_x_of = this.resword.getString("ocurrence");
        String subjectText = this.resword.getString("subject");
        String eventText = this.resword.getString("event");
        String status = this.resword.getString("status");
        SubjectEventStatus eventStatus = studyEvents.size() == 0 ? SubjectEventStatus.NOT_SCHEDULED : studyEvents.get(0).getSubjectEventStatus();
        String studyEventName = studyEvents.size() == 0 ? "" : studyEvents.get(0).getName();
        String studyEventId = studyEvents.size() == 0 ? "" : String.valueOf(studyEvents.get(0).getId());
        Status eventSysStatus = studySubject.getStatus();
        String studySubjectLabel = studySubject.getLabel();
        eventDiv.td(0).styleClass(tableHeaderRowLeftStyleClass).close();
        eventDiv.append((Object)subjectText).append((Object)": ").append((Object)studySubjectLabel).br();
        eventDiv.append((Object)eventText).append((Object)": ").append((Object)sed.getName()).br();
        if (!sed.isRepeating()) {
            eventDiv.append((Object)this.resword.getString("status")).append((Object)":").append((Object)eventStatus.getName()).br();
            eventDiv.tdEnd();
            eventDiv.td(0).styleClass(tableHeaderRowLeftStyleClass).align("right").close();
            this.linkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
            eventDiv.tdEnd();
        } else {
            eventDiv.tdEnd();
            eventDiv.td(0).styleClass(tableHeaderRowLeftStyleClass).align("right").close();
            this.linkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
            eventDiv.tdEnd();
            eventDiv.tr(0).valign("top").close();
            eventDiv.td(0).styleClass(tableHeaderRowStyleClass).colspan("2").close();
            eventDiv.bold().append((Object)occurrence_x_of).append((Object)"#1 of 1").br();
            if (studyEvents.size() > 0) {
                eventDiv.append((Object)this.formatDate(studyEvents.get(0).getDateStarted())).br();
                eventDiv.append((Object)(status + " : " + studyEvents.get(0).getSubjectEventStatus().getName()));
            } else {
                eventDiv.append((Object)(status + " : " + SubjectEventStatus.NOT_SCHEDULED.getName()));
            }
            eventDiv.boldEnd().tdEnd().trEnd(0);
            if (eventStatus != SubjectEventStatus.NOT_SCHEDULED && eventSysStatus != Status.DELETED && eventSysStatus != Status.AUTO_DELETED) {
                eventDiv.tr(0).close().td(0).styleClass("table_cell_left").close();
                eventDiv.ahref("CreateNewStudyEvent?studySubjectId=" + studySubject.getId() + "&studyEventDefinition=" + sed.getId(), add_another_occurrence);
                eventDiv.tdEnd().trEnd(0);
            }
        }
        eventDiv.trEnd(0);
        eventDiv.tr(0).id("Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("display: all").close();
        eventDiv.td(0).styleClass("table_cell_left").colspan("2").close().append((Object)"<i>").append((Object)click_for_more_options).append((Object)"</i>").tdEnd();
        eventDiv.trEnd(0);
        eventDiv.tr(0).id("Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("display: none").close();
        eventDiv.td(0).colspan("2").close();
        eventDiv.table(0).border("0").cellpadding("0").cellspacing("0").width("100%").close();
        if (eventSysStatus.getId() == Status.AVAILABLE.getId() || eventSysStatus == Status.SIGNED) {
            if (eventStatus == SubjectEventStatus.NOT_SCHEDULED && this.currentRole.getRole() != Role.MONITOR && !this.studyBean.getStatus().isFrozen()) {
                eventDiv.tr(0).valign("top").close();
                eventDiv.td(0).styleClass("table_cell_left").close();
                this.createNewStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), sed, schedule);
                eventDiv.tdEnd().trEnd(0);
            } else if (eventStatus == SubjectEventStatus.COMPLETED) {
                eventDiv.tr(0).valign("top").close();
                eventDiv.td(0).styleClass("table_cell_left").close();
                this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                eventDiv.tdEnd().trEnd(0);
                if ((this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) && this.studyBean.getStatus() == Status.AVAILABLE) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.updateStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, edit);
                    eventDiv.tdEnd().trEnd(0);
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                    eventDiv.tdEnd().trEnd(0);
                }
            } else if (eventStatus == SubjectEventStatus.LOCKED) {
                eventDiv.tdEnd().trEnd(0);
                if (this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                    eventDiv.tdEnd().trEnd(0);
                    if (this.studyBean.getStatus() == Status.AVAILABLE) {
                        eventDiv.tr(0).valign("top").close();
                        eventDiv.td(0).styleClass("table_cell_left").close();
                        this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                        eventDiv.tdEnd().trEnd(0);
                    }
                }
            } else {
                eventDiv.tr(0).valign("top").close();
                eventDiv.td(0).styleClass("table_cell_left");
                this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                eventDiv.tdEnd().trEnd(0);
                if ((this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) && this.studyBean.getStatus() == Status.AVAILABLE) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.updateStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, edit);
                    eventDiv.tdEnd().trEnd(0);
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                    eventDiv.tdEnd().trEnd(0);
                }
            }
        }
        if (eventSysStatus == Status.DELETED || eventSysStatus == Status.AUTO_DELETED) {
            eventDiv.tr(0).valign("top").close();
            eventDiv.td(0).styleClass("table_cell_left").close();
            this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
            eventDiv.tdEnd().trEnd(0);
        }
        eventDiv.tableEnd(0).tdEnd().trEnd(0);
        eventDiv.tableEnd(0);
        eventDiv.divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd();
        this.iconLinkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
    }

    private void updateStudyEventLinkBuilder(HtmlBuilder builder, Integer studySubjectId, String studyEventId, String edit) {
        String href1 = "UpdateStudyEvent?event_id=" + studyEventId + "&ss_id=" + studySubjectId;
        builder.a().href(href1);
        builder.close();
        builder.img().src("images/bt_Edit.gif").border("0").align("left").close().aEnd();
        builder.nbsp().nbsp().a().href(href1);
        builder.close().append((Object)edit).aEnd();
    }

    private void removeStudyEventLinkBuilder(HtmlBuilder builder, Integer studySubjectId, String studyEventId, String remove) {
        String href1 = "RemoveStudyEvent?action=confirm&id=" + studyEventId + "&studySubId=" + studySubjectId;
        builder.a().href(href1);
        builder.close();
        builder.img().src("images/bt_Remove.gif").border("0").align("left").close().aEnd();
        builder.nbsp().nbsp().a().href(href1);
        builder.close().append((Object)remove).aEnd();
    }

    private void createNewStudyEventLinkBuilder(HtmlBuilder builder, Integer studySubjectId, StudyEventDefinitionBean sed, String schedule) {
        String href1 = "CreateNewStudyEvent?studySubjectId=" + studySubjectId + "&studyEventDefinition=" + sed.getId();
        builder.a().href(href1);
        builder.close();
        builder.img().src("images/bt_Schedule.gif").border("0").align("left").close().aEnd();
        builder.nbsp().nbsp().a().href(href1);
        builder.close().append((Object)schedule).aEnd();
    }

    private void enterDataForStudyEventLinkBuilder(HtmlBuilder builder, String studyEventId, String view) {
        String href1 = "EnterDataForStudyEvent?eventId=" + studyEventId;
        builder.a().href(href1);
        builder.close();
        builder.img().src("images/bt_View.gif").border("0").align("left").close().aEnd();
        builder.nbsp().nbsp().a().href(href1);
        builder.close().append((Object)view).aEnd();
    }

    private void lockLinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1 = "javascript:leftnavExpand('Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onmouseover = "layersShowOrHide('visible','Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        onmouseover = onmouseover + "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_collapse.gif');";
        String onClick1 = "layersShowOrHide('hidden','Lock_all'); ";
        String onClick2 = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick3 = "layersShowOrHide('hidden','Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick4 = "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif'); ";
        builder.a().href(href1 + href2);
        builder.onmouseover(onmouseover);
        builder.onclick(onClick1 + onClick2 + onClick3 + onClick4);
        builder.close();
        builder.img().src("images/spacer.gif").border("0").append((Object)"height=\"30\"").width("50").close().aEnd();
    }

    private void repeatingLockLinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1 = "javascript:ExpandEventOccurrences('" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'," + studyEvents.size() + "); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onmouseover = "layersShowOrHide('visible','Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        onmouseover = onmouseover + "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_collapse.gif');";
        String onClick1 = "layersShowOrHide('hidden','Lock_all'); ";
        String onClick2 = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick3 = "layersShowOrHide('hidden','Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick4 = "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif'); ";
        builder.a().href(href1 + href2);
        builder.onmouseover(onmouseover);
        builder.onclick(onClick1 + onClick2 + onClick3 + onClick4);
        builder.close();
        builder.img().src("images/spacer.gif").border("0").append((Object)"height=\"30\"").width("50").close().aEnd();
    }

    private void repeatingIconLinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1 = "javascript:ExpandEventOccurrences('" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'," + studyEvents.size() + "); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onmouseover = "moveObject('Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "', event); ";
        onmouseover = onmouseover + "setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_expand.gif');";
        String onmouseout = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        onmouseout = onmouseout + "setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif');";
        String onClick1 = "layersShowOrHide('visible','Lock_all'); ";
        String onClick2 = "LockObject('Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "',event); ";
        builder.a().href(href1 + href2);
        builder.onmouseover(onmouseover);
        builder.onmouseout(onmouseout);
        builder.onclick(onClick1 + onClick2);
        builder.close();
    }

    private void iconLinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1Repeating = "javascript:ExpandEventOccurrences('" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'," + studyEvents.size() + "); ";
        String href1 = "javascript:leftnavExpand('Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onmouseover = "moveObject('Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "', event); ";
        onmouseover = onmouseover + "setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_expand.gif');";
        String onmouseout = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        onmouseout = onmouseout + "setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif');";
        String onClick1 = "layersShowOrHide('visible','Lock_all'); ";
        String onClick2 = "LockObject('Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "',event); ";
        String href = studyEvents.size() > 1 ? href1Repeating + href2 : href1 + href2;
        builder.a().href(href);
        builder.onmouseover(onmouseover);
        builder.onmouseout(onmouseout);
        builder.onclick(onClick1 + onClick2);
        builder.close();
    }

    private void divCloseRepeatinglinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1 = "javascript:ExpandEventOccurrences('" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'," + studyEvents.size() + "); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick1 = "layersShowOrHide('hidden','Lock_all'); ";
        String onClick2 = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick3 = "layersShowOrHide('hidden','Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick4 = "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif'); ";
        builder.a().href(href1 + href2);
        builder.onclick(onClick1 + onClick2 + onClick3 + onClick4);
        builder.close().append((Object)"X").aEnd();
    }

    private void linkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1 = "javascript:leftnavExpand('Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick1 = "layersShowOrHide('hidden','Lock_all'); ";
        String onClick2 = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick3 = "layersShowOrHide('hidden','Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick4 = "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif'); ";
        builder.a().href(href1 + href2);
        builder.onclick(onClick1 + onClick2 + onClick3 + onClick4);
        builder.close().append((Object)"X").aEnd();
    }

    private String formatDate(Date date) {
        String format = this.resformat.getString("date_format_string");
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    static /* synthetic */ ResourceBundle access$700(ListStudySubjectTableFactory x0) {
        return x0.resterms;
    }

    static /* synthetic */ StudyGroupDAO access$800(ListStudySubjectTableFactory x0) {
        return x0.studyGroupDAO;
    }

    static /* synthetic */ String access$900(ListStudySubjectTableFactory x0, SubjectBean x1, Integer x2, List x3, StudyEventDefinitionBean x4, StudySubjectBean x5) {
        return x0.eventDivBuilder(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ String access$1000(ListStudySubjectTableFactory x0, StudySubjectBean x1) {
        return x0.viewStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$1100(ListStudySubjectTableFactory x0, StudySubjectBean x1) {
        return x0.removeStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$1200(ListStudySubjectTableFactory x0, StudySubjectBean x1) {
        return x0.restoreStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$1300(ListStudySubjectTableFactory x0, StudySubjectBean x1) {
        return x0.reAssignStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$1400(ListStudySubjectTableFactory x0, StudySubjectBean x1) {
        return x0.signStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$1500(ListStudySubjectTableFactory x0, StudySubjectBean x1) throws Exception {
        return x0.pManageStatus(x1);
    }

    static /* synthetic */ String access$1600(ListStudySubjectTableFactory x0, StudySubjectBean x1) {
        return x0.participateStatus(x1);
    }

    static /* synthetic */ String access$1700(ListStudySubjectTableFactory x0, StudySubjectBean x1) throws Exception {
        return x0.viewParticipateBuilder(x1);
    }
}

